/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg;

import com.sun.cns.basicreg.BasicReg;
import com.sun.cns.basicreg.adapter.CCRAdapter;
import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.cacao.ClientLoginCacaoAdapter;
import com.sun.cns.basicreg.cacao.NetworkProxyCacaoAdapter;
import com.sun.cns.basicreg.cacao.OfferingCacaoAdapter;
import com.sun.cns.basicreg.cacao.PROMCacaoAdapter;
import com.sun.cns.basicreg.cacao.SWUPOMCacaoAdapter;
import com.sun.cns.basicreg.common.CmdLineGlobalObject;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.FileHdlr;
import com.sun.cns.basicreg.util.GetOpt;
import com.sun.cns.basicreg.wizard.util.Desktop;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.Response;
import com.sun.cns.basicreg.wizard.util.ResponseError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class BasicRegCLI {
    private static CmdLineGlobalObject globalObject = CmdLineGlobalObject.getInstance();
    private static final Logger LOG = Logger.getLogger(BasicRegCLI.class.getName());
    private Document document = null;
    private String userName = null;
    private String password = null;
    private String subscriptionKey = null;
    private String proxyHostName = null;
    private String proxyPort = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String failSafe = null;
    private String acceptTOUBCL = null;
    Properties prop = new Properties();
    private String publicKey = null;
    private String privateKey = null;
    private static String portalEnabledStatus = null;
    private static String portalEnabledService = null;
    private static String portalDisabledService = null;
    private static String subcommand = null;
    private static final String USERNAME_LBL = "userName";
    private static final String PASSWORD_LBL = "password";
    private static final String HOSTNAME_LBL = "hostName";
    private static final String SUBSCRIPTIONKEY_LBL = "subscriptionKey";
    private static final String PORTALENABLED_LBL = "portalEnabled";
    private static final String PROXYHOSTNAME_LBL = "proxyHostName";
    private static final String PROXYPORT_LBL = "proxyPort";
    private static final String PROXYUSERNAME_LBL = "proxyUsername";
    private static final String PROXYPASSWORD_LBL = "proxyPassword";
    public static final String[] PROPERTIES_LBLS = new String[]{"userName", "password", "subscriptionKey", "proxyHostName", "proxyPort", "proxyUsername", "proxyPassword"};
    public String[] propertiesName = PROPERTIES_LBLS;

    public static int processInputRegister(String[] args) {
        CmdLineGlobalObject.acceptTOUBCL = "false";
        CmdLineGlobalObject.failSafe = "false";
        CmdLineGlobalObject.neverRegister = "false";
        GetOpt getopt = new GetOpt(args, "ar:e:E:h:l:Np:su:x:");
        try {
            int c;
            while ((c = getopt.getNextOption()) != -1) {
                switch (c) {
                    case 97: {
                        LOG.info("Option:a ");
                        CmdLineGlobalObject.acceptTOUBCL = "true";
                        break;
                    }
                    case 114: {
                        LOG.info("Option:r " + getopt.getOptionArg());
                        CmdLineGlobalObject.registrationProfile = getopt.getOptionArg().trim();
                        break;
                    }
                    case 101: {
                        LOG.info("Option:e");
                        LOG.warning(I18N.getString("70.msg"));
                        System.err.println(I18N.getString("70.msg"));
                        CmdLineGlobalObject.portalEnabled = "false";
                        portalEnabledService = getopt.getOptionArg().trim();
                        break;
                    }
                    case 69: {
                        LOG.info("Option:E");
                        CmdLineGlobalObject.portalEnabled = "false";
                        portalDisabledService = getopt.getOptionArg().trim();
                        break;
                    }
                    case 104: {
                        LOG.info("Option:h " + getopt.getOptionArg());
                        LOG.warning(I18N.getString("70.msg"));
                        System.err.println(I18N.getString("70.msg"));
                        CmdLineGlobalObject.hostName = getopt.getOptionArg().trim();
                        break;
                    }
                    case 108: {
                        LOG.info("Option:l " + getopt.getOptionArg());
                        CmdLineGlobalObject.logLocation = getopt.getOptionArg().trim();
                        break;
                    }
                    case 78: {
                        LOG.info("Option:N " + getopt.getOptionArg());
                        CmdLineGlobalObject.neverRegister = "true";
                        break;
                    }
                    case 112: {
                        LOG.info("Option:p " + getopt.getOptionArg());
                        CmdLineGlobalObject.proxyPort = getopt.getOptionArg().trim();
                        BasicRegCLI.extractHostPort();
                        break;
                    }
                    case 115: {
                        LOG.info("Option:s ");
                        CmdLineGlobalObject.failSafe = "true";
                        break;
                    }
                    case 117: {
                        LOG.info("Option:u " + getopt.getOptionArg());
                        CmdLineGlobalObject.userName = getopt.getOptionArg().trim();
                        break;
                    }
                    case 120: {
                        LOG.info("Option:x " + getopt.getOptionArg());
                        CmdLineGlobalObject.proxyUsername = getopt.getOptionArg().trim();
                    }
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.severe("Error:" + ex.getMessage());
            System.err.println(I18N.getString("560.err"));
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }

    public static int processInputProxy(String[] args) {
        CmdLineGlobalObject.acceptTOUBCL = "false";
        CmdLineGlobalObject.failSafe = "false";
        CmdLineGlobalObject.neverRegister = "false";
        GetOpt getopt = new GetOpt(args, "r:l:p:x:");
        try {
            int c;
            while ((c = getopt.getNextOption()) != -1) {
                switch (c) {
                    case 114: {
                        LOG.info("Option:r " + getopt.getOptionArg());
                        CmdLineGlobalObject.registrationProfile = getopt.getOptionArg().trim();
                        break;
                    }
                    case 108: {
                        LOG.info("Option:l " + getopt.getOptionArg());
                        CmdLineGlobalObject.logLocation = getopt.getOptionArg().trim();
                        break;
                    }
                    case 112: {
                        LOG.info("Option:p " + getopt.getOptionArg());
                        CmdLineGlobalObject.proxyPort = getopt.getOptionArg().trim();
                        BasicRegCLI.extractHostPort();
                        break;
                    }
                    case 120: {
                        LOG.info("Option:x " + getopt.getOptionArg());
                        CmdLineGlobalObject.proxyUsername = getopt.getOptionArg().trim();
                    }
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.severe("Error:" + ex.getMessage());
            System.err.println(I18N.getString("560.err"));
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }

    public boolean validatePropertiesName() {
        boolean found = false;
        boolean validation = true;
        if (CmdLineGlobalObject.registrationProfile != null) {
            this.loadPropertiesFromFile(CmdLineGlobalObject.registrationProfile);
            if (this.prop != null) {
                Enumeration<?> e = this.prop.propertyNames();
                while (e.hasMoreElements()) {
                    String tmp = e.nextElement().toString();
                    if (tmp.equals(HOSTNAME_LBL) || tmp.equals(PORTALENABLED_LBL)) continue;
                    found = false;
                    for (int i = 0; i < PROPERTIES_LBLS.length; ++i) {
                        if (!tmp.equalsIgnoreCase(PROPERTIES_LBLS[i])) continue;
                        this.propertiesName[i] = tmp;
                        found = true;
                    }
                    if (found) continue;
                    System.err.println("The properties name " + tmp + " is incorrect ");
                    validation = false;
                }
            }
        }
        return validation;
    }

    public boolean validateInput() {
        boolean validation;
        block20: {
            block24: {
                block21: {
                    block23: {
                        block22: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                validation = true;
                                                if (CmdLineGlobalObject.userName == null) break block15;
                                                if (CmdLineGlobalObject.userName.trim().length() >= 1) break block16;
                                            }
                                            LOG.severe(I18N.getString("500.err"));
                                            System.err.println(I18N.getString("500.err"));
                                            validation = false;
                                        }
                                        if (CmdLineGlobalObject.password == null) break block17;
                                        if (CmdLineGlobalObject.password.trim().length() >= 1) break block18;
                                    }
                                    LOG.severe(I18N.getString("510.err"));
                                    System.err.println(I18N.getString("510.err"));
                                    validation = false;
                                }
                                if (portalEnabledService == null || portalDisabledService == null) break block19;
                                LOG.severe(I18N.getString("600.err"));
                                System.err.println(I18N.getString("600.err"));
                                validation = false;
                                break block20;
                            }
                            if (portalEnabledService != null && !portalEnabledService.equalsIgnoreCase("softwareUpdate") || portalDisabledService != null && !portalDisabledService.equalsIgnoreCase("softwareUpdate")) {
                                LOG.severe(I18N.getString("590.err"));
                                System.err.println(I18N.getString("590.err"));
                                validation = false;
                            }
                            if (portalEnabledService != null && !portalEnabledService.equalsIgnoreCase("softwareUpdate")) break block20;
                            if (CmdLineGlobalObject.portalEnabled == null) break block21;
                            if (CmdLineGlobalObject.portalEnabled.equalsIgnoreCase("true")) break block22;
                            if (CmdLineGlobalObject.portalEnabled.equalsIgnoreCase("false")) break block22;
                            LOG.severe(I18N.getString("520.err"));
                            System.err.println(I18N.getString("520.err"));
                            validation = false;
                            break block20;
                        }
                        if (!CmdLineGlobalObject.portalEnabled.equalsIgnoreCase("true")) break block20;
                        if (CmdLineGlobalObject.subscriptionKey == null) break block23;
                        if (CmdLineGlobalObject.subscriptionKey.trim().length() >= 1) break block20;
                    }
                    LOG.severe(I18N.getString("530.err"));
                    System.err.println(I18N.getString("530.err"));
                    validation = false;
                    break block20;
                }
                if (!portalEnabledStatus.equals("enabled")) break block20;
                if (CmdLineGlobalObject.subscriptionKey == null) break block24;
                if (CmdLineGlobalObject.subscriptionKey.trim().length() >= 1) break block20;
            }
            LOG.severe(I18N.getString("530.err"));
            System.err.println(I18N.getString("530.err"));
            validation = false;
        }
        return validation;
    }

    public boolean validateProxyInput() {
        boolean validation;
        block27: {
            block29: {
                block28: {
                    block25: {
                        block26: {
                            block23: {
                                block24: {
                                    block21: {
                                        block22: {
                                            validation = true;
                                            if (CmdLineGlobalObject.proxyHost != null) {
                                                if (CmdLineGlobalObject.proxyHost.trim().length() < 1) {
                                                    CmdLineGlobalObject.proxyHost = null;
                                                }
                                            }
                                            if (CmdLineGlobalObject.proxyPort != null) {
                                                if (CmdLineGlobalObject.proxyPort.trim().length() < 1) {
                                                    CmdLineGlobalObject.proxyPort = null;
                                                }
                                            }
                                            if (CmdLineGlobalObject.proxyUsername != null) {
                                                if (CmdLineGlobalObject.proxyUsername.trim().length() < 1) {
                                                    CmdLineGlobalObject.proxyUsername = null;
                                                }
                                            }
                                            if (CmdLineGlobalObject.proxyPassword != null) {
                                                if (CmdLineGlobalObject.proxyPassword.trim().length() < 1) {
                                                    CmdLineGlobalObject.proxyPassword = null;
                                                }
                                            }
                                            if (CmdLineGlobalObject.proxyHost == null) break block21;
                                            if (CmdLineGlobalObject.proxyHost.trim().length() <= 1) break block21;
                                            if (CmdLineGlobalObject.proxyPort == null) break block22;
                                            if (CmdLineGlobalObject.proxyPort.trim().length() >= 1) break block21;
                                        }
                                        LOG.severe(I18N.getString("570.err"));
                                        System.err.println(I18N.getString("570.err"));
                                        validation = false;
                                    }
                                    if (CmdLineGlobalObject.proxyPort == null) break block23;
                                    if (CmdLineGlobalObject.proxyPort.trim().length() <= 0) break block23;
                                    if (CmdLineGlobalObject.proxyHost == null) break block24;
                                    if (CmdLineGlobalObject.proxyHost.trim().length() >= 1) break block23;
                                }
                                LOG.severe(I18N.getString("575.err"));
                                System.err.println(I18N.getString("575.err"));
                                validation = false;
                            }
                            if (CmdLineGlobalObject.proxyUsername == null) break block25;
                            if (CmdLineGlobalObject.proxyUsername.trim().length() <= 1) break block25;
                            if (CmdLineGlobalObject.proxyPassword == null) break block26;
                            if (CmdLineGlobalObject.proxyPassword.trim().length() >= 1) break block25;
                        }
                        LOG.severe(I18N.getString("580.err"));
                        System.err.println(I18N.getString("580.err"));
                        validation = false;
                    }
                    if (CmdLineGlobalObject.proxyUsername == null) break block27;
                    if (CmdLineGlobalObject.proxyUsername.trim().length() <= 1) break block27;
                    if (CmdLineGlobalObject.proxyPassword == null) break block27;
                    if (CmdLineGlobalObject.proxyPassword.trim().length() <= 1) break block27;
                    if (CmdLineGlobalObject.proxyHost == null) break block28;
                    if (CmdLineGlobalObject.proxyHost.trim().length() < 1) break block29;
                }
                if (CmdLineGlobalObject.proxyHost != null) break block27;
            }
            LOG.severe(I18N.getString("620.err"));
            System.err.println(I18N.getString("620.err"));
            validation = false;
        }
        if (validation && !(validation = this.setProxy())) {
            LOG.severe(I18N.getString("610.err"));
            System.err.println(I18N.getString("610.err"));
            validation = false;
        }
        return validation;
    }

    public static void main(String[] args) {
        LOG.info(I18N.getString("10.msg"));
        System.out.println(I18N.getString("10.msg"));
        subcommand = args[0];
        String[] argsOther = new String[args.length - 1];
        System.arraycopy(args, 1, argsOther, 0, args.length - 1);
        BasicReg basicReg = new BasicReg();
        if (subcommand.equalsIgnoreCase("register")) {
            if (BasicRegCLI.processInputRegister(argsOther) > 0) {
                System.exit(1);
            }
            if (CmdLineGlobalObject.neverRegister.equalsIgnoreCase("true")) {
                if (!FileHdlr.fileCreate("/usr/lib/breg/data/.nvreg")) {
                    LOG.severe("REG_NEVER: cannot set 'Never Register' marker");
                }
                System.exit(1);
            }
            portalEnabledStatus = "disabled";
            BasicRegCLI theCLI = new BasicRegCLI();
            if (!theCLI.validatePropertiesName()) {
                System.exit(1);
            }
            basicReg.loadPropertiesFromHomeDir();
            if (CmdLineGlobalObject.logLocation != null) {
                CmdLineGlobalObject.logLocation = CmdLineGlobalObject.logLocation.concat("/");
                globalObject.setPropertyValue("log.location", CmdLineGlobalObject.logLocation);
            }
            theCLI.initialize();
            if (!theCLI.validateInput()) {
                System.exit(1);
            }
            if (!theCLI.validateProxyInput()) {
                System.exit(1);
            }
            theCLI.updateProxyInMSC();
            theCLI.run();
        } else if (subcommand.equalsIgnoreCase("proxy")) {
            BasicRegCLI theCLI;
            if (BasicRegCLI.processInputProxy(argsOther) > 0) {
                System.exit(1);
            }
            if (!(theCLI = new BasicRegCLI()).validatePropertiesName()) {
                System.exit(1);
            }
            theCLI.initialize();
            if (!theCLI.validateProxyInput()) {
                System.exit(1);
            }
            theCLI.printRegistrationProfile();
            theCLI.updateProxyInMSC();
        }
    }

    public void initialize() {
        if (CmdLineGlobalObject.registrationProfile != null && this.prop != null) {
            this.userName = this.findEntry(this.propertiesName[0]);
            this.password = this.findEntry(this.propertiesName[1]);
            this.subscriptionKey = this.findEntry(this.propertiesName[2]);
            this.proxyHostName = this.findEntry(this.propertiesName[3]);
            this.proxyPort = this.findEntry(this.propertiesName[4]);
            this.proxyUsername = this.findEntry(this.propertiesName[5]);
            this.proxyPassword = this.findEntry(this.propertiesName[6]);
            if (CmdLineGlobalObject.userName == null) {
                CmdLineGlobalObject.userName = this.userName;
            }
            if (CmdLineGlobalObject.password == null) {
                CmdLineGlobalObject.password = this.password;
            }
            CmdLineGlobalObject.hostName = "";
            if (CmdLineGlobalObject.subscriptionKey == null) {
                CmdLineGlobalObject.subscriptionKey = this.subscriptionKey;
            }
            CmdLineGlobalObject.portalEnabled = "false";
            if (CmdLineGlobalObject.proxyHost == null) {
                CmdLineGlobalObject.proxyHost = this.proxyHostName;
            }
            if (CmdLineGlobalObject.proxyPort == null) {
                CmdLineGlobalObject.proxyPort = this.proxyPort;
            }
            if (CmdLineGlobalObject.proxyUsername == null) {
                CmdLineGlobalObject.proxyUsername = this.proxyUsername;
            }
            if (CmdLineGlobalObject.proxyPassword == null) {
                CmdLineGlobalObject.proxyPassword = this.proxyPassword;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block31: {
            block30: {
                token = null;
                this.printRegistrationProfile();
                BasicRegCLI.LOG.info(I18N.getString("20.msg"));
                System.out.println(I18N.getString("20.msg"));
                i = this.authenticateUser(CmdLineGlobalObject.userName, CmdLineGlobalObject.password);
                if (i < 0) {
                    BasicRegCLI.LOG.severe(I18N.getString("300.err"));
                    System.err.println(I18N.getString("300.err"));
                    System.out.println("failed registration!");
                    System.exit(1);
                }
                offeringName = "Use Sun Update Manager and Sun Update Connection to manage updates";
                try {
                    OfferingCacaoAdapter.activate(offeringName, null);
                }
                catch (CacaoAdapterException caEx) {
                    BasicRegCLI.LOG.severe("Error in SCN/Cacao offering activation");
                    BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                    System.out.println("failed registration!");
                    System.exit(1);
                }
                if (CmdLineGlobalObject.portalEnabled == null) break block30;
                if (!CmdLineGlobalObject.portalEnabled.equals("true")) break block30;
                if (CmdLineGlobalObject.subscriptionKey == null) break block31;
                try {
                    SWUPOMCacaoAdapter.setSubscriptionKey(CmdLineGlobalObject.subscriptionKey);
                }
                catch (CacaoAdapterException caEx) {
                    BasicRegCLI.LOG.severe("Error in SWOM/Cacao SetSubsriptionKey");
                    BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                    System.out.println("failed registration!");
                    System.exit(1);
                }
                if (CmdLineGlobalObject.hostName == null) ** GOTO lbl-1000
                if (CmdLineGlobalObject.hostName != "") {
                    try {
                        OfferingCacaoAdapter.activate("Register the Solaris software without choosing an update option", null);
                        hostname = CmdLineGlobalObject.hostName;
                        OfferingCacaoAdapter.activate("Use Sun Update Manager and Sun Update Connection to manage updates", null);
                        SWUPOMCacaoAdapter.setSystemDisplayName(hostname);
                    }
                    catch (CacaoAdapterException caEx) {
                        BasicRegCLI.LOG.severe("Error in SWOM/Cacao setSystemDisplayName");
                        BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                        System.out.println("failed registration!");
                        System.exit(1);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    try {
                        OfferingCacaoAdapter.activate("Register the Solaris software without choosing an update option", null);
                        hostname = PROMCacaoAdapter.getHostName();
                        OfferingCacaoAdapter.activate("Use Sun Update Manager and Sun Update Connection to manage updates", null);
                        SWUPOMCacaoAdapter.setSystemDisplayName(hostname);
                    }
                    catch (CacaoAdapterException caEx) {
                        BasicRegCLI.LOG.severe("Error in SWOM/Cacao setSystemDisplayName");
                        BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                        System.out.println("failed registration!");
                        System.exit(1);
                    }
                }
                try {
                    SWUPOMCacaoAdapter.setSWUPPortalEnabled(true);
                }
                catch (CacaoAdapterException caEx) {
                    BasicRegCLI.LOG.severe("Error in SWOM/Cacao SetSWUPportalEnable to true");
                    BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                    System.out.println("failed registration!");
                    System.exit(1);
                }
                break block31;
            }
            try {
                SWUPOMCacaoAdapter.setSWUPPortalEnabled(false);
            }
            catch (CacaoAdapterException caEx) {
                BasicRegCLI.LOG.severe("Error in SWOM/Cacao SetSWUPportalEnable to false");
                BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                System.out.println("failed registration!");
                System.exit(1);
            }
            try {
                SWUPOMCacaoAdapter.setSystemDisplayName("");
            }
            catch (CacaoAdapterException caEx) {
                BasicRegCLI.LOG.severe("Error in SWOM/Cacao setSystemDisplayName to null");
                BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                System.out.println("failed registration!");
                System.exit(1);
            }
            if (CmdLineGlobalObject.subscriptionKey != null) {
                try {
                    SWUPOMCacaoAdapter.setSubscriptionKey(CmdLineGlobalObject.subscriptionKey);
                }
                catch (CacaoAdapterException caEx) {
                    BasicRegCLI.LOG.severe("Error in SWOM/Cacao SetSubsriptionKey ");
                    BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                    System.out.println("failed registration!");
                    System.exit(1);
                }
            } else {
                try {
                    SWUPOMCacaoAdapter.setSubscriptionKey("");
                }
                catch (CacaoAdapterException caEx) {
                    BasicRegCLI.LOG.severe("Error in SWOM/Cacao SetSubsriptionKey to null");
                    BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
                    System.out.println("failed registration!");
                    System.exit(1);
                }
            }
        }
        swupomregisterSystemResult = 0;
        try {
            swupomregisterSystemResult = SWUPOMCacaoAdapter.registerSystem();
        }
        catch (CacaoAdapterException caEx) {
            BasicRegCLI.LOG.severe("Error in PROM/Cacao register system");
            BasicRegCLI.LOG.severe(CommonUtil.getStackTrace(caEx));
            System.exit(1);
        }
        if (swupomregisterSystemResult != 0) {
            System.out.println("failed registration!");
            System.exit(1);
        }
        BasicRegCLI.LOG.info("Remove BasigReg icons from user's desktop");
        if (!Desktop.removeDesktopIcon()) {
            BasicRegCLI.LOG.severe("Failed to remove some desktop icon(s)");
        }
        System.out.println("finish registration!");
        System.exit(0);
    }

    private void updateProxyInMSC() {
        try {
            NetworkProxyCacaoAdapter.setProxy(true, CmdLineGlobalObject.proxyHost, CmdLineGlobalObject.proxyPort, true, CmdLineGlobalObject.proxyUsername, CmdLineGlobalObject.proxyPassword);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error obtaining Cacao network proxy information");
            LOG.severe(CommonUtil.getStackTrace(caEx));
            System.exit(1);
        }
    }

    private boolean updatePatchProProxy() {
        boolean success = true;
        return success;
    }

    private boolean setProxy() {
        boolean isOK = true;
        return isOK;
    }

    public void reLoadProxyFromCCR() {
        String httpProxyAuth;
        String temp = null;
        if (CmdLineGlobalObject.proxyHost == null && (temp = CCRAdapter.getValue(CCRAdapter.HTTP_PROXY_IP)) != null && temp.trim().length() > 1) {
            CmdLineGlobalObject.proxyHost = CCRAdapter.getValue(CCRAdapter.HTTP_PROXY_IP);
            LOG.info("loading proxyHost from CCR = " + CmdLineGlobalObject.proxyHost);
        }
        if (CmdLineGlobalObject.proxyPort == null && (temp = CCRAdapter.getValue(CCRAdapter.HTTP_PROXY_PORT)) != null && temp.trim().length() > 0) {
            CmdLineGlobalObject.proxyPort = CCRAdapter.getValue(CCRAdapter.HTTP_PROXY_PORT);
            LOG.info("loading proxyPort from CCR = " + CmdLineGlobalObject.proxyPort);
        }
        if ((httpProxyAuth = CCRAdapter.getValue(CCRAdapter.HTTP_PROXY_AUTH)) != null) {
            StringTokenizer st = new StringTokenizer(httpProxyAuth, ":");
            int index = 0;
            temp = null;
            try {
                while (st.hasMoreElements()) {
                    temp = (String)st.nextElement();
                    if (index == 0) {
                        if (CmdLineGlobalObject.proxyUsername == null && temp != null && temp.trim().length() > 1) {
                            CmdLineGlobalObject.proxyUsername = temp;
                            LOG.info("loading proxyUsername from CCR = " + CmdLineGlobalObject.proxyUsername);
                        }
                    } else if (index == 1) {
                        if (CmdLineGlobalObject.proxyPassword == null && temp != null && temp.trim().length() > 0) {
                            CmdLineGlobalObject.proxyPassword = temp;
                            LOG.info("loading proxyPassword from CCR = *** ");
                        }
                    }
                    ++index;
                }
            }
            catch (NoSuchElementException e) {
                LOG.severe(CommonUtil.getStackTrace(e));
            }
        }
    }

    public static void extractHostPort() {
        if (CmdLineGlobalObject.proxyPort != null) {
            if (CmdLineGlobalObject.proxyPort.indexOf(":") < 0) {
                CmdLineGlobalObject.proxyHost = CmdLineGlobalObject.proxyPort;
                CmdLineGlobalObject.proxyPort = null;
            } else if (CmdLineGlobalObject.proxyPort.indexOf(":") == 0) {
                StringTokenizer st = new StringTokenizer(CmdLineGlobalObject.proxyPort, ":");
                String temp = null;
                try {
                    while (st.hasMoreElements()) {
                        temp = (String)st.nextElement();
                        CmdLineGlobalObject.proxyPort = temp;
                    }
                }
                catch (NoSuchElementException e) {
                    LOG.severe(CommonUtil.getStackTrace(e));
                }
            } else if (CmdLineGlobalObject.proxyPort.indexOf(":") > 0) {
                StringTokenizer st = new StringTokenizer(CmdLineGlobalObject.proxyPort, ":");
                int index = 0;
                String temp = null;
                try {
                    while (st.hasMoreElements()) {
                        temp = (String)st.nextElement();
                        if (index == 0) {
                            CmdLineGlobalObject.proxyHost = temp;
                        } else if (index == 1) {
                            CmdLineGlobalObject.proxyPort = temp != null && temp.length() > 0 ? temp : null;
                        }
                        ++index;
                    }
                    if (index == 1) {
                        CmdLineGlobalObject.proxyPort = null;
                    }
                }
                catch (NoSuchElementException e) {
                    LOG.severe(CommonUtil.getStackTrace(e));
                }
            }
        }
    }

    private int authenticateUser(String userName, String password) {
        int scnAccountLoginResult = 0;
        try {
            scnAccountLoginResult = ClientLoginCacaoAdapter.loginAccount(userName, password);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error in SCN/Cacao account login");
            LOG.severe(CommonUtil.getStackTrace(caEx));
            System.exit(1);
        }
        return scnAccountLoginResult;
    }

    private int getSystemInfo() {
        Document document = null;
        try {
            document = PROMCacaoAdapter.getSystemInformation(1);
        }
        catch (CacaoAdapterException cacaoAdapterException) {
            // empty catch block
        }
        return 1;
    }

    public void extractProperties(String data) {
        StringTokenizer st = new StringTokenizer(data, "=");
        int index = 0;
        String key = null;
        String value = "";
        String temp = null;
        try {
            while (st.hasMoreElements() && !(temp = (String)st.nextElement()).trim().startsWith("#")) {
                if (index == 0) {
                    key = temp.trim();
                } else if (index == 1) {
                    value = temp;
                }
                ++index;
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("error in extractProperties");
        }
        if (key != null) {
            this.prop.setProperty(key, value);
        }
    }

    public void loadPropertiesFromFile(String identifier) {
        File propFile = new File(identifier);
        if ((propFile = propFile.getAbsoluteFile()).exists()) {
            String parentPath = propFile.getParent();
            LOG.info("parentPath = " + parentPath);
            LOG.info("CLI registration profile found @ " + identifier);
            try {
                FileReader iS = new FileReader(propFile);
                if (iS != null) {
                    try {
                        BufferedReader input = new BufferedReader(iS);
                        String data = null;
                        while ((data = input.readLine()) != null) {
                            this.extractProperties(data);
                        }
                        input.close();
                    }
                    catch (IOException ie) {
                        LOG.severe("error loading properties " + ie.getMessage());
                    }
                }
                iS.close();
            }
            catch (IOException ie) {
                LOG.severe("error reading properties file " + ie.getMessage());
                this.prop = null;
            }
        } else {
            String parentPath = propFile.getParent();
            LOG.info("parentPath = " + parentPath);
            LOG.severe("CLI registration profile not found: " + identifier);
            System.err.println(I18N.getString("550.err") + ": " + identifier);
            System.exit(1);
            this.prop = null;
        }
    }

    public void loadProperties(String identifier) {
        File propFile = new File(identifier);
        if ((propFile = propFile.getAbsoluteFile()).exists()) {
            String parentPath = propFile.getParent();
            LOG.info("parentPath = " + parentPath);
            LOG.info("CLI registration profile found @ " + identifier);
            try {
                FileInputStream iS = new FileInputStream(propFile);
                if (iS != null) {
                    try {
                        this.prop.load(iS);
                    }
                    catch (IOException ie) {
                        LOG.severe("error loading properties " + ie.getMessage());
                    }
                }
                iS.close();
            }
            catch (IOException ie) {
                LOG.severe("error reading properties file " + ie.getMessage());
                this.prop = null;
            }
        } else {
            String parentPath = propFile.getParent();
            LOG.info("parentPath = " + parentPath);
            LOG.severe("CLI registration profile not found: " + identifier);
            System.err.println(I18N.getString("550.err") + ": " + identifier);
            System.exit(1);
            this.prop = null;
        }
    }

    private void printRegistrationProfile() {
        if (CmdLineGlobalObject.userName != null) {
            LOG.info("userName = " + CmdLineGlobalObject.userName);
        }
        if (CmdLineGlobalObject.password != null) {
            LOG.info("password = ***** ");
        }
        if (CmdLineGlobalObject.hostName != null) {
            LOG.info("hostName =" + CmdLineGlobalObject.hostName);
        }
        if (CmdLineGlobalObject.subscriptionKey != null) {
            LOG.info("subscriptionKey = ******** ");
        }
        if (CmdLineGlobalObject.portalEnabled != null) {
            LOG.info("portalEnabled =" + CmdLineGlobalObject.portalEnabled);
        }
        if (CmdLineGlobalObject.proxyHost != null) {
            LOG.info("proxyHost = " + CmdLineGlobalObject.proxyHost);
        }
        if (CmdLineGlobalObject.proxyPort != null) {
            LOG.info("proxyPort = " + CmdLineGlobalObject.proxyPort);
        }
        if (CmdLineGlobalObject.proxyUsername != null) {
            LOG.info("proxyUsername = " + CmdLineGlobalObject.proxyUsername);
        }
        if (CmdLineGlobalObject.proxyPassword != null) {
            LOG.info("proxyPassword = **** ");
        }
    }

    private Response constructResponse(Document theDocument) {
        Response response = null;
        ArrayList<ResponseError> errorList = new ArrayList<ResponseError>();
        String result = "";
        ElementFilter filter = new ElementFilter("Response");
        Iterator theIter = theDocument.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                String type = element.getAttributeValue("type");
                String text = element.getText();
                response = new Response(text, type);
                ElementFilter errorFilter = new ElementFilter("Error");
                Iterator theErrorIter = theDocument.getDescendants((Filter)errorFilter);
                while (theErrorIter.hasNext()) {
                    try {
                        Element elementError = (Element)theErrorIter.next();
                        ResponseError responseError = new ResponseError(elementError.getText(), elementError.getAttributeValue("type"), elementError.getAttributeValue("code"), elementError.getAttributeValue("severity"));
                        errorList.add(responseError);
                    }
                    catch (NullPointerException npe) {
                        LOG.severe(CommonUtil.getStackTrace(npe));
                    }
                }
                response.setErrorList(errorList);
            }
            catch (NullPointerException npe) {
                LOG.severe(CommonUtil.getStackTrace(npe));
            }
        }
        return response;
    }

    public String findEntry(String propertyKey) {
        if (this.prop == null) {
            LOG.warning("WARNING - null properties object");
            return null;
        }
        if (this.prop.getProperty(propertyKey) != null) {
            if (propertyKey.equalsIgnoreCase(PASSWORD_LBL) || propertyKey.equalsIgnoreCase(PROXYPASSWORD_LBL)) {
                return this.prop.getProperty(propertyKey);
            }
            return this.prop.getProperty(propertyKey).trim();
        }
        return null;
    }

    public Document handlePublicPrivateKey() {
        Document result = null;
        return result;
    }
}

