/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg;

import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.cacao.PROMCacaoAdapter;
import com.sun.cns.basicreg.cacao.SWUPOMCacaoAdapter;
import com.sun.cns.basicreg.common.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class Collector {
    private static final Logger LOG = Logger.getLogger(Collector.class.getName());

    public List getSystemsXMLFromPROM() {
        LOG.info("Collector - getSystemsXMLFromPROM");
        Document document = null;
        try {
            document = PROMCacaoAdapter.getSystemInformation(1);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error in PROM/Cacao get SWUP Full system information");
            LOG.severe(CommonUtil.getStackTrace(caEx));
            return null;
        }
        if (document == null) {
            LOG.info("Null document - PROM/Cacao get SWUP Full system info");
            return null;
        }
        return this.getXMLOutputStringArrayList(document);
    }

    public List getLimitedSystemsXMLFromPROM() {
        LOG.info("Collector - getLimitedSystemsXMLFromPROM");
        Document document = null;
        try {
            document = PROMCacaoAdapter.getSystemInformation(2);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error in PROM/Cacao get SWUP Limited system information");
            LOG.severe(CommonUtil.getStackTrace(caEx));
            return null;
        }
        if (document == null) {
            LOG.info("Null document - PROM/Cacao get SWUP Limited system info");
            return null;
        }
        return this.getXMLOutputStringArrayList(document);
    }

    public List getSolarisSystemsXMLFromPROM() {
        LOG.info("Collector - getSolarisSystemsXMLFromPROM");
        Document document = null;
        try {
            document = PROMCacaoAdapter.getSystemInformation(3);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error in PROM/Cacao get Solaris system information");
            LOG.severe(CommonUtil.getStackTrace(caEx));
            return null;
        }
        if (document == null) {
            LOG.info("Null document - PROM/Cacao get Solaris system info");
            return null;
        }
        return this.getXMLOutputStringArrayList(document);
    }

    public String getHostNameFromPROM() {
        LOG.info("Collector - getHostNameFromPROM");
        String hostname = "";
        try {
            hostname = PROMCacaoAdapter.getHostName();
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error in PROM/Cacao get host name");
            LOG.severe(CommonUtil.getStackTrace(caEx));
            return "";
        }
        return hostname;
    }

    public String getLPSUrl() {
        String lpsUrl = "";
        LOG.info("Get LPSURL: " + lpsUrl);
        lpsUrl = SWUPOMCacaoAdapter.getLPSURL();
        LOG.info("Get LPSURL: " + lpsUrl);
        return lpsUrl;
    }

    private ArrayList getXMLOutputStringArrayList(Document document) {
        ArrayList<String> theList = new ArrayList<String>();
        XMLOutputter xout = new XMLOutputter();
        String theString = xout.outputString(document);
        theList.add(theString);
        return theList;
    }
}

