/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.adapter;

import com.sun.cns.basicreg.adapter.CCRAdapter;
import com.sun.cns.basicreg.adapter.CSMAuthAdapter;
import com.sun.cns.basicreg.common.CmdLineGlobalObject;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.ProxyManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Security;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class Adapter {
    private static String[] envp = new String[]{"LC_ALL=C"};
    static Document theDocument;
    static String ENDPOINT;
    protected static Logger LOG;
    protected static boolean secureHTTP;

    protected static String findEntry(String inString) {
        String result = "";
        String WIDGET = "widget";
        String ID = "id";
        String RESPONSE = "response";
        ElementFilter filter = new ElementFilter(WIDGET);
        Iterator theIter = theDocument.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                String test;
                Element element = (Element)theIter.next();
                String str = element.getAttributeValue(ID);
                if (!str.equals(inString)) continue;
                result = test = element.getChildText(RESPONSE);
                break;
            }
            catch (NullPointerException npe) {
            }
        }
        return result;
    }

    protected static boolean isWizardOutputFileFound(String inString) {
        boolean result = false;
        String WIZARD = "wizard";
        String OUTPUTFILE = "outputfile";
        ElementFilter filter = new ElementFilter(WIZARD);
        Iterator theIter = theDocument.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                String str = element.getAttributeValue(OUTPUTFILE);
                if (!str.equals(inString)) continue;
                LOG.info("wizard outputfile = " + inString + " has found !");
                result = true;
                break;
            }
            catch (NullPointerException npe) {
            }
        }
        return result;
    }

    protected void setInitialURL(String url) {
        ENDPOINT = url;
    }

    protected void reLoadURL(String property) {
        CmdLineGlobalObject globalObject = CmdLineGlobalObject.getInstance();
        if (CmdLineGlobalObject.prop != null) {
            if (CmdLineGlobalObject.prop.getProperty(property) != null) {
                ENDPOINT = CmdLineGlobalObject.prop.getProperty(property);
            }
        }
        if (ENDPOINT.toLowerCase().startsWith("https")) {
            if (!secureHTTP) {
                Security.addProvider((java.security.Provider)new Provider());
                secureHTTP = true;
            }
        } else {
            secureHTTP = false;
        }
    }

    protected void reLoadProxyFromCCR() {
        if (!(!this.initialzeCSMAuthAdapter() || Adapter.isProxyEnabled() && Adapter.isSecureProxyEnabled())) {
            String httpProxyHost = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.HTTP_PROXY_IP);
            String httpProxyPort = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.HTTP_PROXY_PORT);
            String httpProxyAuth = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.HTTP_PROXY_AUTH);
            String httpProxyUser = null;
            String httpProxyPass = null;
            LOG.info("loading proxyHost from CCR = " + httpProxyHost);
            LOG.info("loading proxyPort from CCR = " + httpProxyPort);
            LOG.info("loading proxyAuth from CCR = *** ");
            if (httpProxyAuth != null) {
                StringTokenizer st = new StringTokenizer(httpProxyAuth, "@");
                int index = 0;
                try {
                    while (st.hasMoreElements()) {
                        if (index == 0) {
                            httpProxyUser = (String)st.nextElement();
                            LOG.info("loading proxyUser from CCR = " + httpProxyUser);
                        } else if (index == 1) {
                            httpProxyPass = (String)st.nextElement();
                            LOG.info("loading proxyPass from CCR = *** ");
                        }
                        ++index;
                    }
                }
                catch (NoSuchElementException e) {
                    LOG.severe(CommonUtil.getStackTrace(e));
                }
            }
            Properties proxyProperties = new Properties();
            if (httpProxyHost != null && httpProxyHost.trim().length() > 1) {
                proxyProperties.setProperty("http.proxySet", "true");
                proxyProperties.setProperty("http.proxyHost", httpProxyHost);
                proxyProperties.setProperty("http.proxyPort", httpProxyPort);
                if (httpProxyUser != null) {
                    proxyProperties.setProperty("http.proxyUser", httpProxyUser);
                    proxyProperties.setProperty("https.proxyUser", httpProxyUser);
                }
                if (httpProxyPass != null) {
                    proxyProperties.setProperty("http.proxyPassword", httpProxyPass);
                    proxyProperties.setProperty("https.proxyPassword", httpProxyPass);
                }
                proxyProperties.setProperty("https.proxySet", "true");
                proxyProperties.setProperty("https.proxyHost", httpProxyHost);
                proxyProperties.setProperty("https.proxyPort", httpProxyPort);
                ProxyManager proxyManager = ProxyManager.getInstance();
                proxyManager.loadProxyProperties(proxyProperties);
            }
        }
    }

    protected void setLogger(Logger logger) {
        LOG = logger;
    }

    protected static boolean connectToSun() {
        ProxyManager proxyManager = ProxyManager.getInstance();
        boolean result = secureHTTP ? proxyManager.testSettings(ProxyManager.HTTPS_URL) : proxyManager.testSettings(ProxyManager.HTTP_URL);
        if (!secureHTTP && Adapter.isProxyEnabled()) {
            if (result) {
                LOG.info(" proxy tested OK !");
            } else {
                LOG.severe(" proxy tested not OK  !");
            }
        } else if (secureHTTP && Adapter.isSecureProxyEnabled()) {
            if (result) {
                LOG.info(" secure proxy tested OK !");
            } else {
                LOG.severe(" secure proxy tested not OK  !");
            }
        } else if (result) {
            LOG.info(" internet connection tested OK !");
        } else {
            LOG.info(" internet connection tested not OK !");
        }
        return result;
    }

    protected static boolean isProxyEnabled() {
        ProxyManager proxyManager = ProxyManager.getInstance();
        return proxyManager.isProxyEnabled();
    }

    protected static boolean isSecureProxyEnabled() {
        ProxyManager proxyManager = ProxyManager.getInstance();
        return proxyManager.isSecureProxyEnabled();
    }

    protected String getInstallLocation(String pkgName) {
        LOG.info("Determine BasicReg package installation directory...");
        String cmd = "/usr/bin/pkginfo -r " + pkgName;
        String result = null;
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.severe("Cannot exec " + cmd);
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            s = input.readLine();
            if (s == null || s.length() < 1) {
                LOG.log(Level.SEVERE, "Unable to determine " + pkgName + " package installation directory, no value returned from command.");
                LOG.log(Level.SEVERE, "Command: " + cmd);
            } else {
                LOG.info("Package " + pkgName + " is installation in: " + s);
                result = s;
            }
        }
        catch (Exception e) {
            LOG.severe("Unable to read input stream from command: " + cmd);
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.severe("Cannot close BufferedReader");
            LOG.severe(ioe.toString());
            LOG.severe(CommonUtil.getStackTrace(ioe));
        }
        return result;
    }

    protected boolean initialzeCSMAuthAdapter() {
        boolean result = true;
        CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
        if (!csmAuthAdapter.isAuthenticated()) {
            if (!csmAuthAdapter.authenticateUser()) {
                result = false;
            } else {
                csmAuthAdapter.closeFrame();
            }
        }
        CCRAdapter.setCSMAuthAdapter(csmAuthAdapter);
        return result;
    }

    static {
        secureHTTP = false;
    }
}

