/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.adapter;

import com.sun.cns.basicreg.adapter.Adapter;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.util.JarClassLoader;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.jdom.Document;

public class CSMAuthAdapter
extends Adapter {
    static CSMAuthAdapter instance = null;
    private static final Logger LOG = Logger.getLogger(CSMAuthAdapter.class.getName());
    private static String CONFIG_PKG_NAME = "SUNWcsmauth";
    private static String CONFIG_LOCATION = null;
    private static String CONFIG_LOCATION_DEFAULT = "/";
    private static String CSMAUTH_CLASS_ID = "com.sun.cns.authentication.CSMAuthenticator.class";
    private static String CSMAUTH_CLASS_NAME = "com.sun.cns.authentication.CSMAuthenticator";
    private static final String p2 = I18N.getString("authDlg.p2");
    private static final String p3 = I18N.getString("authDlg.p3");
    private static final String p4 = I18N.getString("authDlg.p4");
    private static final String p5 = I18N.getString("authDlg.p5");
    private static final String p6 = I18N.getString("authDlg.p6");
    private static final String p7 = I18N.getString("authDlg.p7");
    private static final String p8 = I18N.getString("authDlg.p8");
    private static final String p9 = I18N.getString("authDlg.p9");
    private static Vector vec = new Vector();
    private static CSMAuthAdapter csmauthLoader = new CSMAuthAdapter();
    private static Hashtable classLoaders = new Hashtable();
    private JFrame frame;
    private static boolean authenticated = false;

    public CSMAuthAdapter(Document inDoc) {
        theDocument = inDoc;
        if (theDocument == null) {
            LOG.warning("Constructor doc object is null!!!");
            theDocument = new Document();
        }
        CONFIG_LOCATION = CONFIG_LOCATION_DEFAULT;
    }

    private CSMAuthAdapter() {
    }

    public static CSMAuthAdapter getInstance() {
        if (instance == null) {
            instance = new CSMAuthAdapter();
        }
        return instance;
    }

    public static boolean isAuthenticated() {
        return authenticated;
    }

    public static void setAuthenticated(boolean value) {
        authenticated = value;
    }

    public boolean authenticateUser() {
        this.frame = new JFrame();
        this.createClassLoader();
        ClassLoader loader = this.getClassLoader(CSMAUTH_CLASS_ID);
        try {
            Class<?> authenticationDialogClass = loader.loadClass("com.sun.cns.authentication.AuthenticationDialog");
            Class[] argTypes = new Class[]{this.frame.getClass(), p2.getClass(), p3.getClass(), p4.getClass(), p5.getClass(), p6.getClass(), p7.getClass(), p8.getClass(), p9.getClass()};
            Constructor<?> constructor = authenticationDialogClass.getConstructor(argTypes);
            Object[] initArgs = new Object[]{this.frame, p2, p3, p4, p5, p6, p7, p8, p9};
            Object object = constructor.newInstance(initArgs);
            Method isAuth = authenticationDialogClass.getMethod("isAuthenticated", null);
            boolean isAuthResult = (Boolean)isAuth.invoke(object, null);
            if (!isAuthResult) {
                Method auth = authenticationDialogClass.getMethod("authenticate", null);
                authenticated = (Boolean)auth.invoke(object, null);
            }
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        if (authenticated) {
            LOG.info("CSMAUTH authenticated successfully!");
        } else {
            LOG.info("CSMAUTH authenticated unsuccessfully!");
        }
        LOG.info("CSMAUTH authentcatied = " + authenticated);
        return authenticated;
    }

    public String runCMD(String cmd, Vector args) {
        String result = null;
        ClassLoader loader = this.getClassLoader(CSMAUTH_CLASS_ID);
        if (loader == null) {
            this.createClassLoader();
            loader = this.getClassLoader(CSMAUTH_CLASS_ID);
        }
        try {
            Class<?> csmauthClass = loader.loadClass(CSMAUTH_CLASS_NAME);
            Class[] argTypes = new Class[]{cmd.getClass(), args.getClass()};
            Method getInstance = csmauthClass.getMethod("getInstance", null);
            Object csmauthObject = getInstance.invoke(null, null);
            Method runCMD = csmauthClass.getMethod("runCMD", argTypes);
            result = (String)runCMD.invoke(csmauthObject, cmd, args);
            LOG.info("result from runCMD = " + result);
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    public void closeFrame() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    private void createClassLoader() {
        ClassLoader[] cls = new ClassLoader[]{csmauthLoader.getClass().getClassLoader()};
        String jarFile = CONFIG_LOCATION_DEFAULT + "usr/lib/patch/csmauth.jar";
        try {
            JarFile theJarFile = new JarFile(jarFile);
            vec.add(theJarFile);
            JarClassLoader jcl = new JarClassLoader(vec.subList(0, vec.size()), cls);
            classLoaders.put(CSMAUTH_CLASS_ID, jcl);
        }
        catch (Exception e) {
            LOG.info(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
    }

    private ClassLoader getClassLoader(String classID) {
        return (ClassLoader)classLoaders.get(classID);
    }

    public Object getCSMAuthenticator() {
        CSMAuthAdapter object = null;
        if (authenticated) {
            LOG.info(" CSMAuthenticator is retrieved successfully: " + instance.toString());
            object = instance;
        } else if (this.authenticateUser()) {
            LOG.info(" CSMAuthenticator is retrieved successfully: " + instance.toString());
            object = instance;
        } else {
            LOG.info(" CSMAuthenticator is not retrieved successfully: due to root access failure");
        }
        this.closeFrame();
        return object;
    }

    public boolean isUserAuthenticatedAlready() {
        boolean result = false;
        ClassLoader loader = this.getClassLoader(CSMAUTH_CLASS_ID);
        if (loader == null) {
            this.createClassLoader();
            loader = this.getClassLoader(CSMAUTH_CLASS_ID);
        }
        try {
            Class<?> csmauthClass = loader.loadClass(CSMAUTH_CLASS_NAME);
            Method getInstance = csmauthClass.getMethod("getInstance", null);
            Object csmauthObject = getInstance.invoke(null, null);
            Method isAuthenticated = csmauthClass.getMethod("isAuthenticated", null);
            result = (Boolean)isAuthenticated.invoke(csmauthObject, null);
            LOG.info("result from isUserAuthenticatedAlready() = " + result);
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    public boolean runPrivCMD(String command, Vector arguments) {
        String cmd = "/bin/sh";
        String result = "";
        boolean status = false;
        Vector<String> args = new Vector<String>();
        args.add("-c");
        args.add(command);
        Enumeration eNum = arguments.elements();
        while (eNum.hasMoreElements()) {
            args.add(eNum.nextElement().toString());
        }
        if (!CSMAuthAdapter.isAuthenticated()) {
            if (!this.authenticateUser()) {
                this.closeFrame();
            } else {
                CSMAuthAdapter.setAuthenticated(true);
            }
        }
        try {
            LOG.info("runPrivCommand: " + cmd + args);
            result = this.runCMD(cmd, args);
            status = true;
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
            status = false;
        }
        return status;
    }

    public String readPrivFile(String filePath) {
        String cmd = "/usr/bin/cat";
        String result = "";
        Vector<String> args = new Vector<String>();
        args.add("-n");
        args.add(filePath);
        if (!CSMAuthAdapter.isAuthenticated()) {
            if (!this.authenticateUser()) {
                this.closeFrame();
            } else {
                CSMAuthAdapter.setAuthenticated(true);
            }
        }
        try {
            LOG.info("readPrivFile: " + args);
            result = this.runCMD(cmd, args);
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }
}

