/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.offering.prom;

import com.sun.scn.offering.prom.AssetRegistrationException;
import com.sun.scn.offering.service.ams.AssetManagementException;
import com.sun.scn.offering.service.ams.AssetManagementService_Impl;
import com.sun.scn.offering.service.ams.AssetMgmtServiceIF;
import com.sun.scn.offering.service.ams.AuthenticationException;
import com.sun.scn.offering.service.ams.EntitlementCodeAlradyInUseException;
import com.sun.scn.offering.service.ams.EntitlementException;
import com.sun.scn.offering.service.ams.InternalResourceException;
import com.sun.scn.offering.service.ams.InvalidAssetException;
import com.sun.scn.offering.service.ams.InvalidAssetNameException;
import com.sun.scn.offering.service.ams.InvalidEntitlementCodeException;
import com.sun.scn.offering.service.ams.bind.Asset;
import com.sun.scn.offering.service.ams.bind.GetAssetDetails;
import com.sun.scn.offering.service.ams.bind.ObjectFactory;
import com.sun.scn.offering.service.ams.bind.RegisterAsset;
import com.sun.scn.offering.service.ams.bind.RegisterResponse;
import com.sun.scn.service.BaseServiceClient;
import com.sun.scn.service.util.BindInitException;
import com.sun.scn.service.util.XmlBindUtils;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.Stub;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AssetManagementServiceProvider
extends BaseServiceClient {
    private static final String BIND_PKG = "com.sun.scn.offering.service.ams.bind";
    private static final String ENDPOINT_KEY = "ams.webservice.endpoint";
    private String endPoint;
    private static String assetId;
    private static XmlBindUtils xmlUtil;
    private static AssetMgmtServiceIF ams;
    private static Document systemInformationDoc;
    private static ObjectFactory of;
    private static final Logger LOG;

    public AssetManagementServiceProvider(String endpoint) throws AssetRegistrationException {
        super(LOG);
        this.endPoint = endpoint;
        LOG.log(Level.INFO, "AMS endpoint is::" + this.endPoint);
        super.setNetworkProxyProperties(super.getProxySettings());
        try {
            try {
                xmlUtil = new XmlBindUtils(BIND_PKG);
            }
            catch (BindInitException be) {
                throw new AssetRegistrationException("Caught a bind init exception:" + (Object)((Object)be));
            }
            ams = this.getAssetSvcInterface();
            of = new ObjectFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssetRegistrationException("TODO failed to initialize AMS webservic stub");
        }
    }

    private AssetMgmtServiceIF getAssetSvcInterface() {
        AssetManagementService_Impl impl = new AssetManagementService_Impl();
        Stub stub = (Stub)impl.getAssetMgmtServiceIFPort();
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.getEndPoint());
        AssetMgmtServiceIF assetMgmt = (AssetMgmtServiceIF)stub;
        return assetMgmt;
    }

    private String getEndPoint() {
        LOG.log(Level.INFO, "The end point of AMS webservice is: " + this.endPoint);
        return this.endPoint;
    }

    public RegisterResponse registerAsset(String mscId, String authToken, String regToken, Document sysDoc) throws AssetRegistrationException {
        String requestXSD = null;
        String responseXSD = null;
        systemInformationDoc = sysDoc;
        RegisterResponse response = null;
        try {
            RegisterAsset request = of.createRegisterAsset();
            request.setAssetXML(this.getAssetXML());
            request.setMscID(mscId);
            if (authToken != null) {
                request.setAuthToken(authToken);
            } else if (regToken != null) {
                request.setRegToken(regToken);
            } else {
                LOG.log(Level.WARNING, "Neither authToken nor regToken provided for register");
                return null;
            }
            requestXSD = xmlUtil.marshalToString((Object)request);
            LOG.log(Level.INFO, "calling ams.registerAsset .......");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssetRegistrationException("we failed to set up the request. Error at the client side." + e);
        }
        try {
            LOG.log(Level.INFO, "DEBUG: next call is ams.registerAsset");
            responseXSD = ams.registerAsset(requestXSD);
            LOG.log(Level.INFO, "DEBUG: get the response from AMS ");
        }
        catch (AuthenticationException ae) {
            this.dumpThrowable(ae);
            throw new AssetRegistrationException("AuthenticationException");
        }
        catch (InternalResourceException ire) {
            this.dumpThrowable(ire);
            throw new AssetRegistrationException("InternalResourceException");
        }
        catch (InvalidAssetException iae) {
            this.dumpThrowable(iae);
            throw new AssetRegistrationException("InvalidAssetException");
        }
        catch (InvalidAssetNameException ine) {
            this.dumpThrowable(ine);
            throw new AssetRegistrationException("InvalidAssetNameException");
        }
        catch (EntitlementException ee) {
            this.dumpThrowable(ee);
            throw new AssetRegistrationException("EntitlementException");
        }
        catch (EntitlementCodeAlradyInUseException ecae) {
            this.dumpThrowable(ecae);
            throw new AssetRegistrationException("EntitlementCodeAlreadyInUseException");
        }
        catch (InvalidEntitlementCodeException iece) {
            this.dumpThrowable(iece);
            throw new AssetRegistrationException("InvalidEntitlementCodeException");
        }
        catch (AssetManagementException ame) {
            this.dumpThrowable(ame);
            throw new AssetRegistrationException("AssetManagementException");
        }
        catch (RemoteException re) {
            this.dumpThrowable(re);
            throw new AssetRegistrationException("RemoteException");
        }
        try {
            response = (RegisterResponse)xmlUtil.unmarshalFromString(responseXSD);
            if (response == null) {
                LOG.log(Level.SEVERE, "failed to register the asset. Got invalid asset Id");
                throw new AssetRegistrationException("FailedToRegisterTheAssetException");
            }
            assetId = response.getAssetId();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dumpThrowable(e);
            LOG.log(Level.SEVERE, "Failed after we got a server response. error ");
            throw new AssetRegistrationException("ServerResponseError");
        }
        return response;
    }

    private String getAssetXML() throws Exception {
        LOG.log(Level.INFO, "Ready to getAssetXML from SAM: ");
        Format f = Format.getPrettyFormat();
        f.setLineSeparator("\n");
        XMLOutputter xout = new XMLOutputter(f);
        return xout.outputString(systemInformationDoc);
    }

    public String getAssetCommonName(String assetId, String authToken) throws AssetRegistrationException {
        String commonName = null;
        try {
            GetAssetDetails gad = of.createGetAssetDetails();
            gad.setAssetId(assetId);
            gad.setAuthToken(authToken);
            String response = ams.getAssetDetails(xmlUtil.marshalToString((Object)gad));
            Asset asset = (Asset)xmlUtil.unmarshalFromString(response);
            if (asset == null) {
                LOG.log(Level.SEVERE, "The asset found was null.");
            }
            if ((commonName = asset.getCommonName()) == null || commonName.trim().equals("")) {
                LOG.log(Level.SEVERE, "asset common name is invalid");
            }
            LOG.log(Level.INFO, "DEBUG getCommonName()-->" + commonName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dumpThrowable(e);
            LOG.log(Level.SEVERE, "Failed after we got a server response. error ");
            throw new AssetRegistrationException("ServerResponseError");
        }
        return commonName;
    }

    static {
        xmlUtil = null;
        LOG = Logger.getLogger(AssetManagementServiceProvider.class.getName());
    }
}

