/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.ResponseWidget;
import com.sun.cns.basicreg.wizard.TextWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.cli.CmdLineWidget;
import com.sun.cns.basicreg.wizard.util.I18N;

public class CmdLineFieldWidget
extends CmdLineWidget
implements Widget,
ResponseWidget,
TextWidget {
    private String displayText;
    private String response;
    private int length;

    public CmdLineFieldWidget(String text) {
        this.text = text;
        this.response = "";
    }

    public CmdLineFieldWidget(Form form, String text, String reload, String required, String editable, String scrollable, String length, String defaultValue, String validPattern, String patternError, String validMatch, String matchError, String note, String fontSize, String fontStyle, String id, String newRow, String fontColor, String s508Name, String s508Desc, String mnemonic) {
        this.form = form;
        this.text = text;
        this.reload = reload != null && reload.equalsIgnoreCase("yes");
        this.response = "";
        if (required != null && required.equalsIgnoreCase("yes")) {
            this.required = true;
            this.displayText = I18N.getString("is.required.lbl") + text;
        } else {
            this.required = false;
            this.displayText = " " + text;
        }
        this.scrollable = scrollable != null && scrollable.equalsIgnoreCase("yes");
        this.editable = editable == null || editable.equalsIgnoreCase("yes");
        this.length = length != null ? Integer.parseInt(length) : 30;
        this.defaultValue = defaultValue;
        this.validPattern = validPattern;
        this.patternError = patternError;
        this.validMatch = validMatch;
        this.matchError = matchError;
        if (defaultValue != null && defaultValue.length() > 0) {
            this.setResponse(defaultValue);
        }
        this.note = note;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize != null ? Integer.parseInt(fontSize) : 0;
        this.id = id;
        this.newRow = newRow == null || !newRow.equalsIgnoreCase("no");
        this.fontColor = fontColor;
        this.s508Name = s508Name;
        this.s508Desc = s508Desc;
        this.mnemonic = mnemonic;
    }

    public WidgetType getType() {
        return WidgetType.FIELD;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String value) {
        this.displayText = value;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public void draw() {
        StringBuffer output = new StringBuffer();
        output.append(this.getDisplayText());
        if (this.note != null) {
            output.append("(" + this.note + ")");
        }
        output.append(" ");
        output.append(this.getResponse());
        output.append("\n");
        System.out.print(output.toString());
    }

    public int getSize() {
        return this.length;
    }
}

