/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.util;

import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Validation {
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$wizard$util$Validation == null ? (class$com$sun$cns$basicreg$wizard$util$Validation = Validation.class$("com.sun.cns.basicreg.wizard.util.Validation")) : class$com$sun$cns$basicreg$wizard$util$Validation).getName());
    static /* synthetic */ Class class$com$sun$cns$basicreg$wizard$util$Validation;

    private static String validateValueEmail(String value, Widget widget) {
        return "SPECIAL VALIDATION NOT YET IMPLEMENTED";
    }

    private static String validateValuePhone(String value, Widget widget) {
        return "SPECIAL VALIDATION NOT YET IMPLEMENTED";
    }

    private static String validateValueTOU(String value, Widget widget) {
        return value.equalsIgnoreCase("true") ? null : I18N.getString("accept.tou.err");
    }

    private static String validateValueInfo(String value, Widget widget) {
        return value.equalsIgnoreCase("true") ? null : I18N.getString("accept.info.err");
    }

    private static String validatePatchURL(String value, Widget widget) {
        try {
            URL url = new URL(value);
            return null;
        }
        catch (MalformedURLException ex) {
            LOG.severe("Unable to create URL from String: " + value);
            return I18N.getString("patch.url.err");
        }
    }

    private static String validateValuePattern(String value, String patternString, Widget widget) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(patternString);
        }
        catch (Exception ex) {
            LOG.severe("ERROR - Unable to compile pattern: " + widget.getValidPattern());
            pattern = null;
        }
        if (pattern != null && !pattern.matcher(value).matches()) {
            String patternError = widget.getPatternError();
            if (patternError == null) {
                patternError = "";
            }
            Object[] errorArguments = new Object[]{patternError};
            return I18N.getFormattedString("bad.format.err", errorArguments);
        }
        if (widget.getId().equalsIgnoreCase("email") && value.length() > 80) {
            return I18N.getString("bad.email.err");
        }
        return null;
    }

    private static String validateValueIsRequired(String value, boolean isRequired) {
        if (isRequired && (value == null || value.trim().length() == 0)) {
            return I18N.getString("is.required.err");
        }
        return null;
    }

    public static String validateUserPass(String username, String password) {
        if (username == null && password != null || username != null && password == null) {
            return null;
        }
        if (username == null && password == null || username.equals(password)) {
            return I18N.getString("username.password.match.err");
        }
        return null;
    }

    public static String validateValueMatch(String value, String matchValue, Widget widget) {
        if (matchValue == null) {
            return null;
        }
        if (!value.equals(matchValue)) {
            String matchError = widget.getMatchError();
            if (matchError == null) {
                matchError = "";
            }
            Object[] errorArguments = new Object[]{matchError};
            return I18N.getFormattedString("bad.match.err", errorArguments);
        }
        return null;
    }

    public static String getMatchWidgetId(String matchString) {
        if (matchString == null) {
            return null;
        }
        int widFlagIndex = matchString.indexOf("$WID:");
        if (widFlagIndex == -1) {
            return null;
        }
        if (widFlagIndex + "$WID:".length() >= matchString.length()) {
            LOG.severe("ERROR - no widget id specified");
            return null;
        }
        return matchString.substring(widFlagIndex + "$WID:".length());
    }

    public static String validateValue(String value, Widget widget) {
        String error = Validation.validateValueIsRequired(value, widget.isRequired());
        if (error != null) {
            return error;
        }
        String patternString = widget.getValidPattern();
        if (patternString == null) {
            return null;
        }
        if (!widget.isRequired() && value.trim().length() == 0) {
            return null;
        }
        String validationPatternError = null;
        validationPatternError = patternString.equals("Zemail") ? Validation.validateValueEmail(value, widget) : (patternString.equals("Zphone") ? Validation.validateValuePhone(value, widget) : (patternString.equals("Ztou") ? Validation.validateValueTOU(value, widget) : (patternString.equals("Zinfo") ? Validation.validateValueInfo(value, widget) : (patternString.equals("ZpatchURL") ? Validation.validatePatchURL(value, widget) : Validation.validateValuePattern(value, patternString, widget)))));
        return validationPatternError;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

