/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.offering.swupom;

import com.sun.scn.jmx.SCNType;
import com.sun.scn.offering.prom.ProductRegOfferingFactory;
import com.sun.scn.offering.swupom.SWUPOfferingFactoryMBean;
import com.sun.scn.offering.swupom.SWUPOfferingInstance;
import com.sun.scn.offering.swupom.SWUPOfferingInstanceMBean;
import com.sun.scn.util.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SWUPOfferingFactory
extends ProductRegOfferingFactory
implements SWUPOfferingFactoryMBean {
    public static final SCNType INSTANCETYPE = SCNType.OFFERING_INSTANCE;
    public static final String host = Utils.getLocalHostNames()[0];
    public static Map cache;
    private static Properties privateProps;

    public SWUPOfferingFactory(String name, Properties props, String module, MBeanServer mbs, Logger logger) {
        super(name, props, module, mbs, logger);
        cache = new HashMap();
    }

    protected void _start() {
        this.addInstance("SWUPOfferingInstance", SWUPOfferingInstanceMBean.class);
        this.getLogger().log(Level.INFO, "Get instance names: ");
        String[] inames = this.getInstanceNames();
        for (int i = 0; i < inames.length; ++i) {
            this.getLogger().log(Level.INFO, "names [" + i + "] = " + inames[i]);
        }
        this.getLogger().log(Level.INFO, "Get instanceObjectName: ");
        ObjectName[] names = this.getInstanceObjectNames();
        for (int i = 0; i < names.length; ++i) {
            this.getLogger().log(Level.INFO, "object names [" + i + "] = " + names[i]);
        }
        this.getLogger().log(Level.INFO, "getOfferingInstanceName:");
        ObjectName on = this.getOfferingInstanceName("SWUPOfferingInstance");
        this.getLogger().log(Level.INFO, "ObjectName for ProductRegOfferingInstance.NAME is " + on);
    }

    protected void _stop() {
        try {
            Collection mbeans = cache.values();
            for (SWUPOfferingInstanceMBean mbean : mbeans) {
                this.getMBeanServer().unregisterMBean(mbean.getObjectName());
            }
            cache.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected SWUPOfferingInstanceMBean getInstance(String name) {
        SWUPOfferingInstance offMBean = (SWUPOfferingInstance)cache.get(name);
        if (null == offMBean) {
            try {
                offMBean = new SWUPOfferingInstance(this, null, name, SWUPOfferingFactory.buildPROIProps(), this.getMBeanServer(), this.getModuleName());
                cache.put(name, offMBean);
                offMBean.init_collect();
            }
            catch (Exception x) {
                this.getLogger().log(Level.WARNING, "Failed to build MBean" + name);
                this.getLogger().log(Level.WARNING, "caught exception", x);
            }
        }
        return offMBean;
    }

    protected SWUPOfferingInstanceMBean createInstance(String name) {
        return this.getInstance(name);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    private static Properties buildPROIProps() {
        Properties oiProp = new Properties();
        oiProp.setProperty("name", "SWUPOfferingInstance");
        oiProp.setProperty("host", host);
        oiProp.setProperty("assetProfile", "compute-host");
        oiProp.setProperty("assetSubProfile", "base-compute-host");
        oiProp.setProperty("Vendor", "Sun Microsystems Inc");
        oiProp.setProperty("scnType", "OfferingInstance");
        oiProp.setProperty("OfferingFactory", "SWUPOfferingFactory");
        oiProp.setProperty("assetModel", "NULL");
        return oiProp;
    }

    public ObjectName getOfferingInstanceName(String name) {
        ObjectName retName = null;
        if (!cache.containsKey(name)) {
            retName = null;
        } else {
            SWUPOfferingInstanceMBean member = (SWUPOfferingInstanceMBean)cache.get(name);
            retName = member.getObjectName();
        }
        return retName;
    }
}

