/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.offering.swupom;

import com.sun.scn.offering.prom.AssetManagementServiceProvider;
import com.sun.scn.offering.prom.AssetRegistrationException;
import com.sun.scn.offering.prom.ProductRegOfferingFactoryMBean;
import com.sun.scn.offering.prom.ProductRegOfferingInstance;
import com.sun.scn.offering.prom.SystemInfoHelper;
import com.sun.scn.offering.service.ams.bind.RegisterResponse;
import com.sun.scn.offering.swupom.SWUPOfferingFactoryMBean;
import com.sun.scn.offering.swupom.SWUPOfferingInstanceMBean;
import com.sun.scn.util.CCRAdapter;
import com.sun.scn.util.CCRAdapterException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class SWUPOfferingInstance
extends ProductRegOfferingInstance
implements SWUPOfferingInstanceMBean {
    private String AgentUuidAttributeVal = "4c111d85-7968-11d9-b344-080020a9ed93";
    private String _servicePlanId;
    private String _localPatchSourceURL = null;
    protected static MBeanServer myMbs = null;
    private static String subscriptionKey = "";
    private static String systemDisplayName = "";
    public static String SLA_VERSION = "PPSLA_v1.1";
    private static String CCR_REG_REQUIRED = "cns.swup.regRequired";
    private static final String SWUP_PORTAL_ENABLE = "true";
    private static final String SWUP_PORTAL_DISABLE = "false";
    private static final String SWUP_LPS_URL = "patchpro.patch.source";
    private static final String SWUP_PORTAL_ENABLE_TAG = "swup.portal.enabled";
    private boolean swupPortalEnable;
    private boolean bSubKey = false;
    private boolean bSystemName = false;
    private static final Logger LOG = Logger.getLogger(SWUPOfferingInstance.class.getName());

    public SWUPOfferingInstance(SWUPOfferingFactoryMBean factory, Object entity, String theName, Properties props, MBeanServer theMbs, String module) {
        super((ProductRegOfferingFactoryMBean)factory, entity, theName, props, theMbs, module);
        myMbs = theMbs;
    }

    public void init_collect() {
        this.getSystemInformation("full");
        if (this.systemInformation != null) {
            systemInfoHelper = new SystemInfoHelper(this.systemInformation);
            systemInfoHelper.setSysInfoValueByName("asset.id", assetId);
            systemInfoHelper.setSysInfoAttributeValueByName("computer.system", "agentUuid", this.AgentUuidAttributeVal);
            this.hostname = systemInfoHelper.getSysInfoValueByName("host.name");
        }
    }

    public String getSubscriptionKey() {
        return subscriptionKey;
    }

    public void setSubscriptionKey(String subkey) {
        subscriptionKey = subkey;
    }

    public String getSystemDisplayName() {
        return systemDisplayName;
    }

    public void setSystemDisplayName(String systemName) {
        systemDisplayName = systemName;
    }

    public boolean getSWUPPortalEnableKey() {
        return this.swupPortalEnable;
    }

    public void setSWUPPortalEnableKey(boolean isEnabled) {
        this.swupPortalEnable = isEnabled;
    }

    public String getServicePlanId() {
        return this._servicePlanId;
    }

    public void setServicePlanId(String planId) {
        this._servicePlanId = planId;
    }

    public String getLocalPatchSourceURL() {
        return this._localPatchSourceURL;
    }

    public void setLocalPatchSourceURL(String lpsURL) {
        this._localPatchSourceURL = lpsURL;
        if (this._localPatchSourceURL == null || this._localPatchSourceURL == "" || this._localPatchSourceURL.length() == 0) {
            LOG.log(Level.INFO, "LPS URL is not set or null. Existing value will not be modified.");
        } else {
            try {
                CCRAdapter ccr = new CCRAdapter(LOG);
                ccr.setValue(CCR_REG_REQUIRED, SWUP_PORTAL_DISABLE);
            }
            catch (CCRAdapterException caex) {
                LOG.log(Level.SEVERE, "cannot set REG_REQUIRED value in CCR");
                this.log(Level.SEVERE, caex.getMessage());
            }
            LOG.log(Level.INFO, "Setting LPS URL to " + this._localPatchSourceURL);
            this.setPatchProParam(SWUP_LPS_URL, this._localPatchSourceURL);
        }
    }

    public String getHostname() {
        if (this.systemInformation == null) {
            super.getSystemInformation("full");
        }
        return this.hostname;
    }

    protected void setSLAVersion(String slaVersion) {
        LOG.log(Level.INFO, "in setSLAVersion()");
        systemInfoHelperReg.setSysInfoValueByName("sla.version", slaVersion);
    }

    public boolean register() throws AssetRegistrationException {
        boolean bReturn = false;
        ClassLoader save = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.myClassloader);
        String authToken = null;
        String regToken = null;
        Object publicKey = null;
        this.systemInformationReg = (Document)this.systemInformation.clone();
        systemInfoHelperReg = new SystemInfoHelper(this.systemInformationReg);
        this.insertOptionToXML(this.systemInformationReg);
        String package_element = systemInfoHelperReg.removeSysInfoValueByName("package.inventory");
        String patch_element = systemInfoHelperReg.removeSysInfoValueByName("patch.inventory");
        this.setSLAVersion(SLA_VERSION);
        LOG.log(Level.INFO, "set SLA Version to the xml");
        try {
            String ePoint = super.getAMSWebserviceEndpoint();
            LOG.log(Level.INFO, "AMS endpoint is-->" + ePoint);
            AssetManagementServiceProvider aTest = new AssetManagementServiceProvider(ePoint);
            authToken = super.getAuthToken();
            regToken = super.getRegToken();
            RegisterResponse rr = aTest.registerAsset(super.getMscId(), authToken, regToken, this.systemInformationReg);
            if (authToken != null) {
                super.setRegToken(rr.getRegToken());
            }
            LOG.log(Level.INFO, "Done! This asset has been registered with AMS.");
            this.setSwupEnableFlagAssetIdInCCR(true);
            LOG.log(Level.INFO, "The swupPortalEnabled status has been written to CCR.");
            this.setPatchProProxy();
            LOG.log(Level.INFO, "set proxy for patchpro");
            Format f = Format.getPrettyFormat();
            f.setLineSeparator("\n");
            XMLOutputter xout = new XMLOutputter(f);
            this.registerOSServiceTag();
            bReturn = true;
        }
        catch (Exception e) {
            this.clearPassWord();
            e.printStackTrace();
            throw new AssetRegistrationException("Failed to register asset with AMS. Error message is :" + e);
        }
        if (bReturn) {
            LOG.log(Level.INFO, "Done! This asset has been registered with AMS thru the SWUP Offering module.");
        } else {
            LOG.log(Level.WARNING, "Asset registration failed.");
        }
        if (bReturn) {
            this.setProxyIntoCCR();
        }
        return bReturn;
    }

    private void insertOptionToXML(Document sysInfo) {
        this.bSubKey = false;
        this.bSystemName = false;
        if (sysInfo != null) {
            String subkey = this.getSubscriptionKey();
            if (subkey != null && subkey.length() > 0) {
                systemInfoHelperReg.setSysInfoValueByName("subscription.key", subkey);
                this.bSubKey = true;
            } else {
                systemInfoHelperReg.setSysInfoValueByName("subscription.key", "");
            }
            String systemName = this.getSystemDisplayName();
            if (systemName != null && systemName.length() > 0) {
                systemInfoHelperReg.setSysInfoValueByName("common.name", systemName);
                this.bSystemName = true;
            } else {
                systemInfoHelperReg.setSysInfoValueByName("common.name", this.hostname);
            }
            boolean isEnabled = this.getSWUPPortalEnableKey();
            if (isEnabled || this.bSubKey && this.bSystemName) {
                systemInfoHelperReg.setSysInfoValueByName(SWUP_PORTAL_ENABLE_TAG, SWUP_PORTAL_ENABLE);
                LOG.log(Level.INFO, "in enable branch - get SWUP_PORTAL_ENABLED_KEY--> " + systemInfoHelperReg.getSysInfoValueByName(SWUP_PORTAL_ENABLE_TAG));
            } else {
                systemInfoHelperReg.setSysInfoValueByName(SWUP_PORTAL_ENABLE_TAG, SWUP_PORTAL_DISABLE);
                LOG.log(Level.INFO, "in disable branch - get SWUP_PORTAL_ENABLED_KEY--> " + systemInfoHelperReg.getSysInfoValueByName(SWUP_PORTAL_ENABLE_TAG));
            }
            String publicKey = this.getPublicKey();
            if (!this.bSubKey) {
                systemInfoHelperReg.removeSysInfoValueByName("common.name");
                systemInfoHelperReg.removeSysInfoValueByName("subscription.key");
            }
        }
    }

    public String getSystemDisplayNameFromAMS(String assetId) throws AssetRegistrationException {
        ClassLoader save = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.myClassloader);
        String authToken = null;
        String displayName = null;
        try {
            String ePoint = super.getAMSWebserviceEndpoint();
            LOG.log(Level.INFO, "AMS endpoint is-->" + ePoint);
            AssetManagementServiceProvider aTest = new AssetManagementServiceProvider(ePoint);
            authToken = super.getAuthToken();
            displayName = aTest.getAssetCommonName(assetId, authToken);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssetRegistrationException("Failed to get system display name from  AMS. Error message is :" + e);
        }
        return displayName;
    }
}

