/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cc.transport.client;

import com.sun.cc.transport.client.Command;
import com.sun.cc.transport.client.CommandResponse;
import com.sun.cc.transport.client.Message;
import com.sun.cc.transport.client.StringCommand;
import com.sun.cc.transport.client.StringMessage;
import com.sun.cc.transport.client.TransportAdapterException;
import com.sun.cc.transport.client.TransportListener;
import com.sun.cc.transport.client.XMLCommand;
import com.sun.cc.transport.client.XMLMessage;
import com.sun.srs.im.AlarmData;
import com.sun.srs.im.CallbackException;
import com.sun.srs.im.CallbackParams;
import com.sun.srs.im.EventData;
import com.sun.srs.im.GenericData;
import com.sun.srs.im.MessageData;
import com.sun.srs.im.ProxyException;
import com.sun.srs.im.ProxyIOException;
import com.sun.srs.im.RegistrationException;
import com.sun.srs.im.SRSMockProxy;
import com.sun.srs.im.SRSProxy;
import com.sun.srs.im.SRSProxyListener;
import com.sun.srs.im.SRSTimestamp;
import java.io.File;

public class TransportAdapter {
    private static final String DEFAULT_VERSION = "000.000.000";
    private static final String STRING_MIMETYPE = "text/plain";
    private static final String XML_MIMETYPE = "text/xml";
    private static final String RAW_MIMETYPE = "application/octet-stream";
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 30;
    private static final int WATCHDOG_DISABLE = 0;
    private MyProxyListener proxyListener = null;
    private SRSProxy proxy = null;
    private TransportListener transportListener = null;
    private String name = null;

    public TransportAdapter(String name, TransportListener listener) throws TransportAdapterException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name registered with the TransportAdapter may not be null or zero-length.");
        }
        this.name = name;
        this.transportListener = listener;
        this.proxy = new SRSProxy();
        this.register();
    }

    public TransportAdapter(String name, TransportListener listener, File input, File output) throws TransportAdapterException, IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name registered with the TransportAdapter may not be null or zero-length.");
        }
        this.name = name;
        this.transportListener = listener;
        this.proxy = new SRSProxy(new SRSMockProxy(input, output));
        this.register();
    }

    public void send(Message msg) throws TransportAdapterException, IllegalArgumentException {
        GenericData gendata = null;
        if (msg == null) {
            throw new IllegalArgumentException("Null Message");
        }
        gendata = msg instanceof XMLMessage ? new GenericData(XML_MIMETYPE, msg.getBytes()) : (msg instanceof StringMessage ? new GenericData(STRING_MIMETYPE, msg.getBytes()) : new GenericData(RAW_MIMETYPE, msg.getBytes()));
        MessageData msgdata = new MessageData(gendata, this.name, null);
        this.sendToProxy(msgdata);
    }

    public void send(CommandResponse cmdresp) throws TransportAdapterException, IllegalArgumentException {
        if (cmdresp == null) {
            throw new IllegalArgumentException("Null CommandResponse");
        }
        if (cmdresp.getRefId() == null) {
            throw new IllegalArgumentException("Null ReferenceID in CommandResponse");
        }
        if (cmdresp.getMessage() == null) {
            throw new IllegalArgumentException("Null Message in CommandResponse");
        }
        CommandResponse.CommandDisposition disp = cmdresp.getCommandDisposition();
        if (CommandResponse.SUCCESS.equals(disp)) {
            this.sendCommandSuccess(cmdresp);
        } else if (CommandResponse.FAILURE.equals(disp)) {
            this.sendCommandFailure(cmdresp);
        }
    }

    public void close() {
        if (this.proxy != null) {
            this.proxy.close();
            this.proxy = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    private void register() throws TransportAdapterException {
        try {
            this.proxy.registerIM(this.name, DEFAULT_VERSION, new CallbackParams(new MyProxyListener(this.transportListener), CallbackParams.DELIVER, 30, 0));
        }
        catch (IllegalArgumentException iaex) {
            throw new TransportAdapterException(iaex.getMessage());
        }
        catch (RegistrationException rex) {
            throw new TransportAdapterException(rex.getMessage());
        }
        catch (ProxyException pex) {
            throw new TransportAdapterException(pex.getMessage());
        }
        catch (ProxyIOException pioex) {
            throw new TransportAdapterException(pioex.getMessage());
        }
        catch (Throwable t) {
            throw new TransportAdapterException(t.getMessage());
        }
    }

    private void sendCommandSuccess(CommandResponse cmdresp) throws TransportAdapterException {
        Message msg = cmdresp.getMessage();
        GenericData gendata = null;
        gendata = msg instanceof XMLMessage ? new GenericData(XML_MIMETYPE, msg.getBytes()) : (msg instanceof StringMessage ? new GenericData(STRING_MIMETYPE, msg.getBytes()) : new GenericData(RAW_MIMETYPE, msg.getBytes()));
        MessageData msgdata = new MessageData(gendata, this.name, cmdresp.getRefId());
        this.sendToProxy(msgdata);
    }

    private void sendCommandFailure(CommandResponse cmdresp) throws TransportAdapterException {
        SRSTimestamp ts = new SRSTimestamp();
        String dataStr = new String(cmdresp.getMessage().getBytes());
        MessageData msgdata = new MessageData(new AlarmData(ts, this.name, EventData.SEV_CRITICAL, dataStr, cmdresp.getRefId(), CommandResponse.FAILURE.toString(), null), this.name, cmdresp.getRefId());
        this.sendToProxy(msgdata);
    }

    private void sendToProxy(MessageData msgdata) throws TransportAdapterException {
        try {
            this.proxy.send("SRS_IM_TARGET", msgdata);
        }
        catch (IllegalArgumentException iaex) {
            throw new TransportAdapterException(iaex.getMessage());
        }
        catch (RegistrationException rex) {
            throw new TransportAdapterException(rex.getMessage());
        }
        catch (ProxyException pex) {
            throw new TransportAdapterException("CC transport error - " + pex.getMessage());
        }
        catch (ProxyIOException pioex) {
            throw new TransportAdapterException("Unable to connect to CC transport - " + pioex.getMessage());
        }
        catch (Throwable t) {
            throw new TransportAdapterException(t.getMessage());
        }
    }

    private static final class MyProxyListener
    implements SRSProxyListener {
        private TransportListener listener = null;

        protected MyProxyListener(TransportListener listener) {
            this.listener = listener;
        }

        public void getCapabilities(String refId, String mgmtId) {
        }

        public void getIdentifiers(String refId, String mgmtId) {
        }

        public void getStatus() {
        }

        public void receiveUpdate(String refId, String mgmtId, String mimeType, byte[] data, boolean isFile) throws CallbackException {
            try {
                if (this.listener != null) {
                    Message msg = null;
                    if (TransportAdapter.XML_MIMETYPE.equals(mimeType)) {
                        msg = new XMLMessage("");
                        msg.setBytes(data);
                    } else if (TransportAdapter.STRING_MIMETYPE.equals(mimeType)) {
                        msg = new StringMessage("");
                        msg.setBytes(data);
                    } else if (TransportAdapter.RAW_MIMETYPE.equals(mimeType)) {
                        msg = new Message(data);
                    }
                    this.listener.receiveMessage(msg);
                }
            }
            catch (TransportAdapterException tax) {
                throw new CallbackException(tax.getMessage());
            }
        }

        public void managementAction(String refId, String mgmtId, String mimeType, byte[] action) throws CallbackException {
            try {
                if (this.listener != null) {
                    Command cmd = null;
                    if (TransportAdapter.XML_MIMETYPE.equals(mimeType)) {
                        cmd = new XMLCommand(refId, "");
                        cmd.setBytes(action);
                    } else if (TransportAdapter.STRING_MIMETYPE.equals(mimeType)) {
                        cmd = new StringCommand(refId, "");
                        cmd.setBytes(action);
                    } else if (TransportAdapter.RAW_MIMETYPE.equals(mimeType)) {
                        cmd = new Command(refId, action);
                    }
                    this.listener.receiveCommand(cmd);
                }
            }
            catch (TransportAdapterException tax) {
                throw new CallbackException(tax.getMessage());
            }
        }
    }
}

