/*
 * Decompiled with CFR 0.152.
 */
package com.sun.srs.im;

import com.sun.srs.im.SRSEnum;
import com.sun.srs.im.SRSProxyListener;

public class CallbackParams {
    public static final int DISABLE = 0;
    public static final Disposition HOLD = new Disposition("hold", 1);
    public static final Disposition PURGE = new Disposition("purge", 2);
    public static final Disposition DELIVER = new Disposition("deliver", 3);
    private SRSProxyListener listener;
    private Disposition disp;
    private int hbInterval;
    private int wdInterval;

    public CallbackParams(SRSProxyListener listener, Disposition disp) {
        this(listener, disp, 0, 0);
    }

    public CallbackParams(SRSProxyListener listener, Disposition disp, int hbInterval) {
        this(listener, disp, hbInterval, 2 * hbInterval);
    }

    public CallbackParams(SRSProxyListener listener, Disposition disp, int hbInterval, int wdInterval) {
        if (listener == null) {
            throw new IllegalArgumentException("listener not set");
        }
        if (disp == null) {
            throw new IllegalArgumentException("disposition not set");
        }
        if (hbInterval < 0 || wdInterval < 0) {
            throw new IllegalArgumentException("intervals must be positive");
        }
        this.listener = listener;
        this.disp = disp;
        this.hbInterval = hbInterval;
        this.wdInterval = wdInterval;
    }

    public SRSProxyListener getListener() {
        return this.listener;
    }

    public Disposition getDisposition() {
        return this.disp;
    }

    public int getHBInterval() {
        return this.hbInterval;
    }

    public int getWDInterval() {
        return this.wdInterval;
    }

    protected static class Disposition
    extends SRSEnum {
        private static final int HOLDVAL = 1;
        private static final int PURGEVAL = 2;
        private static final int DELIVERVAL = 3;

        private Disposition(String name, int value) {
            super(name, value);
        }
    }
}

