/*
 * Decompiled with CFR 0.152.
 */
package com.sun.srs.im;

import com.sun.srs.im.AlarmData;
import com.sun.srs.im.EventData;
import com.sun.srs.im.GenericData;
import com.sun.srs.im.MessageContent;
import com.sun.srs.im.SRSQHints;

public class MessageData {
    private String subtype;
    private String refId;
    private MessageContent content;
    private SRSQHints qhints;

    public MessageData(MessageContent content, String subtype) {
        this(content, subtype, null);
    }

    public MessageData(MessageContent content, String subtype, String refId) {
        this(content, subtype, refId, new SRSQHints());
    }

    public MessageData(MessageContent content, String subtype, String refId, SRSQHints qhints) {
        if (!(content instanceof AlarmData || content instanceof EventData || content instanceof GenericData)) {
            throw new IllegalArgumentException("invalid content");
        }
        if (qhints == null) {
            throw new IllegalArgumentException("null qhints");
        }
        this.subtype = subtype;
        this.refId = refId;
        this.content = content;
        this.qhints = qhints;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getRefId() {
        return this.refId;
    }

    public MessageContent getContent() {
        return this.content;
    }

    public GenericData getGenericData() {
        if (this.content instanceof GenericData) {
            return (GenericData)this.content;
        }
        return null;
    }

    public EventData getEventData() {
        if (this.content instanceof EventData) {
            return (EventData)this.content;
        }
        return null;
    }

    public SRSQHints getQHints() {
        return this.qhints;
    }
}

