/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.wizard.ComboBoxWidget;
import com.sun.cns.basicreg.wizard.Controller;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.HTMLWidget;
import com.sun.cns.basicreg.wizard.JumpWidget;
import com.sun.cns.basicreg.wizard.LinkWidget;
import com.sun.cns.basicreg.wizard.RadioBoxWidget;
import com.sun.cns.basicreg.wizard.ResponseWidget;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.TextIconLabelWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.cli.CmdLineComboBoxWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineFieldWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLinePasswordWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineRadioBoxWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineSelectWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWizard;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.ResponseError;
import com.sun.cns.basicreg.wizard.util.Validation;
import com.sun.cns.basicreg.wizard.util.Web;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.jdom.Document;

public class CmdLineController
implements Controller {
    private static final String PROMPT = I18N.getString("cli.prompt.btn") + " ";
    private static final String PREVIOUS = I18N.getString("cli.previous.btn") + " ";
    private static final String FIRST = I18N.getString("cli.first.btn") + " ";
    private static final String LAST = I18N.getString("cli.last.btn") + " ";
    private static final String NEXT = I18N.getString("cli.next.btn") + " ";
    private static final String FINISH = I18N.getString("cli.finish.btn") + " ";
    private static final String CANCEL = I18N.getString("cli.cancel.btn") + " ";
    private static final String BACK = I18N.getString("cli.backtoform.btn") + " ";
    private static final String charP = I18N.getString("p.char");
    private static final String charF = I18N.getString("f.char");
    private static final String charL = I18N.getString("l.char");
    private static final String charN = I18N.getString("n.char");
    private static final String charC = I18N.getString("c.char");
    private static final String charB = I18N.getString("b.char");
    private static final String selectionMsg = I18N.getString("cli.selection.msg");
    private static final String passwordNotMatchMsg = I18N.getString("cli.passwordnotmatch.msg");
    private static final int lowerBound9 = 9;
    private static final int lowerBound99 = 99;
    private static final int lowerBound999 = 999;
    private static final int upperBound10 = 10;
    private static final int upperBound100 = 100;
    private static final int upperBound1000 = 1000;
    private static final int upperBound10000 = 10000;
    private static final int numberOfSpaces = 0;
    private Wizard wizard;
    private boolean running = false;
    private BufferedReader input;
    private Widget parentBoxWidget = null;
    private int parentBoxWidgetIndex;
    private boolean fromBoxWidget = false;
    private String errorMessage = "";
    private boolean accept = false;
    private boolean isNextEnabled = false;
    private boolean isPreviousEnabled = false;
    private boolean isFinishEnabled = false;
    private int totalChoices = 0;
    private boolean fromJumpWidget = false;
    private boolean fromLinkWidget = false;
    private String result = null;
    private boolean outputDocument = false;
    private boolean endsWizard = false;

    public CmdLineController(Wizard wizard) {
        this.wizard = wizard;
        this.input = new BufferedReader(new InputStreamReader(System.in));
    }

    public Document run() {
        Form form = null;
        String response = this.process(this.wizard.getFirstForm());
        this.running = true;
        while (this.running) {
            boolean validationOK;
            if (response.equalsIgnoreCase(charP) && this.isPreviousEnabled) {
                form = this.wizard.getCurrentForm();
                String backId = form.getBackIdentifier();
                if (backId != null) {
                    response = this.process(this.wizard.getForm(backId));
                    continue;
                }
                response = this.process(this.wizard.getPreviousForm());
                continue;
            }
            if (response.equalsIgnoreCase(charN) && this.isNextEnabled) {
                form = this.wizard.getCurrentForm();
                validationOK = this.validate(form);
                if (validationOK) {
                    String nextId = form.getNextIdentifier();
                    if (nextId != null) {
                        response = this.process(this.wizard.getForm(nextId));
                        continue;
                    }
                    response = this.process(this.wizard.getNextFormForCLI());
                    continue;
                }
                response = this.process(this.wizard.getCurrentForm());
                continue;
            }
            if (response.matches("[1-9]?[0-9]")) {
                int widgetIndex = Integer.parseInt(response);
                if (widgetIndex <= this.totalChoices) {
                    response = this.process(this.wizard.getCurrentForm(), widgetIndex);
                    if (!(this.fromBoxWidget || this.fromJumpWidget || this.fromLinkWidget)) {
                        List widgets = this.wizard.getCurrentForm().getWidgets();
                        int index = 1;
                        for (Widget widget : widgets) {
                            if (widget instanceof ResponseWidget) {
                                if (widgetIndex == index) {
                                    ((ResponseWidget)((Object)widget)).setResponse(response);
                                }
                                ++index;
                                continue;
                            }
                            if (widget instanceof SelectWidget) {
                                if (widgetIndex == index) {
                                    ((SelectWidget)widget).setSelected(!((SelectWidget)widget).isSelected());
                                }
                                ++index;
                                continue;
                            }
                            if (!(widget instanceof RadioBoxWidget) && !(widget instanceof ComboBoxWidget) && !(widget instanceof JumpWidget) && !(widget instanceof LinkWidget) && !(widget instanceof HTMLWidget)) continue;
                            ++index;
                        }
                    } else {
                        this.fromBoxWidget = false;
                        this.fromJumpWidget = false;
                        this.fromLinkWidget = false;
                    }
                }
                if (this.endsWizard) {
                    this.running = false;
                    continue;
                }
                response = this.process(this.wizard.getCurrentForm());
                continue;
            }
            if (response.equalsIgnoreCase(charF) && this.isFinishEnabled) {
                form = this.wizard.getCurrentForm();
                validationOK = this.validate(form);
                if (validationOK) {
                    ResponseError responseError = this.wizard.output(form);
                    int msgCode = 9999;
                    this.result = responseError.getCode();
                    if (this.result != null) {
                        msgCode = Integer.parseInt(this.result);
                    }
                    if (msgCode == 0) {
                        this.outputDocument = true;
                        this.running = false;
                        this.wizard.closeCSMAuthFrame();
                        continue;
                    }
                    if (responseError.getSeverity().equalsIgnoreCase("F")) {
                        this.errorMessage = I18N.getString(this.result + ".err");
                        response = this.process(this.wizard.getCurrentForm());
                        continue;
                    }
                    if (responseError.getSeverity().equalsIgnoreCase("W")) {
                        this.errorMessage = I18N.getString(this.result + ".msg");
                        response = this.process(this.wizard.getCurrentForm());
                        continue;
                    }
                    this.errorMessage = I18N.getString(this.result + ".err");
                    response = this.process(this.wizard.getCurrentForm());
                    continue;
                }
                response = this.process(this.wizard.getCurrentForm());
                continue;
            }
            if (response.equalsIgnoreCase(charC)) {
                this.running = false;
                this.outputDocument = false;
                this.wizard.closeCSMAuthFrame();
                continue;
            }
            response = this.process(this.wizard.getCurrentForm());
        }
        if (this.outputDocument) {
            return ((CmdLineWizard)this.wizard).getDocument();
        }
        return null;
    }

    private String process(Form form) {
        return this.process(form, 0);
    }

    private String process(Form form, int widgetIndex) {
        String url;
        String formIdentifier;
        String result = "";
        Form currentForm = form;
        this.fromJumpWidget = false;
        this.fromLinkWidget = false;
        int currentFormIndex = 0;
        if (form.getFormIdentifier() != null) {
            currentFormIndex = this.wizard.getFormIndex(form.getFormIdentifier());
        }
        if ((formIdentifier = currentForm.getJumpToFormIdentifier(widgetIndex)) != null) {
            currentForm = this.wizard.getForm(formIdentifier);
            if (currentForm != null && !currentForm.isPopup()) {
                widgetIndex = -1;
                this.fromJumpWidget = true;
            } else if (currentForm != null && currentForm.isPopup()) {
                Web.execURL("file:///tmp/asset-output.html");
                this.fromJumpWidget = true;
                currentForm = form;
                widgetIndex = -1;
                this.wizard.setFormIndex(currentFormIndex);
            } else {
                currentForm = form;
                widgetIndex = 0;
            }
        }
        if ((url = currentForm.getURL(widgetIndex)) != null) {
            this.fromLinkWidget = true;
            Web.execURL(url);
            this.endsWizard = currentForm.getEndsWizard(widgetIndex);
            widgetIndex = -1;
        }
        if (formIdentifier == null && url == null) {
            this.renderForm(currentForm, widgetIndex);
        }
        if (!(this.fromBoxWidget || this.fromJumpWidget || this.fromLinkWidget)) {
            try {
                result = this.input.readLine();
            }
            catch (IOException e) {
                System.err.println(e.getLocalizedMessage());
            }
            return result;
        }
        return null;
    }

    private void renderForm(Form form, int widgetIndex) {
        this.repeat("-", 80);
        System.out.print("\n");
        System.out.println(form.getTitle());
        System.out.println();
        System.out.println();
        List widgets = form.getWidgets();
        int numberOfPositionsForm = this.findNumberOfPositions(widgets.size());
        int numberOfPosistionWidget = 0;
        int differenceNumberOfPosistionWidget = 0;
        String widgetText = "";
        int index = 1;
        int printIndex = 1;
        for (Widget widget : widgets) {
            numberOfPosistionWidget = this.findNumberOfPositions(printIndex);
            differenceNumberOfPosistionWidget = numberOfPositionsForm - numberOfPosistionWidget;
            if (widget instanceof ResponseWidget || widget instanceof SelectWidget) {
                if (widgetIndex == printIndex) {
                    widgetText = widget.getText() + " ";
                    this.repeat(" ", differenceNumberOfPosistionWidget);
                    System.out.print(printIndex++ + ". ");
                    if (widget instanceof SelectWidget) {
                        ((CmdLineSelectWidget)widget).draw(0);
                        break;
                    }
                    widget.draw();
                    break;
                }
                if (widgetIndex == 0) {
                    this.repeat(" ", differenceNumberOfPosistionWidget);
                    System.out.print(printIndex++ + ". ");
                    if (widget instanceof SelectWidget) {
                        ((CmdLineSelectWidget)widget).draw(1);
                    } else {
                        widget.draw();
                    }
                } else {
                    ++printIndex;
                }
                ++index;
                continue;
            }
            if (widget instanceof RadioBoxWidget || widget instanceof ComboBoxWidget) {
                boolean radioBox = false;
                boolean comboBox = false;
                boolean draw = false;
                if (widgetIndex == printIndex) {
                    this.parentBoxWidgetIndex = widgetIndex;
                    this.parentBoxWidget = widget;
                    this.handleBox(widgetIndex, form);
                    return;
                }
                if (widgetIndex == 0) {
                    List widgetsBox = null;
                    if (widget instanceof RadioBoxWidget) {
                        this.repeat(" ", differenceNumberOfPosistionWidget);
                        System.out.print(printIndex++ + ". " + ((CmdLineRadioBoxWidget)widget).getDisplayTitle());
                        widgetsBox = ((CmdLineRadioBoxWidget)widget).getWidgets();
                        radioBox = true;
                    } else if (widget instanceof ComboBoxWidget) {
                        this.repeat(" ", differenceNumberOfPosistionWidget);
                        System.out.print(printIndex++ + ". " + ((CmdLineComboBoxWidget)widget).getDisplayTitle());
                        widgetsBox = ((CmdLineComboBoxWidget)widget).getWidgets();
                        comboBox = true;
                    }
                    System.out.println();
                    boolean indexBox = true;
                    for (Widget widgetInBox : widgetsBox) {
                        if (comboBox) {
                            if (!(widgetInBox instanceof SelectWidget) || !((SelectWidget)widgetInBox).isSelected()) continue;
                            widgetText = widgetInBox.getText() + " ";
                            ((CmdLineSelectWidget)widgetInBox).draw(5);
                            draw = true;
                            continue;
                        }
                        widgetText = widgetInBox.getText() + " ";
                        widgetInBox.draw();
                    }
                    widgetText = "";
                    if (!draw && comboBox) {
                        System.out.println("     " + selectionMsg);
                    }
                } else {
                    ++printIndex;
                }
                ++index;
                continue;
            }
            if (widget instanceof JumpWidget || widget instanceof LinkWidget) {
                if (widgetIndex == 0) {
                    this.repeat(" ", differenceNumberOfPosistionWidget);
                    System.out.print(printIndex++ + ".");
                    widget.draw();
                    continue;
                }
                ++printIndex;
                continue;
            }
            if (widget instanceof HTMLWidget || widget instanceof TextIconLabelWidget) continue;
            ++index;
            widget.draw();
        }
        System.out.println();
        System.out.println();
        System.out.println(this.errorMessage);
        this.errorMessage = "";
        if (!this.wizard.isFirstForm() && !form.isStart() && form.isNavigator()) {
            System.out.print(PREVIOUS);
            this.isPreviousEnabled = true;
        } else {
            this.isPreviousEnabled = false;
        }
        if (!this.wizard.isLastForm() && !form.isFinish() && form.isNavigator()) {
            System.out.print(NEXT);
            this.isNextEnabled = true;
        } else {
            this.isNextEnabled = false;
        }
        if ((this.wizard.isLastForm() || form.isFinish()) && form.isNavigator()) {
            System.out.print(FINISH);
            this.isFinishEnabled = true;
        } else {
            this.isFinishEnabled = false;
        }
        if (form.isNavigator()) {
            System.out.print(CANCEL);
        }
        System.out.print("\n");
        System.out.print(PROMPT + widgetText);
        this.totalChoices = printIndex - 1;
    }

    private int findNumberOfPositions(int number) {
        if (number < 10) {
            return 1;
        }
        if (number < 100 && number > 9) {
            return 2;
        }
        if (number < 1000 && number > 99) {
            return 3;
        }
        if (number < 10000 && number > 999) {
            return 4;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleBox(int widgetIndex, Form form) {
        this.fromBoxWidget = true;
        String widgetText = "";
        List widgets = null;
        String displayTitle = "";
        int linesPerPage = 10;
        if (this.parentBoxWidget instanceof RadioBoxWidget) {
            widgets = ((CmdLineRadioBoxWidget)this.parentBoxWidget).getWidgets();
            displayTitle = ((CmdLineRadioBoxWidget)this.parentBoxWidget).getDisplayTitle();
        } else if (this.parentBoxWidget instanceof ComboBoxWidget) {
            widgets = ((CmdLineComboBoxWidget)this.parentBoxWidget).getWidgets();
            displayTitle = ((CmdLineComboBoxWidget)this.parentBoxWidget).getDisplayTitle();
            linesPerPage = ((CmdLineComboBoxWidget)this.parentBoxWidget).getSize();
        }
        int startIndex = 1;
        int endIndex = startIndex + linesPerPage;
        while (true) {
            System.out.println(widgetIndex + ". " + displayTitle);
            int indexBox = 1;
            for (Widget widgetInBox : widgets) {
                if (indexBox >= startIndex && indexBox < endIndex && indexBox <= widgets.size()) {
                    System.out.print("    <" + indexBox + ">");
                    ((CmdLineSelectWidget)widgetInBox).draw(0);
                    ++indexBox;
                    continue;
                }
                ++indexBox;
            }
            System.out.println();
            System.out.println();
            if (startIndex > linesPerPage || startIndex > 1) {
                System.out.print(FIRST);
                System.out.print(PREVIOUS);
                this.isPreviousEnabled = true;
            } else {
                this.isPreviousEnabled = false;
            }
            if (endIndex < widgets.size()) {
                System.out.print(NEXT);
                this.isNextEnabled = true;
                System.out.print(LAST);
            } else {
                this.isNextEnabled = false;
            }
            System.out.print(BACK);
            System.out.print("\n");
            System.out.print(PROMPT + widgetText);
            this.totalChoices = indexBox - 1;
            String response = "";
            try {
                response = this.input.readLine();
            }
            catch (IOException e) {
                System.err.println(e.getLocalizedMessage());
            }
            if (response.equalsIgnoreCase(charB)) return;
            if (response.equalsIgnoreCase(charF)) {
                startIndex = 1;
                endIndex = startIndex + linesPerPage;
                continue;
            }
            if (response.equalsIgnoreCase(charL)) {
                endIndex = widgets.size() + 1;
                startIndex = endIndex - linesPerPage;
                if (startIndex >= 1) continue;
                startIndex = 1;
                continue;
            }
            if (response.equalsIgnoreCase(charP) && this.isPreviousEnabled) {
                endIndex = startIndex;
                if ((startIndex = endIndex - linesPerPage) >= 1) continue;
                startIndex = 1;
                endIndex = startIndex + linesPerPage;
                continue;
            }
            if (response.equalsIgnoreCase(charN) && this.isNextEnabled) {
                startIndex = endIndex;
                endIndex += linesPerPage;
                continue;
            }
            if (response.equalsIgnoreCase(charC) || !response.matches("[1-9]?[0-9]?[0-9]")) continue;
            boolean selected = false;
            int selectWidgetIndex = Integer.parseInt(response);
            indexBox = 1;
            if (this.parentBoxWidget instanceof RadioBoxWidget) {
                widgets = ((CmdLineRadioBoxWidget)this.parentBoxWidget).getWidgets();
            } else if (this.parentBoxWidget instanceof ComboBoxWidget) {
                widgets = ((CmdLineComboBoxWidget)this.parentBoxWidget).getWidgets();
            }
            for (Widget widgetInBox : widgets) {
                if (widgetInBox instanceof SelectWidget) {
                    if (selectWidgetIndex == indexBox) {
                        ((SelectWidget)widgetInBox).setSelected(true);
                        selected = true;
                    } else {
                        ((SelectWidget)widgetInBox).setSelected(false);
                    }
                }
                ++indexBox;
            }
            if (selected) return;
        }
    }

    private void repeat(String text, int times) {
        for (int i = 0; i < times; ++i) {
            System.out.print(text);
        }
    }

    private boolean validate(Form form) {
        boolean validationOK = true;
        String password = null;
        String reTypePassword = null;
        int passwordCheck = 0;
        String email = " ";
        List widgets = form.getWidgets();
        boolean index = true;
        for (Widget widget : widgets) {
            Object[] errorArguments;
            if (widget instanceof ResponseWidget) {
                Object[] errorArguments2;
                String validationError;
                String response;
                if (widget instanceof CmdLineFieldWidget) {
                    response = ((ResponseWidget)((Object)widget)).getResponse();
                    validationError = Validation.validateValue(response, widget);
                    if (validationError == null || !validationOK) continue;
                    errorArguments2 = new Object[]{widget.getText()};
                    this.errorMessage = I18N.getFormattedString("cli.isinvalid.msg", errorArguments2);
                    validationOK = false;
                    continue;
                }
                if (!(widget instanceof CmdLinePasswordWidget)) continue;
                response = ((ResponseWidget)((Object)widget)).getResponse();
                validationError = Validation.validateValue(response, widget);
                if (passwordCheck == 0) {
                    password = response;
                    ++passwordCheck;
                } else {
                    reTypePassword = response;
                    ++passwordCheck;
                }
                if (validationError != null && validationOK) {
                    errorArguments2 = new Object[]{widget.getText()};
                    this.errorMessage = I18N.getFormattedString("cli.isinvalid.msg", errorArguments2);
                    validationOK = false;
                }
                if (passwordCheck != 2 || password.equals(reTypePassword) || !validationOK) continue;
                this.errorMessage = passwordNotMatchMsg;
                validationOK = false;
                continue;
            }
            if (widget instanceof RadioBoxWidget || widget instanceof ComboBoxWidget) {
                if (!widget.isRequired() || this.validateBox(widget) || !validationOK) continue;
                validationOK = false;
                errorArguments = new Object[]{widget.getText()};
                if (this.accept) {
                    this.errorMessage = I18N.getFormattedString("cli.selectionentry.msg", errorArguments);
                    continue;
                }
                this.errorMessage = I18N.getFormattedString("cli.mustbeselected.msg", errorArguments);
                continue;
            }
            if (!(widget instanceof SelectWidget) || !((SelectWidget)widget).isRequired() || ((SelectWidget)widget).isSelected() || !validationOK) continue;
            errorArguments = new Object[]{widget.getText()};
            this.errorMessage = I18N.getFormattedString("cli.mustbeselected.msg", errorArguments);
            validationOK = false;
        }
        return validationOK;
    }

    private String getI18NValue(String literalValue) {
        return literalValue;
    }

    private boolean validateBox(Widget widget) {
        List widgets = null;
        boolean selected = false;
        boolean accept = false;
        int widgetInBoxIndex = 1;
        if (widget instanceof RadioBoxWidget) {
            widgets = ((CmdLineRadioBoxWidget)widget).getWidgets();
        } else if (widget instanceof ComboBoxWidget) {
            widgets = ((CmdLineComboBoxWidget)widget).getWidgets();
        }
        for (Widget widgetInBox : widgets) {
            if (widgetInBox instanceof SelectWidget) {
                if (((SelectWidget)widgetInBox).isSelected()) {
                    if (((SelectWidget)widgetInBox).isRequired()) {
                        selected = true;
                        accept = true;
                        continue;
                    }
                    selected = true;
                    continue;
                }
                ++widgetInBoxIndex;
                if (!((SelectWidget)widgetInBox).isRequired()) continue;
                selected = false;
                accept = false;
                break;
            }
            ++widgetInBoxIndex;
        }
        return selected;
    }
}

