/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.RadioBoxWidget;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.cli.CmdLineComboBoxWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineSelectWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineUnknownWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWizard;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class CmdLineRadioBoxWidget
extends CmdLineWidget
implements Widget,
RadioBoxWidget {
    private List widgets = new ArrayList();
    private String title;
    private String displayTitle;
    private boolean isHorizontal;
    private boolean isVertical;

    public CmdLineRadioBoxWidget(String text) {
        this.title = text;
        this.displayTitle = text;
    }

    public CmdLineRadioBoxWidget(Form form, String text, String reload, Element element, String required, String editable, String scrollable, String orientation, String defaultValue, String validPattern, String patternError, String validMatch, String matchError, String note, String fontSize, String fontStyle, String id, String newRow, String leftAt, String rightTo, String fontColor, String isDisplayed) {
        this.form = form;
        this.setReload(reload);
        this.setRequired(required);
        this.setEditable(editable);
        this.setScrollable(scrollable);
        this.defaultValue = defaultValue;
        this.validPattern = validPattern;
        this.patternError = patternError;
        this.validMatch = validMatch;
        this.matchError = matchError;
        this.note = note;
        this.setFontSize(fontSize);
        this.fontStyle = fontStyle;
        this.fontColor = fontColor;
        this.id = id;
        this.setNewRow(newRow);
        this.setLeftAt(leftAt);
        this.setRightTo(rightTo);
        this.isDisplayed = isDisplayed;
        this.title = text;
        List widgetElms = element.getChildren();
        Iterator i = widgetElms.iterator();
        while (i.hasNext()) {
            this.addWidget(this.createWidget((Element)i.next()));
        }
        this.displayTitle = required != null && required.equalsIgnoreCase("yes") ? I18N.getString("is.required.lbl") + text : text;
        if (orientation != null && orientation.equalsIgnoreCase("vertical")) {
            this.isHorizontal = false;
            this.isVertical = true;
        } else {
            this.isVertical = false;
            this.isHorizontal = true;
        }
        if (defaultValue != null && defaultValue.length() > 0) {
            this.setDefaultValue(defaultValue);
        }
    }

    public void setDefaultValue(String defaultValue) {
        for (Widget widgetInBox : this.widgets) {
            if (!(widgetInBox instanceof SelectWidget) || !((CmdLineSelectWidget)widgetInBox).getText().equalsIgnoreCase(defaultValue)) continue;
            ((CmdLineSelectWidget)widgetInBox).setSelected(true);
            this.defaultValue = defaultValue;
        }
    }

    private Widget createWidget(Element element) {
        CmdLineWidget result = new CmdLineUnknownWidget("");
        String name = element.getName();
        result = name.equalsIgnoreCase(WidgetType.SELECT.toString()) ? new CmdLineSelectWidget(this.form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "onclicknext"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), null, null, null, null, null, null, null, null, null, null, null, null, null) : new CmdLineUnknownWidget(CmdLineWizard.getText(element));
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public List getWidgets() {
        return this.widgets;
    }

    public void addWidget(Widget widget) {
        if (widget != null) {
            WidgetType type = widget.getType();
            String text = widget.getText();
            boolean exists = false;
            for (Widget existingWidget : this.widgets) {
                if (widget.getType() != WidgetType.SELECT || text == null || !text.equals(existingWidget.getText()) || type != existingWidget.getType()) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.widgets.add(widget);
            }
        }
    }

    public WidgetType getType() {
        return WidgetType.RADIOBOX;
    }

    public String getText() {
        return this.title;
    }

    public void setText(String text) {
        this.title = text;
    }

    public void draw() {
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public String getResponse() {
        return CmdLineComboBoxWidget.getValueOfSelectedWidgetInList(this.getWidgets());
    }

    public void setResponse(String response) {
        CmdLineComboBoxWidget.setSelectedWidgetInListByValue(this.getWidgets(), response);
    }
}

