/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.wizard.swing.Field;
import com.sun.cns.basicreg.wizard.swing.FormPanel;
import com.sun.cns.basicreg.wizard.swing.WizardDialog;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class FieldPanel
extends JPanel {
    private static boolean borderColor = true;
    private FormPanel parentFormPanel;
    private JComponent component;
    private JLabel label;
    private Field field;
    private boolean hasErrorSupport;
    private JLabel errorLabel;
    private static final Font SUBNOTE_FONT = new Font("SansSerif", 0, 10);
    private static final Font PRENOTE_FONT = new Font("SansSerif", 0, 10);
    private static final Font ERROR_FONT = new Font("SansSerif", 2, 10);
    private static final Color ERROR_COLOR = Color.RED;
    private static final Logger LOG = Logger.getLogger(FieldPanel.class.getName());

    public FieldPanel(FormPanel parentFormPanel, JComponent component, JLabel label, Field field, boolean hasErrorSupport, double maximumLabelWidth) {
        this.parentFormPanel = parentFormPanel;
        this.component = component;
        this.field = field;
        this.label = label;
        this.hasErrorSupport = hasErrorSupport;
        this.buildMe(maximumLabelWidth);
    }

    private void buildMe(double maximumLabelWidth) {
        Dimension fixedSize;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        String prenote = this.field.getPrenote();
        if (this.label != null || prenote != null) {
            JPanel flowPanel = new JPanel(new FlowLayout(0, 0, 0));
            if (prenote != null && prenote.trim() != "") {
                LOG.finest("ADD PRENOTE: " + prenote);
                JLabel prenoteLabel = new JLabel(prenote);
                prenoteLabel.setFont(PRENOTE_FONT);
                flowPanel.add(prenoteLabel);
                prenoteLabel.getAccessibleContext().setAccessibleName(prenote);
                prenoteLabel.getAccessibleContext().setAccessibleDescription(prenote);
            }
            flowPanel.add(this.getDisplayComponent());
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, 0));
            if (this.label != null) {
                LOG.finest("ADD LABEL: " + this.label);
                if (this.field.getType() == 2 || this.field.getType() == 1 || this.field.getType() == 4) {
                    Dimension labelSize = this.label.getPreferredSize();
                    fixedSize = new Dimension();
                    fixedSize.setSize(maximumLabelWidth, labelSize.getHeight());
                    this.label.setPreferredSize(fixedSize);
                    this.label.setMinimumSize(fixedSize);
                    this.label.setMaximumSize(fixedSize);
                    this.label.setLabelFor(this.component);
                    if (this.field.getMnemonic() != null && I18N.isLocalLanguageEnglish()) {
                        this.label.setDisplayedMnemonic(Integer.parseInt(this.field.getMnemonic().trim()));
                    }
                }
                this.label.setAlignmentY(0.5f);
                mainPanel.add(this.label);
            }
            flowPanel.setAlignmentY(0.5f);
            mainPanel.add(flowPanel);
            mainPanel.setAlignmentX(0.0f);
            this.add(mainPanel);
        } else {
            JComponent displayComponent = this.getDisplayComponent();
            displayComponent.setAlignmentX(0.0f);
            displayComponent.setMaximumSize(displayComponent.getPreferredSize());
            this.add(displayComponent);
        }
        String subnote = this.field.getSubnote();
        if (subnote != null && subnote.trim() != "") {
            LOG.finest("ADD SUBNOTE: " + subnote);
            JLabel subnoteLabel = new JLabel(subnote);
            subnoteLabel.setFont(SUBNOTE_FONT);
            if (this.label != null) {
                Dimension subnoteSize = subnoteLabel.getPreferredSize();
                fixedSize = new Dimension();
                fixedSize.setSize(maximumLabelWidth + subnoteSize.getWidth(), subnoteSize.getHeight());
                subnoteLabel.setPreferredSize(fixedSize);
                subnoteLabel.setMinimumSize(fixedSize);
                subnoteLabel.setMaximumSize(fixedSize);
                subnoteLabel.setHorizontalAlignment(4);
            }
            subnoteLabel.setAlignmentX(0.0f);
            subnoteLabel.getAccessibleContext().setAccessibleName(subnote);
            subnoteLabel.getAccessibleContext().setAccessibleDescription(subnote);
            this.add(subnoteLabel);
        }
        if (this.hasErrorSupport) {
            String error = this.field.getError();
            LOG.finest("ADD ERROR: " + error);
            this.errorLabel = new JLabel(error == null ? " " : error);
            this.errorLabel.setFont(ERROR_FONT);
            this.errorLabel.setForeground(ERROR_COLOR);
            this.errorLabel.setAlignmentX(0.0f);
            this.errorLabel.getAccessibleContext().setAccessibleName(error);
            this.errorLabel.getAccessibleContext().setAccessibleDescription(error);
            this.add(this.errorLabel);
        } else {
            this.errorLabel = null;
        }
        this.setMaximumSize(this.getPreferredSize());
    }

    public void setErrorText(String errorText) {
        if (this.errorLabel == null) {
            LOG.severe("ERROR - can not set error on this field panel");
            return;
        }
        this.errorLabel.setText(errorText == null ? " " : errorText);
    }

    private JComponent getDisplayComponent() {
        if (this.field.getIsScrollable()) {
            JScrollPane aScrollPane = new JScrollPane(this.component);
            aScrollPane.setFocusable(true);
            JDialog dialog = this.parentFormPanel.getParentWizardPanel().getParentDialog();
            if (this.field.getType() == 8 && dialog != null && dialog instanceof WizardDialog) {
                JViewport viewport = aScrollPane.getViewport();
                Dimension preferredSize = viewport.getPreferredSize();
                viewport.setPreferredSize(new Dimension(Math.min((int)preferredSize.getWidth(), 575), Math.min((int)preferredSize.getHeight(), 350)));
            }
            aScrollPane.getAccessibleContext().setAccessibleName("Scroll Panel");
            aScrollPane.getAccessibleContext().setAccessibleDescription("Scroll Panel");
            return aScrollPane;
        }
        return this.component;
    }

    public static double getMaximumWidth(JLabel[] labels, JComponent[] components) {
        if (labels == null || labels.length == 0) {
            return 1.0;
        }
        double maximumWidth = 0.0;
        for (int index = 0; index < labels.length; ++index) {
            Dimension labelDimension;
            double width;
            if (labels[index] == null || components[index] == null || !(components[index] instanceof JComboBox) && !(components[index] instanceof JTextField) && !(components[index] instanceof JPasswordField) || !((width = (labelDimension = labels[index].getPreferredSize()).getWidth()) > maximumWidth)) continue;
            maximumWidth = width;
        }
        LOG.finest("MAXIMUM WIDTH + 4 IS: " + (maximumWidth + 4.0));
        return maximumWidth + 4.0;
    }
}

