/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.wizard.swing.CustomField;
import com.sun.cns.basicreg.wizard.swing.Field;
import com.sun.cns.basicreg.wizard.swing.FieldPanel;
import com.sun.cns.basicreg.wizard.swing.RadioBoxPanel;
import com.sun.cns.basicreg.wizard.swing.WizardPanel;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.Util;
import com.sun.cns.basicreg.wizard.util.Web;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class FormPanel
extends JPanel {
    public static final String TRUE_STR = "true";
    public static final String FALSE_STR = "false";
    protected WizardPanel parentWizardPanel;
    protected Field[] fields;
    protected FieldPanel[] fieldPanels;
    protected JLabel[] m_labels;
    protected JComponent[] m_components;
    protected boolean[] hasErrorSupport;
    protected double maximumLabelWidth;
    protected Map buttonGroupsMap;
    private static final Color LABEL_COLOR = new JLabel("test").getForeground();
    private static final Logger LOG = Logger.getLogger(FormPanel.class.getName());

    public FormPanel(WizardPanel parentWizardPanel, Field[] fields) {
        this(parentWizardPanel, fields, null);
    }

    public FormPanel(WizardPanel parentWizardPanel, Field[] fields, JComponent[] customFormFields) {
        this(parentWizardPanel, fields, customFormFields, null);
    }

    public FormPanel(WizardPanel parentWizardPanel, Field[] fields, JComponent[] customFormFields, ActionListener returnActionListener) {
        this.parentWizardPanel = parentWizardPanel;
        this.fields = fields;
        this.buildLabelsAndComponents(customFormFields, returnActionListener);
        this.setAnyInitialValues();
        this.setLayout(new BoxLayout(this, 1));
        this.layoutLabelsAndComponents();
    }

    private void buildLabelsAndComponents(JComponent[] customFormFields, ActionListener returnActionListener) {
        this.m_labels = new JLabel[this.fields.length];
        this.m_components = new JComponent[this.fields.length];
        this.hasErrorSupport = new boolean[this.fields.length];
        HashMap<String, ButtonGroup> buttonGroupsMap = new HashMap<String, ButtonGroup>();
        for (int i = 0; i < this.fields.length; ++i) {
            int fieldType = this.fields[i].getType();
            switch (fieldType) {
                case 0: {
                    if (customFormFields != null && customFormFields[i] != null) {
                        this.m_components[i] = customFormFields[i];
                        this.hasErrorSupport[i] = ((CustomField)((Object)customFormFields[i])).hasErrorSupport();
                        break;
                    }
                    LOG.severe("ERROR - FormPanel() missing custom form field");
                    this.m_components[i] = new JLabel("missing custom field");
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 1: {
                    this.m_components[i] = new JTextField(this.fields[i].getLength());
                    this.hasErrorSupport[i] = true;
                    break;
                }
                case 7: {
                    Icon labelIcon;
                    String labelIconFilename = this.fields[i].getLabelIconFilename();
                    String labelIconDescription = this.fields[i].getLabelIconDescription();
                    String labelIconHorizontalTextPosition = this.fields[i].getLabelIconHorizontalTextPosition();
                    String labelIconVerticalTextPosition = this.fields[i].getLabelIconVerticalTextPosition();
                    this.m_components[i] = labelIconFilename != null ? ((labelIcon = I18N.getIcon(labelIconFilename, labelIconDescription)) == null ? new JLabel() : new JLabel(labelIcon)) : new JLabel();
                    if (labelIconHorizontalTextPosition != null) {
                        if (labelIconHorizontalTextPosition.equalsIgnoreCase("left")) {
                            ((JLabel)this.m_components[i]).setHorizontalTextPosition(2);
                        } else if (labelIconHorizontalTextPosition.equalsIgnoreCase("center")) {
                            ((JLabel)this.m_components[i]).setHorizontalTextPosition(0);
                        } else if (labelIconHorizontalTextPosition.equalsIgnoreCase("right")) {
                            ((JLabel)this.m_components[i]).setHorizontalTextPosition(4);
                        }
                    }
                    if (labelIconVerticalTextPosition != null) {
                        if (labelIconVerticalTextPosition.equalsIgnoreCase("top")) {
                            ((JLabel)this.m_components[i]).setVerticalTextPosition(1);
                        } else if (labelIconVerticalTextPosition.equalsIgnoreCase("center")) {
                            ((JLabel)this.m_components[i]).setVerticalTextPosition(0);
                        } else if (labelIconVerticalTextPosition.equalsIgnoreCase("bottom")) {
                            ((JLabel)this.m_components[i]).setVerticalTextPosition(3);
                        }
                    }
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 2: {
                    this.m_components[i] = this.fields[i].getPopulation() != null ? new JComboBox<Object>(this.fields[i].getPopulation()) : new JComboBox();
                    this.hasErrorSupport[i] = true;
                    break;
                }
                case 3: {
                    if (this.fields[i].getIsSelectRadio()) {
                        this.m_components[i] = new JRadioButton(this.fields[i].getLabel());
                        if (this.fields[i].getMnemonic() != null && I18N.isLocalLanguageEnglish()) {
                            ((JRadioButton)this.m_components[i]).setMnemonic(Integer.parseInt(this.fields[i].getMnemonic().trim()));
                        }
                        this.hasErrorSupport[i] = false;
                        String radioGroupId = this.fields[i].getButtonGroupId();
                        if (radioGroupId != null) {
                            ButtonGroup buttonGroup = (ButtonGroup)buttonGroupsMap.get(radioGroupId);
                            if (buttonGroup == null) {
                                buttonGroup = new ButtonGroup();
                                buttonGroupsMap.put(radioGroupId, buttonGroup);
                            }
                            buttonGroup.add((JRadioButton)this.m_components[i]);
                        }
                    } else {
                        this.m_components[i] = new JCheckBox(this.fields[i].getLabel());
                        this.hasErrorSupport[i] = true;
                        if (this.fields[i].getMnemonic() != null && I18N.isLocalLanguageEnglish()) {
                            ((JCheckBox)this.m_components[i]).setMnemonic(Integer.parseInt(this.fields[i].getMnemonic().trim()));
                        }
                    }
                    ((JToggleButton)this.m_components[i]).setVerticalTextPosition(1);
                    this.fields[i].setLabel(null);
                    String slaveId = this.fields[i].getSlaveId();
                    String[] slaveIds = Util.getCommaSeparatedValues(slaveId);
                    if (slaveIds == null) break;
                    for (int index = 0; index < slaveIds.length; ++index) {
                        String slaveWidgetId = slaveIds[index];
                        LOG.finest("  SSSS  SLAVE WID: " + slaveWidgetId);
                        final int slaveIndex = this.getFieldIndex(slaveWidgetId);
                        final int myIndex = i;
                        if (slaveWidgetId == null || slaveIndex == -1) continue;
                        ((JToggleButton)this.m_components[i]).addItemListener(new ItemListener(){

                            public void itemStateChanged(ItemEvent itemEvent) {
                                LOG.finest("SLAVE LISTENER CALLED");
                                String widgetId = FormPanel.this.fields[myIndex].getId();
                                LOG.finest("MASTER WID: " + widgetId);
                                String slaveValue = FormPanel.this.parentWizardPanel.getWidgetSlaveValue(widgetId);
                                LOG.finest("SLAVE INDEX: " + slaveIndex);
                                LOG.finest("SLAVE VALUE: " + slaveValue);
                                if (((JToggleButton)FormPanel.this.m_components[myIndex]).isSelected()) {
                                    FormPanel.this.setFieldEditable(slaveIndex, true);
                                    FormPanel.this.setFieldValue(slaveIndex, slaveValue);
                                } else {
                                    FormPanel.this.setFieldEditable(slaveIndex, false);
                                    FormPanel.this.setFieldValue(slaveIndex, null);
                                }
                                FormPanel.this.fields[slaveIndex].setError(null);
                                if (FormPanel.this.fieldPanels != null && FormPanel.this.fieldPanels[slaveIndex] != null) {
                                    FormPanel.this.fieldPanels[slaveIndex].setErrorText(null);
                                }
                            }
                        });
                    }
                    break;
                }
                case 4: {
                    this.m_components[i] = new JPasswordField(this.fields[i].getLength());
                    this.hasErrorSupport[i] = true;
                    break;
                }
                case 5: {
                    this.m_components[i] = new RadioBoxPanel(this.fields[i].getIsVertical());
                    if (this.fields[i].getPopulation() != null) {
                        ((RadioBoxPanel)this.m_components[i]).addButtons((String[])this.fields[i].getPopulation());
                    }
                    this.hasErrorSupport[i] = true;
                    break;
                }
                case 6: {
                    this.m_components[i] = new JTextArea(this.fields[i].getNumberRows(), this.fields[i].getNumberColumns());
                    ((JTextArea)this.m_components[i]).setOpaque(this.fields[i].getIsScrollable());
                    ((JTextArea)this.m_components[i]).setLineWrap(true);
                    ((JTextArea)this.m_components[i]).setWrapStyleWord(true);
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 8: {
                    this.m_components[i] = new JEditorPane();
                    ((JEditorPane)this.m_components[i]).setMargin(new Insets(10, 10, 15, 15));
                    ((JEditorPane)this.m_components[i]).setContentType("text/html");
                    this.m_components[i].setOpaque(this.fields[i].getIsScrollable());
                    if (!this.fields[i].getIsEditable()) {
                        ((JEditorPane)this.m_components[i]).addHyperlinkListener(new ourHyperlinkListener());
                    }
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 9: {
                    this.m_components[i] = null;
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 10: {
                    this.m_components[i] = null;
                    this.hasErrorSupport[i] = false;
                    break;
                }
                default: {
                    LOG.severe("ERROR - FormPanel FormPanel() unknown field type");
                }
            }
            if (this.m_components[i] != null && fieldType != 8 && fieldType != 9 && fieldType != 10) {
                this.setComponentFont(this.m_components[i], this.fields[i].getFontFamily(), this.fields[i].getFontStyle(), this.fields[i].getFontSize(), this.fields[i].getFontColor());
            }
            if (this.m_components[i] != null) {
                if (this.fields[i].getLabel() != null && this.fields[i].getIsRequired()) {
                    StringBuffer labelSB = new StringBuffer("<html><font color='red'>");
                    labelSB.append(I18N.getString("is.required.txt"));
                    labelSB.append("</font>");
                    labelSB.append(this.fields[i].getLabel()).append("</html>");
                    this.m_labels[i] = new JLabel(labelSB.toString(), 2);
                    this.m_labels[i].getAccessibleContext().setAccessibleName(this.fields[i].getLabel());
                    this.m_labels[i].getAccessibleContext().setAccessibleDescription(this.fields[i].getLabel());
                } else if (this.fields[i].getLabel() != null) {
                    this.m_labels[i] = new JLabel(this.fields[i].getLabel(), 2);
                    this.m_labels[i].getAccessibleContext().setAccessibleName(this.fields[i].getLabel());
                    this.m_labels[i].getAccessibleContext().setAccessibleDescription(this.fields[i].getLabel());
                } else {
                    this.m_labels[i] = null;
                }
                if (this.fields[i].gets508Name() != null) {
                    this.m_components[i].getAccessibleContext().setAccessibleName(this.fields[i].gets508Name());
                }
                if (this.fields[i].gets508Desc() != null) {
                    this.m_components[i].getAccessibleContext().setAccessibleDescription(this.fields[i].gets508Desc());
                }
                if (this.fields[i].getToolTip() != null) {
                    this.m_components[i].setToolTipText(this.fields[i].getToolTip());
                }
            }
            this.maximumLabelWidth = FieldPanel.getMaximumWidth(this.m_labels, this.m_components);
            if (fieldType != 9 && fieldType != 10) {
                this.setFieldEditable(i, this.fields[i].getIsEditable());
            }
            if (returnActionListener == null) continue;
            this.registerKeyboardAction(returnActionListener, KeyStroke.getKeyStroke(10, 0, true), 1);
        }
    }

    private void setAnyInitialValues() {
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getInitialValue() == null) continue;
            this.setFieldValue(i, (String)this.fields[i].getInitialValue());
        }
    }

    public void layoutLabelsAndComponents() {
        LOG.info("Layout Form Panel: " + this.parentWizardPanel.getForm().getTitle());
        this.removeAll();
        this.add(Box.createVerticalGlue());
        this.fieldPanels = new FieldPanel[this.fields.length];
        JPanel rowPanel = null;
        int rowPanelWidth = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].isFieldDisplayEnabled()) {
                LOG.info("Do not show field (widget): " + this.fields[i].getId());
                continue;
            }
            if (this.m_components[i] == null) continue;
            this.fieldPanels[i] = new FieldPanel(this, this.m_components[i], this.m_labels[i], this.fields[i], this.hasErrorSupport[i], this.maximumLabelWidth);
            if (this.fields[i].getIsNewRow()) {
                if (rowPanel != null) {
                    this.addComponentToVerticalBoxContainer(rowPanel, this, 0.0f);
                }
                if (this.isNextFieldInNewRow(i)) {
                    rowPanel = null;
                    this.addComponentToVerticalBoxContainer(this.fieldPanels[i], this, 0.0f);
                    continue;
                }
                rowPanel = new JPanel();
                rowPanelWidth = 0;
                rowPanel.setLayout(new BoxLayout(rowPanel, 0));
                this.addComponentToHorizontalBoxContainer(this.fieldPanels[i], rowPanel, 0.0f);
                rowPanelWidth += (int)this.fieldPanels[i].getPreferredSize().getWidth();
                continue;
            }
            if (rowPanel == null) {
                LOG.severe("ERROR - expected row panel is null");
                continue;
            }
            int gapSize = this.fields[i].getLeftAt() > 0 ? this.fields[i].getLeftAt() - rowPanelWidth : (this.fields[i].getRightTo() > 0 ? this.fields[i].getRightTo() - rowPanelWidth - (int)this.fieldPanels[i].getPreferredSize().getWidth() : 5);
            LOG.finest(" ----> row gap size: " + gapSize);
            if (gapSize < 0) {
                gapSize = 5;
            }
            rowPanel.add(Box.createHorizontalStrut(gapSize));
            this.addComponentToHorizontalBoxContainer(this.fieldPanels[i], rowPanel, 0.0f);
            rowPanelWidth += (int)this.fieldPanels[i].getPreferredSize().getWidth();
        }
        if (rowPanel != null) {
            this.addComponentToVerticalBoxContainer(rowPanel, this, 0.0f);
        }
        this.add(Box.createVerticalGlue());
    }

    private boolean isNextFieldInNewRow(int currentIndex) {
        int index;
        for (index = currentIndex + 1; index < this.fields.length && this.m_components[index] == null; ++index) {
        }
        if (index >= this.fields.length) {
            return true;
        }
        return this.fields[index].getIsNewRow();
    }

    private void addComponentToVerticalBoxContainer(JComponent component, Container container, float xAlignment) {
        component.setMaximumSize(component.getPreferredSize());
        component.setAlignmentX(xAlignment);
        container.add(component);
        container.add(new Box.Filler(new Dimension(0, 5), new Dimension(0, 10), new Dimension(0, 20)));
    }

    private void addComponentToHorizontalBoxContainer(JComponent component, Container container, float yAlignment) {
        component.setAlignmentY(yAlignment);
        container.add(component);
    }

    private void setComponentFont(Component component, String fontFamily, String fontStyle, int fontSize, String fontColor) {
        StringTokenizer st;
        LOG.finest("MAKE FONT: " + fontStyle + ", " + fontSize + ", " + fontFamily + ", " + fontColor);
        HashMap<TextAttribute, Object> fontMap = new HashMap<TextAttribute, Object>();
        if (fontFamily != null) {
            fontMap.put(TextAttribute.FAMILY, fontFamily);
        }
        if (fontStyle != null) {
            st = new StringTokenizer(fontStyle, ",");
            while (st.hasMoreTokens()) {
                String fontStyleItem = st.nextToken().trim();
                if (fontStyleItem.equalsIgnoreCase("italic")) {
                    fontMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                    continue;
                }
                if (fontStyleItem.equalsIgnoreCase("underline")) {
                    fontMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    continue;
                }
                if (fontStyleItem.equalsIgnoreCase("bold")) {
                    fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    continue;
                }
                if (fontStyleItem.equalsIgnoreCase("light")) {
                    fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                    continue;
                }
                if (!fontStyleItem.equalsIgnoreCase("heavy")) continue;
                fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_HEAVY);
            }
        }
        if (fontSize != 0) {
            fontMap.put(TextAttribute.SIZE, new Float(fontSize));
        }
        component.setFont(new Font(fontMap));
        if (fontColor != null) {
            st = new StringTokenizer(fontColor, ",");
            if (st.countTokens() == 3) {
                String redHex = st.nextToken().trim();
                String greenHex = st.nextToken().trim();
                String blueHex = st.nextToken().trim();
                try {
                    int red = Integer.parseInt(redHex, 16);
                    int green = Integer.parseInt(greenHex, 16);
                    int blue = Integer.parseInt(blueHex, 16);
                    component.setForeground(new Color(red, green, blue));
                }
                catch (NumberFormatException nfEx) {
                    LOG.info("Ignoring invalid fontColor: " + fontColor);
                }
            } else {
                LOG.info("Ignoring invalid fontColor: " + fontColor);
            }
        }
    }

    public int getFieldIndex(String fieldId) {
        if (fieldId == null) {
            return -1;
        }
        for (int index = 0; index < this.fields.length; ++index) {
            String anId = this.fields[index].getId();
            if (anId == null || !anId.equals(fieldId)) continue;
            return index;
        }
        return -1;
    }

    public WizardPanel getParentWizardPanel() {
        return this.parentWizardPanel;
    }

    public Component getField(int fieldIndex) {
        return this.m_components[fieldIndex];
    }

    public void setFieldVisible(int fieldIndex, boolean visible) {
        this.m_labels[fieldIndex].setVisible(visible);
        this.m_components[fieldIndex].setVisible(visible);
        this.revalidate();
    }

    public boolean isFieldVisible(int fieldIndex) {
        return this.m_components[fieldIndex].isVisible();
    }

    public JComponent getFirstFocusableField() {
        int fieldIndex;
        if (this.m_components == null) {
            return null;
        }
        String initialFocusWidgetIdentifier = this.parentWizardPanel.getForm().getInitialFocusWidgetIdentifier();
        if (initialFocusWidgetIdentifier != null && (fieldIndex = this.getFieldIndex(initialFocusWidgetIdentifier)) >= 0 && fieldIndex < this.m_components.length && this.m_components[fieldIndex].isFocusable()) {
            return this.m_components[fieldIndex];
        }
        for (int i = 0; i < this.m_components.length; ++i) {
            if (this.m_components[i] == null || !this.m_components[i].isFocusable()) continue;
            return this.m_components[i];
        }
        return null;
    }

    public String getFieldValue(String fieldId) {
        int index = this.getFieldIndex(fieldId);
        if (index == -1) {
            LOG.severe("ERROR - no field found with id: " + fieldId);
            return null;
        }
        return this.getFieldValue(index);
    }

    public void setFieldValue(String fieldId, String valueStr) {
        int index = this.getFieldIndex(fieldId);
        if (index == -1) {
            LOG.severe("ERROR - no field found with id: " + fieldId);
            return;
        }
        this.setFieldValue(index, valueStr);
    }

    public boolean isFieldEditable(int fieldIndex) {
        boolean result = false;
        switch (this.fields[fieldIndex].getType()) {
            case 0: {
                result = ((CustomField)((Object)this.m_components[fieldIndex])).isFieldEditable();
                break;
            }
            case 1: {
                result = ((JTextField)this.m_components[fieldIndex]).isEditable();
                break;
            }
            case 7: {
                result = ((JLabel)this.m_components[fieldIndex]).isEnabled();
                break;
            }
            case 2: {
                result = ((JComboBox)this.m_components[fieldIndex]).isEnabled();
                break;
            }
            case 3: {
                result = ((JToggleButton)this.m_components[fieldIndex]).isEnabled();
                break;
            }
            case 4: {
                result = ((JPasswordField)this.m_components[fieldIndex]).isEditable();
                break;
            }
            case 5: {
                result = ((RadioBoxPanel)this.m_components[fieldIndex]).isEnabled();
                break;
            }
            case 6: {
                result = ((JTextArea)this.m_components[fieldIndex]).isEditable();
                break;
            }
            case 8: {
                result = ((JEditorPane)this.m_components[fieldIndex]).isEditable();
                break;
            }
            case 9: {
                LOG.severe("ERROR - isFieldEditable() called for field type hidden");
                break;
            }
            case 10: {
                LOG.severe("ERROR - isFieldEditable() called for field type ignored");
                break;
            }
            default: {
                LOG.severe("ERROR - isFieldEditable() unknown field type");
            }
        }
        return result;
    }

    public void setFieldEditable(int fieldIndex, boolean editable) {
        switch (this.fields[fieldIndex].getType()) {
            case 0: {
                ((CustomField)((Object)this.m_components[fieldIndex])).setFieldEditable(editable);
                break;
            }
            case 1: {
                ((JTextField)this.m_components[fieldIndex]).setEditable(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 7: {
                ((JLabel)this.m_components[fieldIndex]).setEnabled(editable);
                this.m_components[fieldIndex].setFocusable(false);
                break;
            }
            case 2: {
                ((JComboBox)this.m_components[fieldIndex]).setEnabled(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 3: {
                ((JToggleButton)this.m_components[fieldIndex]).setEnabled(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 4: {
                ((JPasswordField)this.m_components[fieldIndex]).setEditable(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 5: {
                ((RadioBoxPanel)this.m_components[fieldIndex]).setEnabled(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 6: {
                ((JTextArea)this.m_components[fieldIndex]).setEditable(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 8: {
                ((JEditorPane)this.m_components[fieldIndex]).setEditable(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 9: {
                LOG.severe("ERROR - setFieldEditable() called for field type hidden");
                break;
            }
            case 10: {
                LOG.severe("ERROR - setFieldEditable() called for field type ignored");
                break;
            }
            default: {
                LOG.severe("ERROR - setFieldEditable() unknown field type");
            }
        }
        if (this.m_labels[fieldIndex] != null) {
            this.m_labels[fieldIndex].setForeground(editable ? LABEL_COLOR : Color.GRAY);
        }
    }

    public String getFieldValue(int fieldIndex) {
        String returnStr;
        switch (this.fields[fieldIndex].getType()) {
            case 0: {
                returnStr = ((CustomField)((Object)this.m_components[fieldIndex])).getValue();
                break;
            }
            case 1: {
                returnStr = ((JTextField)this.m_components[fieldIndex]).getText();
                break;
            }
            case 7: {
                returnStr = ((JLabel)this.m_components[fieldIndex]).getText();
                break;
            }
            case 2: {
                returnStr = (String)((JComboBox)this.m_components[fieldIndex]).getSelectedItem();
                break;
            }
            case 3: {
                if (((JToggleButton)this.m_components[fieldIndex]).isSelected()) {
                    returnStr = TRUE_STR;
                    break;
                }
                returnStr = FALSE_STR;
                break;
            }
            case 4: {
                returnStr = new String(((JPasswordField)this.m_components[fieldIndex]).getPassword());
                break;
            }
            case 5: {
                returnStr = ((RadioBoxPanel)this.m_components[fieldIndex]).getSelectedItem();
                break;
            }
            case 6: {
                returnStr = ((JTextArea)this.m_components[fieldIndex]).getText();
                break;
            }
            case 8: {
                returnStr = ((JEditorPane)this.m_components[fieldIndex]).getText();
                break;
            }
            case 9: {
                LOG.severe("ERROR - getFieldValue() called for field type hidden");
                returnStr = null;
                break;
            }
            case 10: {
                LOG.severe("ERROR - getFieldValue() called for field type ignored");
                returnStr = null;
                break;
            }
            default: {
                LOG.severe("ERROR - getFieldValue() unknown field type");
                returnStr = null;
            }
        }
        return returnStr;
    }

    public void setFieldValue(int fieldIndex, String valueStr) {
        switch (this.fields[fieldIndex].getType()) {
            case 0: {
                ((CustomField)((Object)this.m_components[fieldIndex])).setValue(valueStr);
                break;
            }
            case 1: {
                ((JTextField)this.m_components[fieldIndex]).setText(valueStr);
                if (valueStr == null) break;
                ((JTextField)this.m_components[fieldIndex]).setCaretPosition(valueStr.length());
                break;
            }
            case 7: {
                ((JLabel)this.m_components[fieldIndex]).setText(valueStr);
                break;
            }
            case 2: {
                if (valueStr == null) {
                    ((JComboBox)this.m_components[fieldIndex]).setSelectedIndex(0);
                    break;
                }
                ((JComboBox)this.m_components[fieldIndex]).setSelectedItem(valueStr);
                break;
            }
            case 3: {
                ((JToggleButton)this.m_components[fieldIndex]).setSelected(valueStr != null && valueStr.equals(TRUE_STR));
                break;
            }
            case 4: {
                ((JPasswordField)this.m_components[fieldIndex]).setText(valueStr);
                if (valueStr == null) break;
                ((JTextField)this.m_components[fieldIndex]).setCaretPosition(valueStr.length());
                break;
            }
            case 5: {
                ((RadioBoxPanel)this.m_components[fieldIndex]).setSelectedItem(valueStr);
                break;
            }
            case 6: {
                ((JTextArea)this.m_components[fieldIndex]).setText(valueStr);
                break;
            }
            case 8: {
                ((JEditorPane)this.m_components[fieldIndex]).setText(valueStr);
                break;
            }
            case 9: {
                LOG.severe("ERROR - setFieldValue() called for field type hidden");
                break;
            }
            case 10: {
                LOG.severe("ERROR - setFieldValue() called for field type ignored");
                break;
            }
            default: {
                LOG.severe("ERROR - setFieldValue() unknown field type");
            }
        }
    }

    public int getContinueCheckIndex() {
        for (int index = 0; index < this.fields.length; ++index) {
            if (!this.fields[index].getIsContinueCheck()) continue;
            return index;
        }
        return -1;
    }

    class ourHyperlinkListener
    implements HyperlinkListener {
        ourHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                LOG.info("hyperlink: " + event.getURL());
                if (!Web.execURL(event.getURL().toString())) {
                    JOptionPane.showMessageDialog(FormPanel.this.parentWizardPanel.getParentDialog() != null ? FormPanel.this.parentWizardPanel.getParentDialog() : null, I18N.getString("browser.error.dialog.message"), I18N.getString("browser.error.dialog.title"), 0);
                }
            }
        }
    }
}

