/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.cacao.NetworkProxyCacaoAdapter;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.swing.CursorUtils;
import com.sun.cns.basicreg.wizard.swing.FormPanel;
import com.sun.cns.basicreg.wizard.swing.WizardFrame;
import com.sun.cns.basicreg.wizard.swing.WizardPanel;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PopupDialog
extends JDialog {
    private static final String OK_BTN_LBL = I18N.getString("ok.btn");
    private static final String CLOSE_BTN_LBL = I18N.getString("close.btn");
    private static final String CANCEL_BTN_LBL = I18N.getString("cancel.btn");
    private static final String PROXY_ERROR_MESSAGE = I18N.getString("proxy.error.dialog.message");
    private static final String PROXY_ERROR_TITLE = I18N.getString("proxy.error.dialog.title");
    private static final String CACAO_LOAD_PROXY_ERROR_TITLE = I18N.getString("cacao.load.proxy.error.title");
    private static final String CACAO_LOAD_PROXY_ERROR_MESSAGE = I18N.getString("cacao.load.proxy.error.message");
    private static final String CACAO_STORE_PROXY_ERROR_TITLE = I18N.getString("cacao.store.proxy.error.title");
    private static final String CACAO_STORE_PROXY_ERROR_MESSAGE = I18N.getString("cacao.store.proxy.error.message");
    private static final int INITIAL_ASSET_INFO_POPUP_HEIGHT = 600;
    private static final int INITIAL_ASSET_INFO_POPUP_WIDTH = 600;
    private Dialog parentDialog;
    private WizardFrame ownerWizardFrame;
    private WizardPanel wizardPanel;
    private Form form;
    private static final Logger LOG = Logger.getLogger(PopupDialog.class.getName());

    public PopupDialog(Dialog parentDialog, WizardFrame ownerWizardFrame, Wizard wizard, Form form, int formIndex) {
        super(parentDialog, wizard.getTitle(), form.isModal());
        this.parentDialog = parentDialog;
        this.ownerWizardFrame = ownerWizardFrame;
        this.form = form;
        this.getAccessibleContext().setAccessibleName(form.getTitle());
        this.getAccessibleContext().setAccessibleDescription(form.getTitle());
        this.buildMe(wizard, formIndex);
        if (this.isProxyPopup()) {
            this.addComponentListener(new ProxyPopupComponentListener());
        }
        if (this.isAssetInfoPopup()) {
            this.addComponentListener(new AssetInfoPopupComponentListener());
        }
        this.addComponentListener(new PopupDialogComponentListener());
    }

    public boolean isNetworkErrorPopup() {
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier == null) {
            return false;
        }
        return formIdentifier.equals("network");
    }

    public boolean isProxyPopup() {
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier == null) {
            return false;
        }
        return formIdentifier.equals("proxy");
    }

    public boolean isAssetInfoPopup() {
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier == null) {
            return false;
        }
        return formIdentifier.equals("assetinfo") || formIdentifier.equals("limitedassetinfo") || formIdentifier.equals("assetinfosubscription") || formIdentifier.equals("assetinfoenablePortal");
    }

    private void buildMe(Wizard wizard, int formIndex) {
        JPanel leftPanel = new JPanel();
        leftPanel.add(new JLabel("        "));
        this.getContentPane().add((Component)leftPanel, "West");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        this.wizardPanel = new WizardPanel(this, wizard, this.form, formIndex, this.ownerWizardFrame.getWizardDialog());
        centerPanel.add((Component)this.wizardPanel, "Center");
        centerPanel.add((Component)this.buildButtonPanel(), "South");
        this.getContentPane().add((Component)centerPanel, "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.add(new JLabel("        "));
        this.getContentPane().add((Component)rightPanel, "East");
        this.pack();
        Dimension sizeDimension = this.getSize();
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier.equalsIgnoreCase("assetinfo") || formIdentifier.equalsIgnoreCase("limitedassetinfo") || formIdentifier.equalsIgnoreCase("assetinfosubscription") || formIdentifier.equalsIgnoreCase("assetinfoenablePortal")) {
            this.setSize(600, 600);
        } else if (formIdentifier.equalsIgnoreCase("network")) {
            this.setSize(500, 400);
        } else if (formIdentifier.equalsIgnoreCase("autoreg")) {
            this.setSize(500, 400);
        } else if (formIdentifier.equalsIgnoreCase("proxy")) {
            this.setSize(600, 500);
        }
        this.setLocation(new Point(300, 300));
    }

    private JPanel buildButtonPanel() {
        JPanel returnPanel = new JPanel();
        returnPanel.setLayout(new BoxLayout(returnPanel, 1));
        returnPanel.add(Box.createVerticalStrut(12));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier.equalsIgnoreCase("assetinfo") || formIdentifier.equalsIgnoreCase("assetinfosubscription") || formIdentifier.equalsIgnoreCase("assetinfoenablePortal") || formIdentifier.equalsIgnoreCase("limitedassetinfo") || formIdentifier.equalsIgnoreCase("autoreg")) {
            JButton closeButton = new JButton(CLOSE_BTN_LBL);
            closeButton.addActionListener(new CancelButtonActionListener());
            closeButton.setAlignmentY(0.0f);
            closeButton.getAccessibleContext().setAccessibleName(CLOSE_BTN_LBL);
            closeButton.getAccessibleContext().setAccessibleDescription(CLOSE_BTN_LBL);
            if (I18N.isLocalLanguageEnglish()) {
                closeButton.setMnemonic(67);
            }
            buttonPanel.add(closeButton);
        } else if (formIdentifier.equalsIgnoreCase("proxy")) {
            JButton okButton = new JButton(OK_BTN_LBL);
            okButton.addActionListener(new ProxyOkButtonActionListener());
            okButton.setAlignmentY(0.0f);
            okButton.getAccessibleContext().setAccessibleName("Apply my changes");
            okButton.getAccessibleContext().setAccessibleDescription(OK_BTN_LBL);
            if (I18N.isLocalLanguageEnglish()) {
                okButton.setMnemonic(75);
            }
            buttonPanel.add(okButton);
            buttonPanel.add(Box.createHorizontalStrut(12));
            JButton cancelButton = new JButton(CANCEL_BTN_LBL);
            cancelButton.addActionListener(new ProxyCancelButtonActionListener());
            cancelButton.setAlignmentY(0.0f);
            cancelButton.getAccessibleContext().setAccessibleName(CANCEL_BTN_LBL);
            cancelButton.getAccessibleContext().setAccessibleDescription(CANCEL_BTN_LBL);
            if (I18N.isLocalLanguageEnglish()) {
                cancelButton.setMnemonic(67);
            }
            buttonPanel.add(cancelButton);
        } else if (formIdentifier.equalsIgnoreCase("network")) {
            JButton cancelButton = new JButton(CANCEL_BTN_LBL);
            cancelButton.addActionListener(new CancelButtonActionListener());
            cancelButton.setAlignmentY(0.0f);
            cancelButton.getAccessibleContext().setAccessibleName(CANCEL_BTN_LBL);
            cancelButton.getAccessibleContext().setAccessibleDescription(CANCEL_BTN_LBL);
            if (I18N.isLocalLanguageEnglish()) {
                cancelButton.setMnemonic(67);
            }
            buttonPanel.add(cancelButton);
        }
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.setAlignmentX(0.0f);
        returnPanel.add(buttonPanel);
        returnPanel.add(Box.createVerticalStrut(12));
        return returnPanel;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() != 201 || this.isProxyPopup()) {
            // empty if block
        }
        super.processWindowEvent(windowEvent);
    }

    private boolean loadCacaoValues() {
        LOG.info("Load proxy values from the cacao netork proxy mbean");
        FormPanel formPanel = this.wizardPanel.getFormPanel();
        try {
            if (NetworkProxyCacaoAdapter.isProxyEnabled()) {
                formPanel.setFieldValue("enable", "true");
                formPanel.setFieldValue("server", NetworkProxyCacaoAdapter.getProxyHost());
                formPanel.setFieldValue("port", NetworkProxyCacaoAdapter.getProxyPort());
                if (NetworkProxyCacaoAdapter.isProxyAuthEnabled()) {
                    formPanel.setFieldValue("proxyAuth", "true");
                    formPanel.setFieldValue("proxyUser", NetworkProxyCacaoAdapter.getProxyAuthUser());
                    formPanel.setFieldValue("proxyPass", NetworkProxyCacaoAdapter.getProxyAuthPass());
                } else {
                    formPanel.setFieldValue("proxyAuth", "false");
                    formPanel.setFieldValue("proxyUser", null);
                    formPanel.setFieldValue("proxyPass", null);
                }
            } else {
                formPanel.setFieldValue("enable", "false");
                formPanel.setFieldValue("server", null);
                formPanel.setFieldValue("port", null);
                formPanel.setFieldValue("proxyAuth", "false");
                formPanel.setFieldValue("proxyUser", null);
                formPanel.setFieldValue("proxyPass", null);
            }
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error obtaining Cacao network proxy information");
            LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
            return false;
        }
        return true;
    }

    private boolean storeCacaoValues() {
        LOG.info("Store proxy values into the cacao netork proxy mbean");
        FormPanel formPanel = this.wizardPanel.getFormPanel();
        String proxyEnabled = formPanel.getFieldValue("enable");
        boolean isProxyEnabled = proxyEnabled != null && proxyEnabled.equals("true");
        String authEnabled = formPanel.getFieldValue("proxyAuth");
        boolean isAuthEnabled = authEnabled != null && authEnabled.equals("true");
        try {
            if (isProxyEnabled) {
                if (isAuthEnabled) {
                    NetworkProxyCacaoAdapter.setProxy((boolean)true, (String)formPanel.getFieldValue("server"), (String)formPanel.getFieldValue("port"), (boolean)true, (String)formPanel.getFieldValue("proxyUser"), (String)formPanel.getFieldValue("proxyPass"));
                } else {
                    NetworkProxyCacaoAdapter.setProxy((boolean)true, (String)formPanel.getFieldValue("server"), (String)formPanel.getFieldValue("port"), (boolean)false, null, null);
                }
            } else {
                NetworkProxyCacaoAdapter.setProxy((boolean)false, null, null, (boolean)false, null, null);
            }
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error obtaining Cacao network proxy information");
            LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
            return false;
        }
        return true;
    }

    public WizardPanel getWizardPanel() {
        return this.wizardPanel;
    }

    class PopupDialogComponentListener
    extends ComponentAdapter {
        PopupDialogComponentListener() {
        }

        public void componentMoved(ComponentEvent ce) {
            if (PopupDialog.this.parentDialog != null) {
                PopupDialog.this.parentDialog.validate();
                PopupDialog.this.parentDialog.repaint();
            }
        }
    }

    class ProxyOkButtonActionListener
    implements ActionListener {
        ProxyOkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean isProxyOk;
            LOG.info("  ++++  POPUP PROXY OK BUTTON");
            boolean validResponses = PopupDialog.this.wizardPanel.validateResponses();
            FormPanel formPanel = PopupDialog.this.wizardPanel.getFormPanel();
            formPanel.layoutLabelsAndComponents();
            if (!validResponses) {
                PopupDialog.this.wizardPanel.refreshMe();
                return;
            }
            CursorUtils.setComponentBusyCursor(PopupDialog.this);
            String proxyEnableValue = formPanel.getFieldValue("enable");
            String proxyAuthValue = formPanel.getFieldValue("proxyAuth");
            boolean isProxyEnabled = proxyEnableValue != null && proxyEnableValue.equals("true");
            boolean isAuthEnabled = proxyAuthValue != null && proxyAuthValue.equals("true");
            try {
                isProxyOk = isProxyEnabled ? (isAuthEnabled ? NetworkProxyCacaoAdapter.isProxyValid((String)formPanel.getFieldValue("server"), (String)formPanel.getFieldValue("port"), (String)formPanel.getFieldValue("proxyUser"), (String)formPanel.getFieldValue("proxyPass")) : NetworkProxyCacaoAdapter.isProxyValid((String)formPanel.getFieldValue("server"), (String)formPanel.getFieldValue("port"), (String)"", (String)"")) : true;
            }
            catch (CacaoAdapterException caEx) {
                LOG.severe("Error validating Cacao network proxy information");
                LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                isProxyOk = false;
            }
            if (isProxyOk) {
                PopupDialog.this.wizardPanel.setResponses();
                String outCall = PopupDialog.this.form.getOutCall();
                if (outCall == null || !outCall.equals("cacaoProxy")) {
                    CursorUtils.setComponentDefaultCursor(PopupDialog.this);
                    PopupDialog.this.setVisible(false);
                    PopupDialog.this.ownerWizardFrame.refreshWizardDialog();
                    return;
                }
                boolean storeCacaoOk = PopupDialog.this.storeCacaoValues();
                if (!storeCacaoOk) {
                    CursorUtils.setComponentDefaultCursor(PopupDialog.this);
                    JOptionPane.showMessageDialog(PopupDialog.this, CACAO_STORE_PROXY_ERROR_MESSAGE, CACAO_STORE_PROXY_ERROR_TITLE, 2);
                    PopupDialog.this.wizardPanel.refreshMe();
                } else {
                    CursorUtils.setComponentDefaultCursor(PopupDialog.this);
                    PopupDialog.this.setVisible(false);
                    PopupDialog.this.ownerWizardFrame.refreshWizardDialog();
                }
                return;
            }
            CursorUtils.setComponentDefaultCursor(PopupDialog.this);
            LOG.info(" PROXY CONNECTION FAILED");
            JOptionPane.showMessageDialog(PopupDialog.this, PROXY_ERROR_MESSAGE, PROXY_ERROR_TITLE, 0);
            PopupDialog.this.wizardPanel.refreshMe();
        }
    }

    class ProxyCancelButtonActionListener
    implements ActionListener {
        ProxyCancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("  ++++  PROXY POPUP CANCEL BUTTON");
            PopupDialog.this.setVisible(false);
            PopupDialog.this.ownerWizardFrame.refreshWizardDialog();
        }
    }

    class AssetInfoPopupComponentListener
    extends ComponentAdapter {
        AssetInfoPopupComponentListener() {
        }

        public void componentShown(ComponentEvent ce) {
            Dimension sizeDimension = PopupDialog.this.getSize();
            LOG.info("ASSET INFO show size: " + sizeDimension.getWidth() + ", " + sizeDimension.getHeight());
            int currentHeight = (int)sizeDimension.getHeight();
            if (Math.abs(currentHeight - 600) < 2) {
                LOG.info("INCREASING THE HEIGHT");
                PopupDialog.this.setSize((int)sizeDimension.getWidth(), (int)sizeDimension.getHeight() + 50);
                PopupDialog.this.validate();
                PopupDialog.this.repaint();
            }
        }
    }

    class ProxyPopupComponentListener
    extends ComponentAdapter {
        ProxyPopupComponentListener() {
        }

        public void componentShown(ComponentEvent ce) {
            String outCall = PopupDialog.this.form.getOutCall();
            if (outCall == null || !outCall.equals("cacaoProxy")) {
                return;
            }
            if (!PopupDialog.this.loadCacaoValues()) {
                JOptionPane.showMessageDialog(PopupDialog.this, CACAO_LOAD_PROXY_ERROR_MESSAGE, CACAO_LOAD_PROXY_ERROR_TITLE, 2);
            }
        }
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("  ++++  POPUP CANCEL BUTTON");
            PopupDialog.this.setVisible(false);
            PopupDialog.this.ownerWizardFrame.refreshWizardDialog();
        }
    }
}

