/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.wizard.swing.SwingWorker;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

class ProgressPanel
extends JPanel
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(ProgressPanel.class.getName());
    private JDialog parentDialog;
    private JLabel headerLabel;
    private String headerLabelText;
    private JProgressBar progressBar;
    private JLabel footerLabel;
    private String footerLabelText;
    private JButton cancelButton;
    private Timer timer;
    private int iStep = 0;
    private SwingWorker worker;
    private static final String DEFAULT_HEADER_LABEL_TEXT = I18N.getString("default.progress.header");
    private static final String DEFAULT_FOOTER_LABEL_TEXT = I18N.getString("default.progress.footer");
    private static final int TIMER_MILLISECONDS = 1000;

    public ProgressPanel(JDialog parentDialog, SwingWorker worker) {
        this(parentDialog, worker, DEFAULT_HEADER_LABEL_TEXT, DEFAULT_FOOTER_LABEL_TEXT, true);
    }

    public ProgressPanel(JDialog parentDialog, SwingWorker worker, String headerLabelText, String footerLabelText, boolean isCancellable) {
        this.parentDialog = parentDialog;
        this.headerLabelText = headerLabelText;
        this.footerLabelText = footerLabelText;
        this.worker = worker;
        this.timer = new Timer(1000, this);
        this.createComponents();
        this.createLayout(isCancellable);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private void createComponents() {
        this.headerLabel = new JLabel(this.headerLabelText);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.getAccessibleContext().setAccessibleName("Progress Bar");
        this.progressBar.getAccessibleContext().setAccessibleDescription("Progress Bar");
        this.footerLabel = new JLabel(this.footerLabelText);
        this.cancelButton = new JButton(I18N.getString("cancel.btn"));
        this.cancelButton.addActionListener(new CancelButtonActionListener());
        this.headerLabel.getAccessibleContext().setAccessibleName(this.headerLabelText);
        this.headerLabel.getAccessibleContext().setAccessibleDescription(this.headerLabelText);
        this.footerLabel.getAccessibleContext().setAccessibleName(this.footerLabelText);
        this.footerLabel.getAccessibleContext().setAccessibleDescription(this.footerLabelText);
        this.cancelButton.getAccessibleContext().setAccessibleName(I18N.getString("cancel.btn"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(I18N.getString("cancel.btn"));
        if (I18N.isLocalLanguageEnglish()) {
            this.cancelButton.setMnemonic(67);
        }
    }

    private void createLayout(boolean isCancellable) {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(Box.createRigidArea(new Dimension(5, 20)));
        this.headerLabel.setHorizontalAlignment(2);
        this.headerLabel.setAlignmentX(0.0f);
        centerPanel.add(this.headerLabel);
        centerPanel.add(Box.createRigidArea(new Dimension(5, 10)));
        this.progressBar.setAlignmentX(0.0f);
        centerPanel.add(this.progressBar);
        centerPanel.add(Box.createRigidArea(new Dimension(5, 20)));
        JPanel footerPanel = new JPanel();
        footerPanel.setLayout(new BoxLayout(footerPanel, 0));
        footerPanel.add(this.footerLabel);
        if (isCancellable) {
            footerPanel.add(Box.createHorizontalGlue());
            footerPanel.add(this.cancelButton);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)centerPanel, "Center");
        this.add((Component)footerPanel, "South");
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public AbstractButton getCancelButton() {
        return this.cancelButton;
    }

    public void setHeaderLabel(String text) {
        this.headerLabel.setText(text);
    }

    public void setFooterLabel(String text) {
        this.footerLabel.setText(text);
    }

    public void setProgressing(boolean isProgressing) {
        LOG.info("START PROGRESSING: " + isProgressing);
        if (this.worker == null) {
            return;
        }
        if (isProgressing) {
            this.iStep = 0;
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            LOG.finest("Timer Event");
            LOG.info("TIMER event");
            if (this.worker != null && this.worker.isDone()) {
                this.setProgressing(false);
                if (this.parentDialog != null) {
                    this.parentDialog.setVisible(false);
                    this.parentDialog.dispose();
                }
            }
        }
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }
}

