/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.cacao.ClientLoginCacaoAdapter;
import com.sun.cns.basicreg.cacao.OfferingCacaoAdapter;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.RegistrationListener;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.cli.CmdLineWizard;
import com.sun.cns.basicreg.wizard.swing.PopupDialog;
import com.sun.cns.basicreg.wizard.swing.WizardDialog;
import com.sun.cns.basicreg.wizard.swing.WizardPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdom.Document;

public class WizardFrame
extends JFrame {
    private RegistrationListener registrationListener = null;
    private int runMode;
    private Wizard wizard;
    private WizardDialog wizardDialog;
    private ArrayList theDialogs;
    private ArrayList wizardPanels;
    private static WizardFrame wizardFrame;
    private Frame parentFrameForWizardDialog;
    private boolean isWizardDialogModal;
    private static final Logger LOG;

    private WizardFrame(Frame parentFrameForWizardDialog, Boolean isWizardDialogModal, Wizard wizard, RegistrationListener registrationListener, Integer runMode) {
        this.parentFrameForWizardDialog = parentFrameForWizardDialog;
        this.isWizardDialogModal = isWizardDialogModal;
        this.registrationListener = registrationListener;
        this.runMode = runMode;
        this.buildMe(wizard);
    }

    private void buildMe(Wizard wizard) {
        this.wizard = wizard;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        this.setJMenuBar(this.createMenuBar());
        this.pack();
        try {
            OfferingCacaoAdapter.myActivate((String)"Register the Solaris software without choosing an update option", null);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error - prom activation exception");
            LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
        }
        this.wizardDialog = new WizardDialog(this.parentFrameForWizardDialog, this.isWizardDialogModal, this, wizard);
        this.theDialogs = new ArrayList();
        this.wizardPanels = new ArrayList();
        int formIndex = 0;
        while (!wizard.isLastForm()) {
            Form form = wizard.getNextForm();
            if (form.isPopup()) {
                this.theDialogs.add(new PopupDialog(this.wizardDialog, this, wizard, form, formIndex));
                this.wizardPanels.add(new WizardPanel());
            } else {
                this.theDialogs.add(this.wizardDialog);
                this.wizardPanels.add(new WizardPanel(this.wizardDialog, wizard, form, formIndex, this.wizardDialog));
            }
            ++formIndex;
        }
        LOG.info("NUMBER OF FORMS: " + formIndex);
        this.wizardDialog.buildMe(this.wizardPanels.toArray(new WizardPanel[0]));
        try {
            OfferingCacaoAdapter.myDeactivate((String)"Register the Solaris software without choosing an update option");
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error - prom deactivation exception");
            LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
        }
    }

    public int getRunMode() {
        return this.runMode;
    }

    public boolean isRunModeSolarisRegistration() {
        return this.runMode == 3 || this.runMode == 4;
    }

    public WizardDialog getWizardDialog() {
        return this.wizardDialog;
    }

    public void showIndexedWizardDialog(int index) {
        if (this.hasIndexedWizardDialog(index)) {
            JDialog dialog = (JDialog)this.theDialogs.get(index);
            boolean formReload = this.wizard.reloadFormIfNeeded(index);
            if (this.theDialogs.get(index) instanceof WizardDialog) {
                WizardPanel wizardPanel;
                if (formReload) {
                    ((WizardPanel)this.wizardPanels.get(index)).reloadWidgets();
                }
                if ((wizardPanel = (WizardPanel)this.wizardPanels.get(index)).getForm().getIsLayoutDynamic()) {
                    CommonUtil.debug();
                    ((WizardPanel)this.wizardPanels.get(index)).resolveDisplayVariables();
                    LOG.info("Dynamic Layout: " + wizardPanel.getForm().getTitle());
                    wizardPanel.getFormPanel().layoutLabelsAndComponents();
                }
                this.wizardDialog.showPanel(index);
            } else if (this.theDialogs.get(index) instanceof PopupDialog) {
                WizardPanel wizardPanel;
                PopupDialog popupDialog = (PopupDialog)this.theDialogs.get(index);
                if (formReload) {
                    popupDialog.getWizardPanel().reloadWidgets();
                }
                if ((wizardPanel = popupDialog.getWizardPanel()).getForm().getIsLayoutDynamic()) {
                    LOG.info("Dynamic Layout: " + wizardPanel.getForm().getTitle());
                    wizardPanel.getFormPanel().layoutLabelsAndComponents();
                }
                popupDialog.setVisible(true);
                popupDialog.getWizardPanel().setInitialFocus();
            } else {
                LOG.severe("ERROR - wizard dialog class unknown");
            }
        } else {
            LOG.severe("ERROR - invalid index: " + index);
        }
    }

    public void refreshWizardDialog() {
        this.wizardDialog.refreshMe();
    }

    private void showInitialDialog() {
        this.wizardDialog.showPanel(0);
        this.wizardDialog.setVisible(true);
    }

    private boolean hasIndexedWizardDialog(int index) {
        return index >= 0 && index < this.theDialogs.size();
    }

    private ArrayList getTheDialogs() {
        return this.theDialogs;
    }

    private void dialogsUpdateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this.wizardDialog);
        for (int i = 0; i < this.theDialogs.size(); ++i) {
            if (this.theDialogs.get(i) instanceof WizardDialog) continue;
            SwingUtilities.updateComponentTreeUI((JDialog)this.theDialogs.get(i));
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem menuItem = new JMenuItem("Exit");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                System.exit(0);
            }
        });
        fileMenu.add(menuItem);
        menuBar.add(fileMenu);
        JMenu optionsMenu = new JMenu("Options");
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        ButtonGroup lafGroup = new ButtonGroup();
        for (int i = 0; i < lafs.length; ++i) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(lafs[i].getName());
            optionsMenu.add(rb);
            rb.setSelected(UIManager.getLookAndFeel().getName().equals(lafs[i].getName()));
            rb.putClientProperty("UIKey", lafs[i]);
            rb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ae) {
                    JRadioButtonMenuItem rb2 = (JRadioButtonMenuItem)ae.getSource();
                    if (rb2.isSelected()) {
                        UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)rb2.getClientProperty("UIKey");
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                            SwingUtilities.updateComponentTreeUI(WizardFrame.this);
                            WizardFrame.this.dialogsUpdateComponentTreeUI();
                        }
                        catch (Exception e) {
                            LOG.severe("ERROR - unable to set UI " + e.getMessage());
                        }
                    }
                }
            });
            lafGroup.add(rb);
        }
        menuBar.add(optionsMenu);
        return menuBar;
    }

    public static void create(Frame parentFrameForWizardDialog, Boolean isWizardDialogModal, Wizard wizard, RegistrationListener registrationListener, Integer runMode) {
        wizardFrame = new WizardFrame(parentFrameForWizardDialog, isWizardDialogModal, wizard, registrationListener, runMode);
    }

    public static void run() {
        if (wizardFrame.getTheDialogs() == null || wizardFrame.getTheDialogs().size() < 1) {
            LOG.severe("ERROR - No form dialog(s)");
            return;
        }
        wizardFrame.showInitialDialog();
        LOG.info("  ****  run DONE");
    }

    public void wizardCompleted() {
        try {
            OfferingCacaoAdapter.myDeactivate();
            ClientLoginCacaoAdapter.logout();
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error - SCN session logout exception");
            LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
        }
        if (this.wizardDialog != null) {
            this.wizardDialog.dispose();
        }
        for (int i = 0; i < this.theDialogs.size(); ++i) {
            if (this.theDialogs.get(i) == null || !(this.theDialogs.get(i) instanceof PopupDialog)) continue;
            ((PopupDialog)this.theDialogs.get(i)).dispose();
        }
        this.dispose();
        this.wizard.closeCSMAuthFrame();
        Document resultDocument = null;
        try {
            resultDocument = this.wizard.getDocument();
        }
        catch (Exception e) {
            LOG.severe("ERROR - failed to obtain result document");
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        LOG.info("  ----  wizardCompleted document non-null ? " + (resultDocument != null ? "yes" : "no"));
        if (this.registrationListener != null) {
            this.registrationListener.registrationCompleted(resultDocument);
        }
        if (this.isRunModeSolarisRegistration()) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        WizardFrame.create(null, new Boolean(true), new CmdLineWizard("wizards/profile.xml", "profile"), null, new Integer(0));
        WizardFrame.run();
    }

    static {
        LOG = Logger.getLogger(WizardFrame.class.getName());
    }
}

