/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.util;

import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.wizard.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class I18N {
    public static final String COMPLETE_ASSET_INFO = "F";
    public static final String LIMITED_ASSET_INFO = "P";
    public static final String SOLARIS_ASSET_INFO = "S";
    private static final String BASE_DIR = "i18n/";
    private static final String BASE_NAME = "i18n/wizardStrings";
    private static final String XML_BASE_NAME = "i18n/xmlValueStrings";
    private static final String ASSET_BASE_NAME = "i18n/assetStrings";
    private static final String COUNTRY_BASE_NAME = "i18n/countryStrings";
    private static final String LANGUAGE_BASE_NAME = "i18n/languageStrings";
    private static final String UNKNOWN_DEFAULT = "?unknown";
    private static final String EMPTY_DEFAULT = "";
    private static Locale locale;
    private static ResourceBundle resourceBundle;
    private static ResourceBundle xmlResourceBundle;
    private static ResourceBundle assetResourceBundle;
    private static ResourceBundle countryResourceBundle;
    private static ResourceBundle languageResourceBundle;
    private static Logger LOG;
    private static String i18nCompleteAssetInfoHtml;
    private static String i18nLimitedAssetInfoHtml;
    private static String i18nSolarisAssetInfoHtml;
    public static final String TOU_TEXT_FILE_NAME_KEY = "_i18n.common.license.legal.text.file.name";
    public static final String LICENSE_TEXT_FILE_NAME_KEY = "_i18n.solaris.license.sla.text.file.name";
    public static final String PRIVACY_TEXT_FILE_NAME_KEY = "_i18n.common.privacy.text.file.name";
    public static final String IS_REQUIRED_ERR_MSG;
    public static final String ACCEPT_TOU_ERR_MSG;
    public static final String ACCEPT_INFO_ERR_MSG;
    public static final String SECURITY_QUESTION_DEFAULT;
    public static final String SECURITY_QUESTION_ONE;
    public static final String SECURITY_QUESTION_TWO;
    public static final String SECURITY_QUESTION_THREE;
    public static final String SECURITY_QUESTION_PATTERN_ERROR;
    public static final String JOB_DEFAULT;
    public static final String JOB_SEPARATOR_ONE;
    public static final String JOB_SEPARATOR_TWO;
    public static final String JOB_01;
    public static final String JOB_02;
    public static final String JOB_03;
    public static final String JOB_04;
    public static final String JOB_05;
    public static final String JOB_06;
    public static final String JOB_07;
    public static final String JOB_08;
    public static final String JOB_09;
    public static final String JOB_10;
    public static final String JOB_11;
    public static final String JOB_12;
    public static final String JOB_13;
    public static final String JOB_14;
    public static final String JOB_15;
    public static final String JOB_16;
    public static final String JOB_17;
    public static final String COUNTRY_DEFAULT_NAME;
    public static final String COUNTRY_PATTERN_ERROR;
    public static final String LANGUAGE_DEFAULT_NAME;
    public static final String LANGUAGE_PATTERN_ERROR;
    public static final String COUNTRY_ORDER_I18N_KEY = "_i18n.country.order";
    public static final String LANGUAGE_ORDER_I18N_KEY = "_i18n.language.order";

    public static String getLocalLanguage() {
        return locale.getLanguage();
    }

    public static boolean isLocalLanguageEnglish() {
        return locale.getLanguage().equals(new Locale("en", EMPTY_DEFAULT, EMPTY_DEFAULT).getLanguage());
    }

    public static void setLocaleResources(Locale aLocale) {
        locale = aLocale;
        try {
            resourceBundle = ResourceBundle.getBundle(BASE_NAME, locale);
            xmlResourceBundle = ResourceBundle.getBundle(XML_BASE_NAME, locale);
            assetResourceBundle = ResourceBundle.getBundle(ASSET_BASE_NAME, locale);
            countryResourceBundle = ResourceBundle.getBundle(COUNTRY_BASE_NAME, locale);
            languageResourceBundle = ResourceBundle.getBundle(LANGUAGE_BASE_NAME, locale);
        }
        catch (Exception ex) {
            LOG.severe("ERROR - unable to get resource bundle");
        }
    }

    public static String getString(String key) {
        return I18N.getString(key, UNKNOWN_DEFAULT);
    }

    public static String getString(String key, String aDefault) {
        String i18nString = I18N.getBundleValue(resourceBundle, key);
        if (i18nString == null) {
            LOG.severe("ERROR - missing I18N key: " + key);
            return aDefault;
        }
        return i18nString;
    }

    public static String getFormattedString(String key, Object[] arguments) {
        String i18nString = I18N.getBundleValue(resourceBundle, key);
        if (i18nString == null) {
            LOG.severe("ERROR - missing I18N key: " + key);
            return UNKNOWN_DEFAULT;
        }
        return MessageFormat.format(i18nString, arguments);
    }

    public static Icon getIcon(String iconFileNameKey) {
        String i18nFileName = I18N.getString(iconFileNameKey, null);
        if (i18nFileName == null) {
            LOG.severe("ERROR - missing I18N file name key: " + iconFileNameKey);
            return null;
        }
        String i18nDescription = I18N.getString(iconFileNameKey + ".txt", EMPTY_DEFAULT);
        return I18N.getIcon(i18nFileName, i18nDescription);
    }

    public static Icon getIcon(String i18nFileName, String i18nDescription) {
        URL i18nImageURL = I18N.class.getResource(i18nFileName);
        if (i18nImageURL == null) {
            LOG.severe("ERROR - missing I18N gif file: " + i18nFileName);
            return null;
        }
        return new ImageIcon(i18nImageURL, i18nDescription);
    }

    public static String getXMLValueString(String key) {
        String i18nXMLValueString = null;
        if (key.equals(TOU_TEXT_FILE_NAME_KEY) || key.equals(LICENSE_TEXT_FILE_NAME_KEY) || key.equals(PRIVACY_TEXT_FILE_NAME_KEY)) {
            String i18nFileName = I18N.getBundleValue(xmlResourceBundle, key);
            try {
                return Util.readEncodedResourceFile(i18nFileName, "UTF-8");
            }
            catch (FileNotFoundException ex) {
                LOG.severe("TOU file not found: " + i18nFileName);
                return EMPTY_DEFAULT;
            }
            catch (IOException ex) {
                LOG.severe("error reading TOU file: " + i18nFileName);
                return EMPTY_DEFAULT;
            }
            catch (Exception ex) {
                LOG.severe("unknown error accessing/reading TOU file: " + i18nFileName);
                return EMPTY_DEFAULT;
            }
        }
        i18nXMLValueString = I18N.getBundleValue(xmlResourceBundle, key);
        if (i18nXMLValueString == null) {
            LOG.severe("ERROR - missing I18N xml value key: " + key);
            return EMPTY_DEFAULT;
        }
        return i18nXMLValueString;
    }

    public static String getAssetValueString(String key) {
        String i18nAssetValueString = I18N.getBundleValue(assetResourceBundle, key);
        if (i18nAssetValueString == null) {
            LOG.severe("ERROR - missing I18N asset value key: " + key);
            return EMPTY_DEFAULT;
        }
        return i18nAssetValueString;
    }

    public static String getCountryValueString(String key, String defaultValue) {
        String i18nCountryValueString = I18N.getBundleValue(countryResourceBundle, key);
        if (i18nCountryValueString == null) {
            LOG.severe(" - missing I18N country value key: " + key);
            return defaultValue;
        }
        return i18nCountryValueString;
    }

    public static String getLanguageValueString(String key, String defaultValue) {
        String i18nLanguageValueString = I18N.getBundleValue(languageResourceBundle, key);
        if (i18nLanguageValueString == null) {
            LOG.severe("ERROR - missing I18N language value key: " + key);
            return defaultValue;
        }
        return i18nLanguageValueString;
    }

    public static String getI18NAssetInfoHTML(String htmlText, String assetInfo) {
        String[] assetLabels;
        LOG.info("assetInfo: " + assetInfo);
        if (assetInfo.equals(LIMITED_ASSET_INFO) && i18nLimitedAssetInfoHtml != null) {
            LOG.info("Returning cached limited asset info i18n html");
            return i18nLimitedAssetInfoHtml;
        }
        if (assetInfo.equals(COMPLETE_ASSET_INFO) && i18nCompleteAssetInfoHtml != null) {
            LOG.info("Returning cached complete asset info i18n html");
            return i18nCompleteAssetInfoHtml;
        }
        if (assetInfo.equals(SOLARIS_ASSET_INFO) && i18nSolarisAssetInfoHtml != null) {
            LOG.info("Returning cached solaris asset info i18n html");
            return i18nSolarisAssetInfoHtml;
        }
        LOG.finest("HTML TEXT: " + htmlText);
        String i18nString = new String(htmlText);
        if (assetInfo.equals(LIMITED_ASSET_INFO)) {
            assetLabels = CommonUtil.LIMITED_LBLS;
        } else if (assetInfo.equals(COMPLETE_ASSET_INFO)) {
            assetLabels = CommonUtil.COMPLETE_LBLS;
        } else if (assetInfo.equals(SOLARIS_ASSET_INFO)) {
            assetLabels = CommonUtil.SOLARIS_LBLS;
        } else {
            LOG.severe("Unknown asset info requested: " + assetInfo);
            return i18nString;
        }
        for (int i = 0; i < assetLabels.length; ++i) {
            LOG.finest(" **** TO REPLACE: " + assetLabels[i]);
            String assetLblRegExpr = assetLabels[i].replaceAll("\\.", "\\\\.");
            LOG.finest(" **** REG EXPR: " + assetLblRegExpr);
            String i18nAssetLbl = I18N.getAssetValueString(assetLabels[i]);
            LOG.finest(" **** I18N VALUE: " + i18nAssetLbl);
            i18nString = i18nString.replaceAll(assetLblRegExpr, i18nAssetLbl);
        }
        if (assetInfo.equals(LIMITED_ASSET_INFO)) {
            i18nLimitedAssetInfoHtml = i18nString;
        } else if (assetInfo.equals(COMPLETE_ASSET_INFO)) {
            i18nCompleteAssetInfoHtml = i18nString;
        } else if (assetInfo.equals(SOLARIS_ASSET_INFO)) {
            i18nSolarisAssetInfoHtml = i18nString;
        }
        LOG.finest("I18N HTML: " + i18nString);
        return i18nString;
    }

    private static String getBundleValue(ResourceBundle resourceBundle, String key) {
        try {
            String value = resourceBundle.getString(key);
            return value;
        }
        catch (Exception ex) {
            LOG.severe("ERROR - missing value for key " + key);
            return null;
        }
    }

    static {
        i18nCompleteAssetInfoHtml = null;
        i18nLimitedAssetInfoHtml = null;
        i18nSolarisAssetInfoHtml = null;
        LOG = Logger.getLogger(I18N.class.getName());
        I18N.setLocaleResources(Locale.getDefault());
        IS_REQUIRED_ERR_MSG = I18N.getString("is.required.err");
        ACCEPT_TOU_ERR_MSG = I18N.getString("accept.tou.err");
        ACCEPT_INFO_ERR_MSG = I18N.getString("accept.info.err");
        SECURITY_QUESTION_DEFAULT = I18N.getXMLValueString("_i18n.createOne.security.question.default");
        SECURITY_QUESTION_ONE = I18N.getXMLValueString("_i18n.createOne.security.question.one");
        SECURITY_QUESTION_TWO = I18N.getXMLValueString("_i18n.createOne.security.question.two");
        SECURITY_QUESTION_THREE = I18N.getXMLValueString("_i18n.createOne.security.question.three");
        SECURITY_QUESTION_PATTERN_ERROR = I18N.getXMLValueString("_i18n.createOne.security.question.pattern.error");
        JOB_DEFAULT = I18N.getXMLValueString("_i18n.solaris.job.default");
        JOB_SEPARATOR_ONE = I18N.getXMLValueString("_i18n.solaris.job.separator.one");
        JOB_SEPARATOR_TWO = I18N.getXMLValueString("_i18n.solaris.job.separator.two");
        JOB_01 = I18N.getXMLValueString("_i18n.solaris.job.01");
        JOB_02 = I18N.getXMLValueString("_i18n.solaris.job.02");
        JOB_03 = I18N.getXMLValueString("_i18n.solaris.job.03");
        JOB_04 = I18N.getXMLValueString("_i18n.solaris.job.04");
        JOB_05 = I18N.getXMLValueString("_i18n.solaris.job.05");
        JOB_06 = I18N.getXMLValueString("_i18n.solaris.job.06");
        JOB_07 = I18N.getXMLValueString("_i18n.solaris.job.07");
        JOB_08 = I18N.getXMLValueString("_i18n.solaris.job.08");
        JOB_09 = I18N.getXMLValueString("_i18n.solaris.job.09");
        JOB_10 = I18N.getXMLValueString("_i18n.solaris.job.10");
        JOB_11 = I18N.getXMLValueString("_i18n.solaris.job.11");
        JOB_12 = I18N.getXMLValueString("_i18n.solaris.job.12");
        JOB_13 = I18N.getXMLValueString("_i18n.solaris.job.13");
        JOB_14 = I18N.getXMLValueString("_i18n.solaris.job.14");
        JOB_15 = I18N.getXMLValueString("_i18n.solaris.job.15");
        JOB_16 = I18N.getXMLValueString("_i18n.solaris.job.16");
        JOB_17 = I18N.getXMLValueString("_i18n.solaris.job.17");
        COUNTRY_DEFAULT_NAME = I18N.getXMLValueString("_i18n.createTwo.country.default");
        COUNTRY_PATTERN_ERROR = I18N.getXMLValueString("_i18n.createTwo.country.pattern.error");
        LANGUAGE_DEFAULT_NAME = I18N.getXMLValueString("_i18n.createTwo.language.default");
        LANGUAGE_PATTERN_ERROR = I18N.getXMLValueString("_i18n.createTwo.language.pattern.error");
    }
}

