/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.properties;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.properties.PropertiesConfigurator;
import com.sun.tools.visualvm.core.properties.PropertiesCustomizer;
import com.sun.tools.visualvm.core.properties.PropertiesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesSupport {
    private static PropertiesSupport INSTANCE;
    private final Map<PropertiesProvider, Class<? extends DataSource>> providers = Collections.synchronizedMap(new HashMap());

    public static synchronized PropertiesSupport sharedInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PropertiesSupport();
        }
        return INSTANCE;
    }

    public <X extends DataSource> void registerPropertiesProvider(PropertiesProvider<X> provider, Class<X> scope) {
        this.providers.put(provider, scope);
    }

    public <X extends DataSource> void unregisterPropertiesProvider(PropertiesProvider<X> provider) {
        this.providers.remove(provider);
    }

    public <X extends DataSource> boolean hasProperties(Class<X> type) {
        return this.hasProperties(null, type);
    }

    public <X extends DataSource> boolean hasProperties(X dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource cannot be null");
        }
        return this.hasProperties(dataSource, dataSource.getClass());
    }

    public <X extends DataSource> PropertiesCustomizer<X> getCustomizer(Class<X> type) {
        return this.getCustomizer(null, type);
    }

    public void openProperties(DataSource dataSource) {
        this.openProperties(dataSource, Integer.MIN_VALUE);
    }

    public void openProperties(DataSource dataSource, int propertiesCategory) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource cannot be null");
        }
        PropertiesConfigurator.editProperties(dataSource, propertiesCategory);
    }

    <X extends DataSource> PropertiesCustomizer<X> getCustomizer(X dataSource, Class<X> type) {
        return new PropertiesCustomizer<X>(dataSource, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <X extends DataSource> List<PropertiesProvider<X>> getProviders(X dataSource, Class<X> type) {
        HashMap<PropertiesProvider, Class<? extends DataSource>> providersCopy = new HashMap<PropertiesProvider, Class<? extends DataSource>>();
        Map<PropertiesProvider, Class<? extends DataSource>> map = this.providers;
        synchronized (map) {
            providersCopy.putAll(this.providers);
        }
        if (dataSource != null) {
            type = dataSource.getClass();
        }
        ArrayList<PropertiesProvider<X>> compatibleProviders = new ArrayList<PropertiesProvider<X>>();
        Set providersSet = providersCopy.entrySet();
        for (Map.Entry entry : providersSet) {
            PropertiesProvider provider = (PropertiesProvider)entry.getKey();
            if (!((Class)entry.getValue()).isAssignableFrom(type) || !provider.supportsDataSource(dataSource)) continue;
            compatibleProviders.add(provider);
        }
        return compatibleProviders;
    }

    private <X extends DataSource> boolean hasProperties(X dataSource, Class<X> type) {
        return !this.getProviders(dataSource, type).isEmpty();
    }

    private PropertiesSupport() {
    }
}

