/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.InteractiveDetectorPrtl;
import com.sun.patchpro.analysis.NoninteractiveException;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.util.Interaction;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.QuestionList;
import java.util.NoSuchElementException;

public class DiskArrayInteractiveDetector
extends InteractiveDetectorPrtl {
    private Host targetHost;
    private int interactionType = 1;
    private String[] choiceString = new String[]{"StorEdge T3 Storage Server", "A7000 Storage Server", "A5000 Disk Array", "A5100 Disk Array", "A5200 Disk Array", "A3500 Storage Server", "A3500FC Storage Server", "A3000 Storage Server", "A1000 Storage Server", "D1000 Storage Server", "Sparc Storage Array"};
    private Interaction[] interactionList = new Interaction[]{new QuestionList("Please select the attached storage servers and disk arrays.", this.choiceString)};
    private String[] realizationList = new String[]{"DiskArray.SunT300-1.0", "DiskArray.SunA7000-1.0", "DiskArray.SunA5000-1.0", "DiskArray.SunA5100-1.0", "DiskArray.SunA5200-1.0", "DiskArray.SunA3500-1.0", "DiskArray.SunA3500FC-1.0", "DiskArray.SunA3000-1.0", "DiskArray.SunA1000-1.0", "DiskArray.SunD1000-1.0", "DiskArray.SunSSA-1.0"};

    public DiskArrayInteractiveDetector() {
        try {
            this.initialize(this.realizationList);
            this.statusMessage = new String("Looking for disk arrays...");
            this.interactionSet = this.constructInteractionSet(this.interactionList, this.interactionType);
        }
        catch (DetectorFailedException detectorFailedException) {
            throw new Error("Detector couldn't even start.");
        }
    }

    public InteractionSet analyze(Host host) throws NoninteractiveException, DetectorFailedException {
        this.targetHost = host;
        return this.interactionSet;
    }

    public void setInteractionSet(InteractionSet interactionSet) throws DetectorFailedException {
        Object var2_2 = null;
        QuestionList questionList = null;
        this.interactionSet = interactionSet;
        boolean bl = false;
        int n = 0;
        interactionSet.reset();
        try {
            while (interactionSet.hasMoreInteractions()) {
                questionList = (QuestionList)interactionSet.nextInteraction();
                String[] stringArray = questionList.getChoices();
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    bl = questionList.getSelection(i) != 0;
                    this.targetHost.verifyRealization(new Realization(this.realizationList[i]), bl);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DetectorFailedException("Recieved empty interaction set.");
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException("Unrecognized realization: " + questionList.getMessage() + ".");
        }
    }
}

