/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.InteractiveDetectorPrtl;
import com.sun.patchpro.analysis.NoninteractiveException;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.util.Interaction;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.QuestionList;
import java.util.NoSuchElementException;

public class FirmwareInteractiveDetector
extends InteractiveDetectorPrtl {
    private Host targetHost;
    private int interactionType = 1;
    private String[] choiceString = new String[]{"DDRS34560 Disk Drive", "DDRS39130 Disk Drive", "M2949ESP Disk Drive", "M2952ESP Disk Drive", "MAA3182S Disk Drive", "MAB3045S Disk Drive", "MAB3091S Disk Drive", "ST15230N Disk Drive", "ST15230W Disk Drive", "ST19171FC Disk Drive", "ST32550W Disk Drive", "ST34371W Disk Drive", "ST39102LC Disk Drive", "ST39102FC Disk Drive", "ST39103FC Disk Drive", "ST39173W Disk Drive", "ST118273F Disk Drive", "ST136403FC Disk Drive", "ST318203FC Disk Drive", "SunFC100S Host Adapter", "SunFC100P Host Adapter"};
    private Interaction[] interactionList = new Interaction[]{new QuestionList("Please select the attached firmware.", this.choiceString)};
    private String[] realizationList = new String[]{"Firmware.DDRS34560-1.0", "Firmware.DDRS39130-1.0", "Firmware.M2949ESP-1.0", "Firmware.M2952ESP-1.0", "Firmware.MAA3182S-1.0", "Firmware.MAB3045S-1.0", "Firmware.MAB3091S-1.0", "Firmware.ST15230N-1.0", "Firmware.ST15230W-1.0", "Firmware.ST19171FC-1.0", "Firmware.ST32550W-1.0", "Firmware.ST34371W-1.0", "Firmware.ST39102LC-1.0", "Firmware.ST39102FC-1.0", "Firmware.ST39103FC-1.0", "Firmware.ST39173W-1.0", "Firmware.ST118273F-1.0", "Firmware.ST136403FC-1.0", "Firmware.ST318203FC-1.0", "Firmware.SunFC100S-1.0", "Firmware.SunFC100P-1.0"};

    public FirmwareInteractiveDetector() {
        try {
            this.initialize(this.realizationList);
            this.statusMessage = new String("Looking for firmware...");
            this.interactionSet = this.constructInteractionSet(this.interactionList, this.interactionType);
        }
        catch (DetectorFailedException detectorFailedException) {
            throw new Error("Detector couldn't even start.");
        }
    }

    public InteractionSet analyze(Host host) throws NoninteractiveException, DetectorFailedException {
        this.targetHost = host;
        return this.interactionSet;
    }

    public void setInteractionSet(InteractionSet interactionSet) throws DetectorFailedException {
        Object var2_2 = null;
        QuestionList questionList = null;
        this.interactionSet = interactionSet;
        boolean bl = false;
        interactionSet.reset();
        try {
            while (interactionSet.hasMoreInteractions()) {
                questionList = (QuestionList)interactionSet.nextInteraction();
                String[] stringArray = questionList.getChoices();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    bl = questionList.getSelection(i) != 0;
                    this.targetHost.verifyRealization(new Realization(this.realizationList[i]), bl);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DetectorFailedException("Recieved empty interaction set.");
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException("Unrecognized realization: " + questionList.getMessage() + ".");
        }
    }
}

