/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.cli.StdInListener;
import com.sun.patchpro.cli.TTY;
import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.interpreter.ParseError;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.CancelManager;
import com.sun.patchpro.model.NonFatalException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchProRuntimeException;
import com.sun.patchpro.model.PatchPropertyNotFoundException;
import com.sun.patchpro.model.PropertyInfo;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.server.DownloadEntitlementFileException;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.GetOptException;
import com.sun.patchpro.util.InstallationParameters;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import com.sun.patchpro.util.ShutDownThread;
import com.sun.patchpro.util.StringUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchServices
implements PatchProListener {
    private static final String validArgs = "D:o:c:C:z:hR:g:s:p:t:r:l@nd;i;";
    private LocalizedMessages msgcat;
    private PatchPro model;
    private ReadOnlyHost primaryHost;
    private PatchProProperties properties = PatchProProperties.getInstance();
    boolean done = false;
    boolean hostIsAnalyzed = false;
    String hostsToInstall = null;
    Throwable problem = null;
    boolean internalStatus = false;
    private int progressMin = 0;
    private int progressMax = 100;
    private static final String LIST_RESULT_FILE = "required_patches.xml";
    private static final String DOWNLOAD_RESULT_FILE = "results.xml";
    private static final String INSTALL_RESULT_FILE = "results.xml";
    private static boolean option_p_Specified = false;
    private static boolean option_o_Specified = false;
    private static String targetHostStr = null;
    private static String patchIDStr = null;
    private static String downloadDirectory = null;
    private static boolean noExit = false;
    private InstallationParameters instParms = InstallationParameters.getInstance();
    private BufferedReader stdin = null;
    private StdInListener stdinListener = null;
    public static final String SIGNING_CERT_REVOKED = "The signing certificate has been revoked. All patch download activities have been disabled. ";
    public static final String INSTANTIATION_PROBLEM = "Problem detected during PatchPro initialization process. Please check the log file. Exiting";
    private boolean debug = false;

    public PatchServices() {
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
    }

    public static void main(String[] stringArray) {
        String string = null;
        ShutDownThread shutDownThread = null;
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        GetOpt getOpt = new GetOpt(stringArray, validArgs);
        LocalizedMessages localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        PatchServices patchServices = new PatchServices();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = true;
        boolean bl17 = true;
        boolean bl18 = true;
        Vector<String> vector = null;
        try {
            shutDownThread = new ShutDownThread();
            Runtime.getRuntime().addShutdownHook(shutDownThread);
        }
        catch (Throwable throwable) {
            PatchProLog.getInstance().printStackTrace(throwable, 3, throwable);
            System.err.println(throwable.getMessage());
            PatchServices.maybeExit(1);
            return;
        }
        try {
            int n;
            block26: while ((n = getOpt.getNextOption()) != -1) {
                switch ((char)n) {
                    case 'd': {
                        if (bl4) {
                            bl = true;
                            continue block26;
                        }
                        bl4 = true;
                        continue block26;
                    }
                    case 'h': {
                        if (bl6) {
                            bl = true;
                            continue block26;
                        }
                        bl6 = true;
                        continue block26;
                    }
                    case 'i': {
                        if (bl7) {
                            bl = true;
                            continue block26;
                        }
                        bl7 = true;
                        continue block26;
                    }
                    case 'l': {
                        if (bl8) {
                            bl = true;
                            continue block26;
                        }
                        bl8 = true;
                        continue block26;
                    }
                    case 'o': {
                        if (option_o_Specified) {
                            bl = true;
                        } else {
                            targetHostStr = getOpt.getOptionArg();
                        }
                        option_o_Specified = true;
                        continue block26;
                    }
                    case 'p': {
                        if (option_p_Specified) {
                            bl = true;
                        } else {
                            patchIDStr = getOpt.getOptionArg();
                        }
                        option_p_Specified = true;
                        continue block26;
                    }
                    case 'r': {
                        if (bl10) {
                            bl = true;
                        } else {
                            string = getOpt.getOptionArg();
                        }
                        bl10 = true;
                        continue block26;
                    }
                    case 's': {
                        if (bl11) {
                            bl = true;
                        } else {
                            string4 = getOpt.getOptionArg();
                        }
                        bl11 = true;
                        continue block26;
                    }
                    case 'C': {
                        if (vector == null) {
                            vector = new Vector<String>();
                        }
                        vector.add(getOpt.getOptionArg());
                        bl3 = true;
                        continue block26;
                    }
                    case 'c': {
                        if (bl2) {
                            bl = true;
                            continue block26;
                        }
                        string2 = getOpt.getOptionArg();
                        bl2 = true;
                        continue block26;
                    }
                    case 'D': {
                        if (downloadDirectory != null) {
                            bl = true;
                            continue block26;
                        }
                        downloadDirectory = getOpt.getOptionArg();
                        continue block26;
                    }
                    case 'g': {
                        if (bl5) {
                            bl = true;
                            continue block26;
                        }
                        string6 = getOpt.getOptionArg();
                        bl5 = true;
                        continue block26;
                    }
                    case 'n': {
                        if (bl9) {
                            bl = true;
                            continue block26;
                        }
                        bl9 = true;
                        continue block26;
                    }
                    case 'R': {
                        if (bl14) {
                            bl = true;
                            continue block26;
                        }
                        string3 = getOpt.getOptionArg();
                        bl14 = true;
                        continue block26;
                    }
                    case 't': {
                        if (bl12) {
                            bl = true;
                        } else {
                            string5 = getOpt.getOptionArg();
                        }
                        bl12 = true;
                        continue block26;
                    }
                    case 'z': {
                        if (bl13) {
                            bl = true;
                            continue block26;
                        }
                        String string7 = getOpt.getOptionArg();
                        noExit = string7.equals("true");
                        bl13 = true;
                        continue block26;
                    }
                    case '@': {
                        if (bl15) {
                            bl = true;
                            continue block26;
                        }
                        bl15 = true;
                        continue block26;
                    }
                }
                System.out.println(patchServices.msgcat.getMessage("invalidOption", "Ignoring invalid option."));
            }
            if (bl) {
                System.err.println(localizedMessages.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                PatchServices.maybeExit(1);
                return;
            }
            if (bl6 || stringArray.length < 1) {
                PatchServices.usage(localizedMessages);
                System.exit(0);
            }
            if (bl8 && (bl4 || bl7) || bl4 && (bl8 || bl7) || bl7 && (bl8 || bl4) || bl5 && (bl8 || bl4 || bl7)) {
                System.err.println(localizedMessages.getMessage("pprosvcmutex", "Options l, d and i are mutually exclusive"));
                PatchServices.usage(localizedMessages);
                System.exit(1);
            }
            if (bl5) {
                patchServices.downloadDocument(string6);
            }
            if (bl14) {
                bl16 = patchServices.setRealizationsProvided(string3);
            }
            if (bl3) {
                patchServices.setProperties(vector);
            }
            if (patchProProperties.getProperty("patchpro.cancel.enable") != null && patchProProperties.getProperty("patchpro.cancel.enable").equals("true")) {
                patchServices.stdinListener = new StdInListener();
                patchServices.stdinListener.start();
            }
            boolean bl19 = patchServices.internalStatus = patchProProperties.getProperty("patchpro.internal.statustags", "false").compareTo("true") == 0;
            if (!bl16) {
                System.exit(1);
            } else {
                patchServices.instantiateModel();
                if (downloadDirectory != null) {
                    patchProProperties.setProperty("patchpro.download.directory", downloadDirectory);
                    patchProProperties.setProperty("patchpro.patch.sequester.directory", downloadDirectory + File.separator + "patchproSequester");
                }
                if (string2 != null) {
                    patchServices.changeConfigFile(string2);
                }
                if (option_o_Specified) {
                    bl18 = patchServices.setInstallHost(targetHostStr);
                    if (!bl18) {
                        System.exit(1);
                    }
                    if (option_p_Specified) {
                        if (bl4 || bl7) {
                            patchProProperties.setHostSpecificProperty(targetHostStr, "patchpro.patches.provided", patchIDStr);
                        } else {
                            PatchServices.usage(localizedMessages);
                            System.exit(1);
                        }
                    }
                    patchProProperties.setProperty("patchpro.target.hosts", targetHostStr);
                } else if (option_p_Specified) {
                    if (bl4 || bl7 || bl8) {
                        patchProProperties.setProperty("patchpro.patches.provided", patchIDStr);
                        bl18 = patchServices.setInstallHost(null);
                    } else {
                        PatchServices.usage(localizedMessages);
                        System.exit(1);
                    }
                }
                if (bl9) {
                    if (!bl7) {
                        PatchServices.usage(localizedMessages);
                        System.exit(1);
                    } else {
                        patchServices.setNoninteractive();
                    }
                }
                if (bl8) {
                    if (string == null) {
                        string = LIST_RESULT_FILE;
                    }
                    if (bl15) {
                        PatchList patchList = patchServices.displayPatchMetaData();
                    } else {
                        PatchList patchList = patchServices.displayPatchList();
                    }
                }
                if (bl4) {
                    if (string == null) {
                        string = "results.xml";
                    }
                    patchServices.downloadAllPatches();
                }
                if (bl7) {
                    if (string == null) {
                        string = "results.xml";
                    }
                    patchServices.installPatches();
                }
                if (bl11) {
                    int n2 = 1;
                    if (bl8 || bl4 || bl7) {
                        patchServices.initializeHost();
                        if (bl8) {
                            n2 = 1;
                        } else if (bl4) {
                            n2 = 3;
                        } else if (bl7) {
                            n2 = 16;
                        }
                        patchServices.setSessionID(string4, string, n2);
                    }
                }
            }
        }
        catch (PatchProException patchProException) {
            PatchProLog.getInstance().printStackTrace(patchProException, 7, patchProException);
            System.err.println(patchProException.getLocalizedMessage());
            PatchServices.maybeExit(1);
            return;
        }
        catch (GetOptException getOptException) {
            System.err.println(getOptException.getMessage());
            PatchServices.usage(localizedMessages);
            PatchServices.maybeExit(1);
            return;
        }
        catch (IOException iOException) {
            PatchServices.maybeExit(1);
            return;
        }
        catch (Throwable throwable) {
            PatchProLog.getInstance().printStackTrace(throwable, 3, throwable);
            System.err.println(throwable.getMessage());
            PatchServices.maybeExit(1);
            return;
        }
        PatchServices.maybeExit(0);
    }

    private static void usage(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("pprosvcUsage", "usage:\tpprosvc [-d [-p patch-id[,patch-id,...]]] [-h]\n\t[-i [-n] [-p patch-id[,patch-id,...]]] [-l]\n\n\tWhere:\n"));
        System.err.println("\t-d\t" + localizedMessages.getMessage("usageDownloadAll", "Downloads the patches that are required by this hos\n\t\tsystem"));
        System.err.println("\t-h\t" + localizedMessages.getMessage("usageHelp", "Displays command usage statement"));
        System.err.println("\t-i\t" + localizedMessages.getMessage("usageInstallAll", "Installs the patches from the designated download\n\t\tdirectory"));
        System.err.println("\t-l\t" + localizedMessages.getMessage("usageListPatches", "Analyzes the host system to generate a list of required\n\t\tpatches"));
        System.err.println("\t-n\t" + localizedMessages.getMessage("usageNonInteractive", "Runs Patch Manager in non-interactive mode"));
        System.err.println("\t-p\t" + localizedMessages.getMessage("usagePatchID", "Specifies the particular patches on which to operate"));
    }

    private void instantiateModel() throws PatchProException {
        PatchProAccessor patchProAccessor = new PatchProAccessor();
        this.model = patchProAccessor.getPatchPro();
    }

    private void initializeHost() {
        this.primaryHost = this.model.getHost();
    }

    public PatchList displayPatchList() throws PatchProException {
        PatchList patchList = null;
        System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
        this.printTaggedMessage("STATUS ANALYZE BEGIN", null, null, null);
        this.prepForThread(0, 100);
        try {
            this.model.assessNeededPatches();
            this.waitForThread();
        }
        catch (Exception exception) {
            this.printExceptionMessage(exception);
            System.exit(1);
        }
        if (this.debug) {
            System.out.println("Checking cancellation after patch assessment is done.");
        }
        CancelManager.getInstance().doExitIfCancelRequested("STATUS ANALYZE END", "ANALYZE.253", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CANCELLED", "Analyze phase cancelled after patch assessment.") + "\"", null);
        patchList = this.model.getNeededPatches();
        System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
        patchList = this.getEntitledPatchList(patchList);
        this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.0", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_SUCCESS", "Request to analyze the system was successful.") + "\"", null);
        SessionData sessionData = this.model.getHost().getSessionData();
        sessionData.setPatchesRequired(patchList);
        if (this.debug) {
            System.out.println("Done determining the patches that the client is entitled to during displayPatchList().");
        }
        if (patchList.size() > 0) {
            this.printPatchList(patchList);
        } else {
            System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
        }
        return patchList;
    }

    public void printExceptionMessage(Exception exception) {
        Object object;
        String string = " ";
        string = exception instanceof PatchProException ? "Failure: " + exception.getMessage() : (exception instanceof PatchProRuntimeException ? ((object = ((PatchProRuntimeException)exception).getTargetException()) == null ? "Unexpected Failure: " + exception.toString() : "Unexpected Failure: " + ((Throwable)object).toString()) : "Error: " + exception.getMessage());
        object = this.properties.getProperty("patchpro.detectors.name");
        String string2 = this.properties.getProperty("patchpro.patchset");
        if (this.debug) {
            System.out.println("downloadAllPatches(): The detectors name: " + (String)object + " The database name: " + string2);
        }
        this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.255", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_GENERIC_ERROR", "Error occured while executing the command or while downloading the detectors {0} or database {1} or while analyzing the system to determine the updates. Verify that valid options and arguments are specified with the command and that the system is configured and registered properly. The detailed error message is: {2}") + "\"", " \"" + (String)object + "\" \"" + string2 + "\" \"" + string + "\"");
        System.err.println(string);
        PatchProLog.getInstance().printStackTrace(this, 2, exception);
    }

    public void printPatchList(PatchList patchList) {
        System.out.println(this.msgcat.getMessage("reqPatches", "Required patches."));
        if (patchList.hasAnyErrors()) {
            System.out.println(this.msgcat.getMessage("errorsFound", "Errors were found."));
        }
        for (int i = 0; i < patchList.size(); ++i) {
            try {
                Patch patch = patchList.getPatchAt(i);
                System.out.println(patch.getPatchID().getPatchID() + " " + patch.getPatchInfo().getSynopsis());
                boolean bl = patchList.hasErrorAt(i);
                if (!bl) continue;
                System.err.println("    Error: " + patchList.getErrorAt(i));
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                System.err.println("Error: The patch list contains a non-existing patch.");
            }
        }
    }

    public PatchList displayPatchMetaData() throws PatchProException {
        System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
        this.printTaggedMessage("STATUS ANALYZE BEGIN", null, null, null);
        this.prepForThread(0, 100);
        try {
            this.model.assessNeededPatches();
            this.waitForThread();
        }
        catch (Exception exception) {
            this.printExceptionMessage(exception);
            System.exit(1);
        }
        if (this.debug) {
            System.out.println("Checking cancellation after patch assessment is done.");
        }
        CancelManager.getInstance().doExitIfCancelRequested("STATUS ANALYZE END", "ANALYZE.253", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CANCELLED", "Analyze phase cancelled after patch assessment.") + "\"", null);
        PatchList patchList = this.model.getNeededPatches();
        patchList = this.getEntitledPatchList(patchList);
        this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.0", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_SUCCESS", "Request to analyze the system was successful.") + "\"", null);
        SessionData sessionData = this.model.getHost().getSessionData();
        sessionData.setPatchesRequired(patchList);
        if (this.debug) {
            System.out.println("Done determining the patches that the client is entitled to during displayPatchMetaData().");
        }
        Vector vector = this.convertPatchListResolved(patchList, this.model.getHost());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
        return patchList;
    }

    public Vector convertPatchList(PatchList patchList) throws PatchProException {
        return PatchServices.convertPatchList(patchList, null);
    }

    public Vector convertPatchListResolved(PatchList patchList, ReadOnlyHost readOnlyHost) throws PatchProException {
        Vector vector = new Vector();
        for (int i = 0; i < patchList.size(); ++i) {
            Patch patch = patchList.getPatchAt(i);
            String string = patch.getPatchID().getPatchID();
            PatchInfo patchInfo = patch.getPatchInfo();
            PatchServices.addData(vector, string, "id", string);
            PatchServices.addData(vector, string, "syn", patchInfo.getSynopsis());
            PatchServices.addData(vector, string, "obs", patchInfo.getObsoletes());
            PatchServices.addData(vector, string, "req", this.getPatches(patchInfo.getRequires(), readOnlyHost));
            PatchServices.addData(vector, string, "inc", patchInfo.getIncompat());
            PatchServices.addData(vector, string, "obsc", patchInfo.getObsolesces());
            PatchServices.addData(vector, string, "prf", patchInfo.getPrefers());
            PatchServices.addData(vector, string, "rel", patchInfo.getReleaseDate());
            PatchServices.addData(vector, string, "size", patchInfo.getSize());
            PatchServices.addData(vector, string, "props", PatchServices.translateProps(patchInfo));
            PatchServices.addData(vector, string, "real", PatchServices.translateReal(patchInfo));
        }
        return vector;
    }

    public static Vector convertPatchList(PatchList patchList, ReadOnlyHost readOnlyHost) throws PatchProException {
        Vector vector = new Vector();
        for (int i = 0; i < patchList.size(); ++i) {
            Patch patch = patchList.getPatchAt(i);
            String string = patch.getPatchID().getPatchID();
            PatchInfo patchInfo = patch.getPatchInfo();
            PatchServices.addData(vector, string, "id", string);
            PatchServices.addData(vector, string, "syn", patchInfo.getSynopsis());
            PatchServices.addData(vector, string, "obs", patchInfo.getObsoletes());
            PatchServices.addData(vector, string, "req", patchInfo.getRequires());
            PatchServices.addData(vector, string, "inc", patchInfo.getIncompat());
            PatchServices.addData(vector, string, "obsc", patchInfo.getObsolesces());
            PatchServices.addData(vector, string, "prf", patchInfo.getPrefers());
            PatchServices.addData(vector, string, "rel", patchInfo.getReleaseDate());
            PatchServices.addData(vector, string, "size", patchInfo.getSize());
            PatchServices.addData(vector, string, "props", PatchServices.translateProps(patchInfo));
            PatchServices.addData(vector, string, "real", PatchServices.translateReal(patchInfo));
        }
        return vector;
    }

    private static void addData(Vector vector, String string, String string2, String string3) {
        if (string3 != null) {
            vector.add(string + "." + string2 + "=" + string3);
        }
    }

    private static String translateReal(PatchInfo patchInfo) throws PatchProException {
        Enumeration enumeration = patchInfo.getRealizations();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Realization realization = (Realization)enumeration.nextElement();
            stringBuffer.append(" ").append(realization.getRealizationString());
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(1);
        }
        return null;
    }

    private static String translateProps(PatchInfo patchInfo) throws PatchProException {
        PatchProperties patchProperties = patchInfo.getProperties();
        StringBuffer stringBuffer = new StringBuffer();
        if (patchProperties.isDiscontinued()) {
            stringBuffer.append(" discontinued");
        }
        if (patchProperties.isClientroot()) {
            stringBuffer.append(" clientroot");
        }
        if (patchProperties.isClientusr()) {
            stringBuffer.append(" clientusr");
        }
        if (patchProperties.isInteractive()) {
            stringBuffer.append(" interactive");
        }
        if (patchProperties.isNonstandard()) {
            stringBuffer.append(" nonstandard");
        }
        if (patchProperties.isSingleuser()) {
            stringBuffer.append(" singleuser");
        }
        if (patchProperties.isObsolete()) {
            stringBuffer.append(" obsolete");
        }
        if (patchProperties.isNoncontract()) {
            stringBuffer.append(" noncontract");
        }
        if (patchProperties.isRebootimmediate()) {
            stringBuffer.append(" rebootimmediate");
        }
        if (patchProperties.isRebootafter()) {
            stringBuffer.append(" rebootafter");
        }
        if (patchProperties.isReconfigimmediate()) {
            stringBuffer.append(" reconfigimmediate");
        }
        if (patchProperties.isReconfigafter()) {
            stringBuffer.append(" reconfigafter");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(1);
        }
        return null;
    }

    public static Vector getAllPropsWithTag(Vector vector, String string) {
        string = "." + string;
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            String string2 = (String)enumeration.nextElement();
            String string3 = string2.substring(0, n = string2.indexOf(61));
            if (!string3.endsWith(string)) continue;
            vector2.add(string2.substring(n + 1));
        }
        return vector2;
    }

    public void downloadAllPatches() throws PatchProException {
        System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
        this.printTaggedMessage("STATUS ANALYZE BEGIN", null, null, null);
        if (this.hostIsAnalyzed) {
            this.prepForThread(20, 50);
        } else {
            this.prepForThread(0, 50);
        }
        try {
            this.model.assessNeededPatches();
            this.waitForThread();
        }
        catch (Exception exception) {
            this.printExceptionMessage(exception);
            System.exit(1);
        }
        if (this.debug) {
            System.out.println("Checking cancellation after patch assessment is done.");
        }
        CancelManager.getInstance().doExitIfCancelRequested("STATUS ANALYZE END", "ANALYZE.253", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CANCELLED", "Analyze phase cancelled after patch assessment.") + "\"", null);
        PatchList patchList = this.model.getNeededPatches();
        System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
        patchList = this.getEntitledPatchList(patchList);
        this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.0", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_SUCCESS", "Request to analyze the system was successful.") + "\"", null);
        SessionData sessionData = this.model.getHost().getSessionData();
        sessionData.setPatchesRequired(patchList);
        if (this.debug) {
            System.out.println("Done determining the patches that the client is entitled to during downloadAllPatches().");
        }
        if (patchList.size() > 0) {
            System.out.println(this.msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + this.properties.getProperty("patchpro.download.directory") + "...");
            this.prepForThread(50, 100);
            this.model.downloadPatches();
            try {
                this.waitForThread();
            }
            catch (Exception exception) {
                this.printExceptionMessage(exception);
                System.exit(1);
            }
            PatchList patchList2 = this.model.getUnavailablePatches();
            if (patchList2 != null && patchList2.size() != 0) {
                System.out.println(this.msgcat.getMessage("downloaded_not", "The following patches were not downloaded:"));
                for (int i = 0; i < patchList2.size(); ++i) {
                    IPatch iPatch;
                    try {
                        iPatch = (IPatch)patchList2.getPatchAt(i);
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        throw new PatchProException(noSuchPatchException);
                    }
                    if (iPatch == null) continue;
                    System.out.println("\t" + iPatch.getPatchID().getPatchID() + ": " + iPatch.getError());
                }
            }
        } else {
            System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
        }
    }

    public boolean setInstallHost(String string) throws PatchProException {
        ReadOnlyHost readOnlyHost;
        boolean bl = true;
        if (!this.hostIsAnalyzed) {
            this.prepForThread(0, 20);
            this.model.analyzeHost();
            try {
                this.waitForThread();
            }
            catch (Exception exception) {
                this.printExceptionMessage(exception);
                System.exit(1);
            }
            this.hostIsAnalyzed = true;
        }
        this.primaryHost = this.model.getHost();
        if (string == null) {
            string = targetHostStr = this.primaryHost.getAddress();
        }
        Enumeration enumeration = this.primaryHost.getAssociates();
        int n = this.primaryHost.getAssociateCount() + 1;
        Vector<ReadOnlyHost> vector = new Vector<ReadOnlyHost>(n);
        vector.add(this.primaryHost);
        while (enumeration.hasMoreElements()) {
            readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
            vector.add(readOnlyHost);
        }
        boolean bl2 = this.validateIP(string);
        if (!bl2) {
            vector.clear();
            bl = false;
        } else {
            if (this.primaryHost.isAddress(string)) {
                vector.remove(this.primaryHost);
            }
            enumeration = this.primaryHost.getAssociates();
            while (enumeration.hasMoreElements()) {
                readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
                if (!readOnlyHost.isAddress(string)) continue;
                vector.remove(readOnlyHost);
            }
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                ReadOnlyHost readOnlyHost2 = (ReadOnlyHost)enumeration2.nextElement();
                readOnlyHost2.getSessionData().setIgnoreStatus(true);
            }
        }
        return bl;
    }

    private boolean validateIP(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        n2 = stringTokenizer.countTokens();
        if (n2 == 4) {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Integer n3 = new Integer(string2);
                int n4 = 0;
                int n5 = 255;
                if (n3.compareTo(new Integer(n4)) >= 0 && n3.compareTo(new Integer(n5)) <= 255) {
                    ++n;
                    continue;
                }
                System.out.println(this.msgcat.getMessage("invalidIPAddress", "An invalid IP address is specified."));
                break;
            }
            if (n == 4) {
                bl = true;
            }
        } else {
            System.out.println(this.msgcat.getMessage("invalidIPAddress", "An invalid IP address is specified."));
        }
        return bl;
    }

    public void setSessionID(String string, String string2, int n) {
        String string3;
        File file;
        File file2;
        String string4 = "patchpro.sessionid.directory.prefix";
        this.properties.setProperty(string4, "/var/tmp/pprosvc_");
        if (string2 == null || string2.length() == 0) {
            string2 = "results.xml";
        }
        if ((file2 = (file = new File(string3 = "/var/tmp/pprosvc_" + string + "/" + string2)).getParentFile()) != null && !file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            this.primaryHost.printXMLPatchListSet(n, 0, printWriter);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private boolean patchesAreRequired(ReadOnlyHost readOnlyHost) {
        SessionData sessionData = readOnlyHost.getSessionData();
        if (!sessionData.getIgnoreStatus() && sessionData.getPatchesRequired().size() > 0) {
            return true;
        }
        Enumeration enumeration = readOnlyHost.getAssociates();
        while (enumeration.hasMoreElements()) {
            Host host = (Host)enumeration.nextElement();
            sessionData = host.getSessionData();
            if (sessionData.getIgnoreStatus() || sessionData.getPatchesRequired().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public void installPatches() throws PatchProException {
        System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
        this.printTaggedMessage("STATUS ANALYZE BEGIN", null, null, null);
        if (this.hostIsAnalyzed) {
            this.prepForThread(20, 30);
        } else {
            this.prepForThread(0, 30);
        }
        try {
            this.model.assessNeededPatches();
            this.waitForThread();
        }
        catch (Exception exception) {
            this.printExceptionMessage(exception);
            System.exit(1);
        }
        if (this.debug) {
            System.out.println("Checking cancellation after patch assessment is done.");
        }
        CancelManager.getInstance().doExitIfCancelRequested("STATUS ANALYZE END", "ANALYZE.253", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CANCELLED", "Analyze phase cancelled after patch assessment.") + "\"", null);
        PatchList patchList = this.model.getNeededPatches();
        System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
        patchList = this.getEntitledPatchList(patchList);
        this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.0", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_SUCCESS", "Request to analyze the system was successful.") + "\"", null);
        SessionData sessionData = this.model.getHost().getSessionData();
        sessionData.setPatchesRequired(patchList);
        if (this.debug) {
            System.out.println("Done determining the patches that the client is entitled to during installPatches().");
        }
        if (this.patchesAreRequired(this.model.getHost())) {
            String string = this.properties.getProperty("patchpro.download.directory");
            System.out.println(this.msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + string + "...");
            this.prepForThread(30, 60);
            this.model.downloadPatches();
            try {
                this.waitForThread();
            }
            catch (Exception exception) {
                this.printExceptionMessage(exception);
                System.exit(1);
            }
            String string2 = this.properties.getProperty("patchpro.download.directory");
            System.out.println(this.msgcat.getMessage("installingPatches", "Applying patches from") + " " + string2 + "...");
            this.prepForThread(60, 100);
            this.model.installPatches();
            try {
                this.waitForThread();
            }
            catch (Exception exception) {
                this.printExceptionMessage(exception);
                System.exit(1);
            }
        } else {
            System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
        }
    }

    public boolean setRealizationsProvided(String string) {
        String string2 = "patchpro.realization.provided";
        boolean bl = true;
        if (string == null || string.equals("none")) {
            string = "";
        }
        if (string != "") {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    Realization realization = new Realization(string3);
                }
                catch (NoSuchRealizationException noSuchRealizationException) {
                    System.out.println(this.msgcat.getMessage("noSuchRealization", "Poorly formed realization."));
                    bl = false;
                    return bl;
                }
            }
        }
        this.properties.setProperty(string2, string);
        return bl;
    }

    public void downloadDocument(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        BufferedReader bufferedReader = null;
        File file = null;
        FileReader fileReader = null;
        try {
            PatchServerProxy patchServerProxy = new PatchServerProxy(this.properties);
            String string5 = this.properties.getProperty("patchpro.proxy.host");
            String string6 = this.properties.getProperty("patchpro.proxy.port");
            if (string5 != null && string6 != null && !string5.equals("") && !string6.equals("")) {
                System.setProperty("https.proxyHost", string5);
                System.setProperty("https.proxyPort", string6);
                System.setProperty("http.proxyHost", string5);
                System.setProperty("http.proxyPort", string6);
            }
            if (string.indexOf("ReadMe/") == 0) {
                string3 = StringUtilities.getFileName(string);
                if (string3.startsWith("README.")) {
                    string3 = string3.substring(7);
                }
                try {
                    PatchID patchID = new PatchID(string3);
                }
                catch (MalformedPatchException malformedPatchException) {
                    PatchProLog.getInstance().println(this, 2, malformedPatchException.getMessage());
                    System.err.println("Error: Invalid patch ID \"" + string3 + "\" detected while servicing " + "request to download a README file.");
                    System.err.println("Unable to download document : \"" + string + "\"");
                    System.exit(1);
                }
                string2 = "ReadMe" + File.separator + "README." + string3.trim();
                file = patchServerProxy.downloadReadMeFile(string2);
            } else if (string.indexOf("category/") == 0) {
                string2 = StringUtilities.getFileName(string);
                if (string2 == null || string2.equals("")) {
                    string2 = "default";
                }
                string2 = "category" + File.separator + string2;
                string2 = string2.trim();
                file = patchServerProxy.downloadCategoryFile(string2);
            } else if (string.indexOf("collection/") == 0) {
                string2 = StringUtilities.getFileName(string);
                if (string2 == null || string2.equals("")) {
                    string2 = "default";
                }
                string2 = "collection" + File.separator + string2;
                string2 = string2.trim();
                file = patchServerProxy.downloadCollectionFile(string2);
            } else if (string.indexOf("Database/") == 0) {
                string2 = StringUtilities.getFileName(string);
                if (string2 == null || string2.equals("")) {
                    string2 = "default";
                }
                string2 = "Database" + File.separator + string2;
                string2 = string2.trim();
                file = patchServerProxy.downloadDatabaseFile(string2);
                System.exit(0);
            } else {
                System.err.println("Invalid get documentation request detected : \"" + string + "\"");
                System.exit(1);
            }
            fileReader = new FileReader(file.getAbsolutePath());
            bufferedReader = new BufferedReader(fileReader);
            while ((string4 = bufferedReader.readLine()) != null) {
                System.out.println(string4);
            }
        }
        catch (PatchProException patchProException) {
            System.err.println("Error: Unable to download document : \"" + string + "\"");
            System.err.println(patchProException.getMessage());
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: Unable to locate the requested document : \"" + string + "\"");
            System.err.println(fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("Error: Unable to retrieve the cache file for : \"" + string + "\"");
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
    }

    private String getEntitlementList() {
        String string = "";
        String string2 = null;
        BufferedReader bufferedReader = null;
        File file = null;
        FileReader fileReader = null;
        PatchServerProxy patchServerProxy = null;
        try {
            patchServerProxy = new PatchServerProxy(this.properties);
            file = patchServerProxy.downloadEntitlementFile(null);
            fileReader = new FileReader(file.getAbsolutePath());
            bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2.trim() + " ";
            }
        }
        catch (DownloadEntitlementFileException downloadEntitlementFileException) {
            this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.1", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_ENTITLEMENT_SERVER_NOT_AVAILABLE", "The Entitlement Server is not available at this time to validate update download requests.") + "\"", null);
            System.err.println("Error: The Entitlement Server is not available at this time to validate update download requests.");
            System.err.println(downloadEntitlementFileException.getMessage());
            PatchProLog.getInstance().printStackTrace(this, 2, downloadEntitlementFileException);
            System.exit(1);
        }
        catch (PatchProException patchProException) {
            String string3 = this.properties.getProperty("patchpro.patch.source");
            if (this.debug) {
                System.out.println("getEntitlementList(): The update delivery server: " + string3);
            }
            this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.2", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_PATCH_SERVER_PROXY_ERROR", "Unable to download entitlement information using the update delivery server {0}.") + "\"", "\"" + string3 + "\"");
            if (this.debug) {
                System.out.println("getEntitlementList(): Done printing tagged message.");
            }
            System.err.println("Error: Unable to download entitlement information using the update server proxy.");
            System.err.println(patchProException.getMessage());
            PatchProLog.getInstance().printStackTrace(this, 2, patchProException);
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.3", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_ENTITLEMENT_RESOURCE_NOT_LOCATED", "Unable to locate the resource to retrieve entitlement information.") + "\"", null);
            System.err.println("Error: Unable to locate the resource to retrieve entitlement information");
            System.err.println(fileNotFoundException.getMessage());
            PatchProLog.getInstance().printStackTrace(this, 2, fileNotFoundException);
            System.exit(1);
        }
        catch (IOException iOException) {
            this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.4", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_ENTITLEMENT_INFORMATION_INACCESSIBLE", "Unable to access entitlement information.") + "\"", null);
            System.err.println("Error: Unable to access entitlement information.");
            System.err.println(iOException.getMessage());
            PatchProLog.getInstance().printStackTrace(this, 2, iOException);
            System.exit(1);
        }
        string = string.trim();
        return string;
    }

    private void printTaggedMessage(String string, String string2, String string3, String string4) {
        String string5 = "";
        if (this.debug) {
            System.out.println("Entered printTaggedMessage()");
        }
        if (this.internalStatus) {
            if (string2 == null) {
                string5 = string;
            } else if (string3 == null) {
                string5 = string + " " + string2;
            } else if (string4 == null) {
                string5 = string + " " + string2 + " " + string3;
            } else {
                string5 = string + " " + string2 + " " + string3 + " " + string4;
                if (this.debug) {
                    System.out.println("printTaggedMessage(): msg: " + string5);
                }
            }
            System.out.println(string5.trim());
        }
    }

    private PatchList getEntitledPatchList(PatchList patchList) {
        String string = this.getEntitlementList();
        if (this.debug) {
            System.out.println("srvrEntitlementList = " + string);
        }
        if (string.equals("") || string == null) {
            if (this.debug) {
                System.out.println("ENTERED srvrEntitlementList is NULL");
            }
            this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.255", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_GENERIC_ERROR_ENTITLEMENT_PERM", "Entitlement permissions to all patches are denied.") + "\"", null);
            System.err.println("Error: Entitlement permissions to all patches are denied.");
            PatchProLog.getInstance().println(this, 2, "Entitlement permissions to all patches are denied.");
            System.exit(1);
        }
        String string2 = "";
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("*")) {
                if (this.debug) {
                    System.out.println("The srvrEntitlementToken = " + string2 + " entitled to all patches");
                }
                return patchList;
            }
            if (this.debug) {
                System.out.println("The srvrEntitlementToken = " + string2);
            }
            vector.addElement(string2);
        }
        int n = patchList.size();
        String[] stringArray = new String[n];
        Vector vector2 = this.createPatchListVector(patchList);
        for (int i = 0; i < n; ++i) {
            stringArray[i] = " ";
        }
        if (this.debug) {
            System.out.println("The patchListVector is:");
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                System.out.println(enumeration.nextElement());
            }
        }
        String string3 = null;
        boolean bl = false;
        Patch patch = null;
        String string4 = "";
        String string5 = null;
        String string6 = null;
        StringTokenizer stringTokenizer2 = null;
        StringTokenizer stringTokenizer3 = null;
        String string7 = null;
        for (int i = n - 1; i >= 0; --i) {
            int n2;
            String string8;
            block31: {
                string3 = stringArray[i];
                if (!string3.equals(" ")) continue;
                try {
                    patch = patchList.getPatchAt(i);
                    string4 = patch.getPatchID().getPatchID();
                    if (this.debug) {
                        System.out.println("\nThe patch whose entitlementList is retrieved.");
                        System.out.println(string4 + " " + patch.getPatchInfo().getSynopsis());
                    }
                    if (!(bl = patchList.hasErrorAt(i))) break block31;
                    System.err.println("    Error: " + patchList.getErrorAt(i));
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    System.err.println("Error: The patch list contains a non-existing patch.");
                    continue;
                }
            }
            string5 = patch.getPatchInfo().getEntitlementList();
            string7 = patch.getPatchInfo().getRequires();
            if (this.debug) {
                System.out.println("requiredPatches = " + string7);
                System.out.println("patchEntitlementList = " + string5);
            }
            if (string5.equals("") || string5 == null) {
                if (this.debug) {
                    System.out.println("ENTERED patchEntitlementList is NULL");
                }
                stringArray[i] = string4;
                if (this.debug) {
                    System.out.println("NULL: Added patch.\n");
                }
                stringTokenizer3 = new StringTokenizer(string7.trim(), " ");
                while (stringTokenizer3.hasMoreTokens()) {
                    string8 = stringTokenizer3.nextToken();
                    if (this.debug) {
                        System.out.println("The patchRequiredToken = " + string8);
                    }
                    if (!vector2.contains(string8)) continue;
                    n2 = vector2.indexOf(string8);
                    stringArray[n2] = string8;
                    if (!this.debug) continue;
                    System.out.println("NULL: Added required patch. \n");
                }
                if (!this.debug) continue;
                System.out.println("END of NULL");
                continue;
            }
            if (this.debug) {
                System.out.println("ENTERED patchEntitlementList is NON-NULL");
            }
            string6 = "";
            stringTokenizer2 = new StringTokenizer(string5.trim(), " ");
            while (stringTokenizer2.hasMoreTokens()) {
                string6 = stringTokenizer2.nextToken();
                if (this.debug) {
                    System.out.println("patchEntitlementToken = " + string6);
                }
                if (!vector.contains(string6)) continue;
                stringArray[i] = string4;
                if (this.debug) {
                    System.out.println("NON-NULL: Added patch.\n");
                }
                stringTokenizer3 = new StringTokenizer(string7.trim(), " ");
                while (stringTokenizer3.hasMoreTokens()) {
                    string8 = stringTokenizer3.nextToken();
                    if (this.debug) {
                        System.out.println("The patchRequiredToken = " + string8);
                    }
                    if (!vector2.contains(string8)) continue;
                    n2 = vector2.indexOf(string8);
                    stringArray[n2] = string8;
                    if (!this.debug) continue;
                    System.out.println("NON-NULL: Added required patch.\n");
                }
                break block9;
            }
            if (!this.debug) continue;
            System.out.println("END of NON-NULL");
        }
        PatchListImpl patchListImpl = new PatchListImpl();
        bl = false;
        for (int i = 0; i < n; ++i) {
            IPatch iPatch;
            block32: {
                String string9 = stringArray[i];
                if (string9.equals(" ")) {
                    if (!option_p_Specified) continue;
                    this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.5", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_PATCH_ENTITLEMENT_DENIED", "One or more of the updates specified do not have entitlement permissions.") + "\"", null);
                    System.err.println("Error: One or more of the updates specified do not have entitlement permissions.");
                    PatchProLog.getInstance().println(this, 2, "One or more of the updates specified do not have entitlement permissions.");
                    System.exit(1);
                    continue;
                }
                iPatch = null;
                Patch patch2 = null;
                String string10 = "";
                try {
                    iPatch = (IPatch)patchList.getPatchAt(i);
                    patch2 = patchList.getPatchAt(i);
                    string10 = patch2.getPatchID().getPatchID();
                    if (this.debug) {
                        System.out.println("The patch whose entitlementList is retrieved.");
                        System.out.println(string10 + " " + patch2.getPatchInfo().getSynopsis());
                    }
                    if (!(bl = patchList.hasErrorAt(i))) break block32;
                    System.err.println("    Error: " + patchList.getErrorAt(i));
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    System.err.println("Error: The patch list contains a non-existing patch.");
                    continue;
                }
            }
            patchListImpl.addIPatch(iPatch);
        }
        return patchListImpl;
    }

    public Vector createPatchListVector(PatchList patchList) {
        Vector<String> vector = new Vector<String>(patchList.size());
        if (patchList.hasAnyErrors()) {
            System.out.println(this.msgcat.getMessage("errorsFound", "Errors were found."));
        }
        for (int i = 0; i < patchList.size(); ++i) {
            try {
                Patch patch = patchList.getPatchAt(i);
                vector.addElement(patch.getPatchID().getPatchID());
                boolean bl = patchList.hasErrorAt(i);
                if (!bl) continue;
                System.err.println("    Error: " + patchList.getErrorAt(i));
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                System.err.println("Error: The patch list contains a non-existing patch.");
            }
        }
        return vector;
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
        Percentage percentage = ((PatchProModel)patchProEvent.getSource()).getPatchProProgress();
        if (this.internalStatus) {
            System.out.println("STATUS PROGRESS " + (int)((double)(this.progressMax - this.progressMin) / 100.0 * (double)percentage.getPercentage() + (double)this.progressMin) + " " + "\"" + patchProEvent.getErrorMessage() + "\"");
        }
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        if (object instanceof PatchProModel) {
            Throwable throwable = ((PatchProModel)object).getPatchProFailure();
            if (throwable instanceof NonFatalException) {
                if (!throwable.getLocalizedMessage().equals("Received a Manipulable event.")) {
                    System.err.println(throwable.getLocalizedMessage());
                }
            } else {
                this.problem = throwable;
            }
        } else {
            this.problem = new RuntimeException("Error: Event source is " + object.getClass().getName() + ", not PatchProModel");
        }
    }

    public void setNoninteractive() {
        this.model.setInteractive(false);
    }

    public void changeConfigFile(String string) throws IOException {
        File file = new File(string);
        try {
            if (!file.isAbsolute()) {
                file = new File(this.instParms.getConfigDirectoryPath(), string);
            }
            this.properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(this.msgcat.getMessage("config.file.not.found", "The specified configuration file could not be found."));
            throw new IOException("No Such Config File.");
        }
        catch (IOException iOException) {
            System.out.println(this.msgcat.getMessage("config.file.not.readable", "The specified configuration file cannot be read."));
            throw iOException;
        }
    }

    private void prepForThread(int n, int n2) {
        this.model.addListener(this);
        this.progressMin = n;
        this.progressMax = n2;
        this.done = false;
        this.problem = null;
    }

    private void waitForThread() throws Exception {
        while (!this.done) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.model.removeListener(this);
        if (this.problem == null) {
            return;
        }
        if (this.problem instanceof RuntimeException) {
            throw (RuntimeException)this.problem;
        }
        if (this.problem instanceof Error) {
            throw new Exception(this.problem.getMessage());
        }
        if (this.problem instanceof PatchProException) {
            throw (PatchProException)this.problem;
        }
        throw new PatchProRuntimeException("Unexpected throwable", this.problem);
    }

    private static void maybeExit(int n) {
        if (noExit) {
            System.out.println("System.exit(" + n + ")");
        } else {
            System.exit(n);
        }
    }

    private void setProperties(Vector vector) throws PatchProException {
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                String string3 = (String)enumeration.nextElement();
                int n = string3.indexOf(61);
                if (n >= 0) {
                    string2 = string3.substring(0, n);
                    string = string3.substring(n + 1);
                } else {
                    string2 = string3;
                    PropertyInfo propertyInfo = this.properties.getPropertyInfo(string2);
                    if (TTY.isaTTY()) {
                        System.err.print(propertyInfo.getDescription() + ": ");
                        if (propertyInfo.getSecretFlag()) {
                            TTY.echoOff();
                        }
                        string = this.readLine();
                        if (propertyInfo.getSecretFlag()) {
                            TTY.echoOn();
                            System.err.println();
                        }
                    } else {
                        string = this.readLine();
                    }
                }
                this.properties.setProperty(string2, string);
            }
        }
        catch (PatchPropertyNotFoundException patchPropertyNotFoundException) {
            throw new PatchProException(patchPropertyNotFoundException.getLocalizedMessage());
        }
    }

    private String readLine() throws PatchProException {
        if (this.stdin == null) {
            this.stdin = new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            return this.stdin.readLine();
        }
        catch (IOException iOException) {
            throw new PatchProException(iOException);
        }
    }

    private String getPatches(String string, ReadOnlyHost readOnlyHost) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        HostSpecificInterpreter hostSpecificInterpreter = null;
        hostSpecificInterpreter = readOnlyHost == null ? null : readOnlyHost.getSessionData().getInterpreter();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            if (string2.startsWith("(") || string2.endsWith(")") || bl) {
                if (string2.startsWith("(")) {
                    bl = true;
                }
                if (string2.endsWith(")")) {
                    bl = false;
                }
                string3 = string2 + " ";
                if (bl) continue;
                try {
                    if (hostSpecificInterpreter == null) {
                        string4 = string4 + " ";
                        continue;
                    }
                    String[] stringArray = hostSpecificInterpreter.getPatchList(string3);
                    for (int i = 0; i < stringArray.length; ++i) {
                        string4 = string4 + stringArray[i] + " ";
                    }
                    continue;
                }
                catch (ParseError parseError) {
                    System.err.println("WARNING: Invalid expression encountered in patch data\n\t" + string3);
                    return string4;
                }
            }
            string4 = string4 + string2 + " ";
        }
        return this.getUninstalledLatestPatches(string4, readOnlyHost);
    }

    private String getUninstalledLatestPatches(String string, ReadOnlyHost readOnlyHost) {
        String string2 = "";
        String string3 = "";
        Vector<String> vector = new Vector<String>();
        SessionData sessionData = readOnlyHost.getSessionData();
        PatchDB patchDB = sessionData.getPatchDB();
        PatchID patchID = null;
        PatchImpl patchImpl = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            try {
                patchID = new PatchID(string3);
            }
            catch (MalformedPatchException malformedPatchException) {
                PatchProLog.getInstance().println(this, 2, malformedPatchException.getMessage());
                System.out.println("ERROR: " + malformedPatchException.getMessage());
                continue;
            }
            try {
                if (readOnlyHost.hasPatch(patchID)) continue;
                patchImpl = patchDB.getLatestPatch(patchID);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                PatchProLog.getInstance().println(this, 2, noSuchPatchException.getMessage());
                System.out.println("ERROR: " + noSuchPatchException.getMessage());
                continue;
            }
            vector.addElement(patchImpl.getPatchIDKey());
        }
        for (int i = 0; i < vector.size(); ++i) {
            string2 = string2 + " " + vector.elementAt(i);
        }
        return string2;
    }
}

