/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.host;

import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.database.PatchDBBuilder;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.Messagable;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class SessionData
implements Serializable,
Messagable {
    public static final int PATCHES_NONE = 0;
    public static final int PATCHES_REQUIRED = 1;
    public static final int PATCHES_CORRUPT_ON_DOWNLOAD = 2;
    public static final int PATCHES_UNAVAILABLE = 3;
    public static final int PATCHES_ALREADY_PRESENT = 4;
    public static final int PATCHES_DOWNLOADED = 5;
    public static final int PATCHES_CORRUPT_ON_INSTALL = 6;
    public static final int PATCHES_WITH_BAD_PROPERTIES = 7;
    public static final int PATCHES_FAILING_INSTALL = 8;
    public static final int PATCHES_INSTALLED = 9;
    public static final int PATCHES_SEQUESTERED = 10;
    public static final int PATCHES_DEFERRED = 11;
    public static final int PATCHES_NOT_DOWNLOADED = 12;
    public static final int PATCHES_ACQUIRED = 13;
    public static final int PATCHES_NOT_INSTALLED = 14;
    public static final int PATCHES_ADDRESSED_IN_DOWNLOAD = 15;
    public static final int PATCHES_ADDRESSED_IN_INSTALL = 16;
    Host host = null;
    boolean isAssociate = false;
    boolean patchListSetExternally = false;
    protected transient PatchDBBuilder dbBuilder = null;
    protected PatchDB db = null;
    protected transient PatchProProperties properties;
    protected transient HostSpecificInterpreter interpreter = null;
    protected File latestDownloadDestination;
    private boolean propertiesAreDefault = true;
    private PatchListImpl patchesRequiredImpl = null;
    PatchInfoImpl genPatchInfo = null;
    private PatchList patchesRequired = null;
    private PatchListImpl patchesCorruptOnDownload = null;
    private PatchListImpl patchesUnavailable = null;
    private PatchListImpl patchesAlreadyPresent = null;
    private PatchListImpl patchesDownloaded = null;
    private PatchListImpl patchesCorruptOnInstall = null;
    private PatchListImpl patchesWithBadProperties = null;
    private PatchListImpl patchesFailingInstall = null;
    private PatchListImpl patchesInstalled = null;
    private PatchListImpl patchesSequestered = null;
    private PatchListImpl patchesDeferred = null;
    private transient PatchProLog log = PatchProLog.getInstance();
    private Collection exceptionRepository;
    private boolean errorDetected;
    boolean ignoreStatus = false;

    public SessionData() {
        this.properties = PatchProProperties.getInstance();
        this.exceptionRepository = new Vector();
        this.patchesRequiredImpl = new PatchListImpl();
        this.patchesRequired = this.patchesRequiredImpl;
        this.genPatchInfo = new PatchInfoImpl();
        this.genPatchInfo.setProperties(new PatchProperties(""));
    }

    public SessionData(Host host) {
        this();
        this.host = host;
    }

    public void clearDownloadSession() {
        this.patchesRequiredImpl = new PatchListImpl();
        this.patchesRequired = this.patchesRequiredImpl;
        this.patchesCorruptOnDownload = null;
        this.patchesUnavailable = null;
        this.patchesAlreadyPresent = null;
        this.patchesDownloaded = null;
    }

    public void clearInstallSession() {
        this.patchesCorruptOnInstall = null;
        this.patchesWithBadProperties = null;
        this.patchesFailingInstall = null;
        this.patchesInstalled = null;
        this.patchesSequestered = null;
        this.patchesDeferred = null;
    }

    public void clearSessionErrors() {
        this.errorDetected = false;
        this.exceptionRepository = new Vector();
    }

    public void clearSession() {
        this.clearDownloadSession();
        this.clearInstallSession();
        this.clearSessionErrors();
    }

    public void createProperties() {
        if (this.properties == null) {
            this.properties = PatchProProperties.getInstance();
        }
        if (this.propertiesAreDefault) {
            if (this.host.isAssociate()) {
                this.properties = this.properties.getHostSpecificProperties(this.host);
            }
            this.propertiesAreDefault = false;
        }
        String string = this.properties.getProperty("patchpro.download.directory", "/var/spool/pkg/patchpro");
        this.latestDownloadDestination = new File(string);
    }

    public void createInterpreter() {
        this.interpreter = new HostSpecificInterpreter(this.host);
    }

    public void createPatchDBBuilder() {
        String string = this.properties.getProperty("patchpro.database.builder");
        try {
            this.dbBuilder = (PatchDBBuilder)Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            this.log.printStackTrace(this, 2, throwable);
            this.addPatchProException(throwable);
        }
    }

    public void setPatchProExceptions(Collection collection) {
        this.exceptionRepository.addAll(collection);
        if (collection.size() > 0) {
            this.errorDetected = true;
        }
    }

    public void addPatchProException(Throwable throwable) {
        if (!this.exceptionRepository.contains(throwable)) {
            this.exceptionRepository.add(throwable);
        }
        this.errorDetected = true;
    }

    public void setLatestDownloadDestination(File file) {
        this.latestDownloadDestination = file;
    }

    public void setPatchesRequired(PatchList patchList) {
        this.patchesRequired = patchList;
        this.patchListSetExternally = true;
    }

    public void addToPatchList(int n, Patch patch, String string) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (string.length() == 0) {
                    this.addPatchRequired(patch);
                    break;
                }
                this.addPatchRequired(patch, string);
                break;
            }
            case 2: {
                this.addPatchCorruptOnDownload(patch, string);
                break;
            }
            case 3: {
                this.addPatchUnavailable(patch, string);
                break;
            }
            case 4: {
                this.addPatchAlreadyPresent(patch);
                break;
            }
            case 5: {
                this.addPatchDownloaded(patch);
                break;
            }
            case 6: {
                this.addPatchCorruptOnInstall(patch, string);
                break;
            }
            case 7: {
                this.addPatchWithBadProperties(patch, string);
                break;
            }
            case 8: {
                this.addPatchFailingInstall(patch, string);
                break;
            }
            case 9: {
                this.addPatchInstalled(patch);
                break;
            }
            case 10: {
                this.addPatchSequestered(patch);
                break;
            }
            case 11: {
                this.addPatchDeferred(patch);
                break;
            }
        }
    }

    public PatchList getPatchList(int n) {
        PatchList patchList;
        switch (n) {
            case 1: {
                patchList = this.getPatchesRequired();
                break;
            }
            case 2: {
                patchList = this.getPatchesCorruptOnDownload();
                break;
            }
            case 3: {
                patchList = this.getPatchesUnavailable();
                break;
            }
            case 4: {
                patchList = this.getPatchesAlreadyPresent();
                break;
            }
            case 5: {
                patchList = this.getPatchesDownloaded();
                break;
            }
            case 6: {
                patchList = this.getPatchesCorruptOnInstall();
                break;
            }
            case 7: {
                patchList = this.getPatchesWithBadProperties();
                break;
            }
            case 8: {
                patchList = this.getPatchesFailingInstall();
                break;
            }
            case 9: {
                patchList = this.getPatchesInstalled();
                break;
            }
            case 10: {
                patchList = this.getPatchesSequestered();
                break;
            }
            case 11: {
                patchList = this.getPatchesDeferred();
                break;
            }
            case 12: {
                patchList = this.getPatchesNotDownloaded();
                break;
            }
            case 13: {
                patchList = this.getPatchesAcquired();
                break;
            }
            case 14: {
                patchList = this.getPatchesNotInstalled();
                break;
            }
            case 15: {
                patchList = this.getPatchesAddressedInDownload();
                break;
            }
            case 16: {
                patchList = this.getPatchesAddressedInInstall();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Recieved " + n);
            }
        }
        return patchList;
    }

    public void addPatchRequired(Patch patch) {
        IPatch iPatch = new IPatch(patch);
        this.patchesRequiredImpl.addAndSelectIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the required list.");
    }

    public void addPatchRequired(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.patchesRequiredImpl.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the required list. ErrString: " + string);
    }

    public void addPatchCorruptOnDownload(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchCorruptOnDownload(iPatch);
    }

    public void addPatchCorruptOnDownload(IPatch iPatch) {
        if (this.patchesCorruptOnDownload == null) {
            this.patchesCorruptOnDownload = new PatchListImpl();
        }
        this.patchesCorruptOnDownload.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the corrupt-on-download list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void setPatchesUnavailable(PatchList patchList, String string) {
        this.patchesUnavailable = new PatchListImpl();
        this.addPatchesUnavailable(patchList, string);
    }

    public void addPatchesUnavailable(PatchList patchList, String string) {
        int n = patchList.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.addPatchUnavailable(patchList.getPatchAt(i), string);
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.println(this, 5, "Skipping a patch with " + noSuchPatchException.getMessage());
            }
        }
    }

    public void addPatchUnavailable(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchUnavailable(iPatch);
    }

    public void addPatchUnavailable(IPatch iPatch) {
        if (this.patchesUnavailable == null) {
            this.patchesUnavailable = new PatchListImpl();
        }
        this.patchesUnavailable.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the unavailable list.");
    }

    public void addPatchAlreadyPresent(IPatch iPatch) {
        if (this.patchesAlreadyPresent == null) {
            this.patchesAlreadyPresent = new PatchListImpl();
        }
        this.patchesAlreadyPresent.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the already present list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void addPatchAlreadyPresent(Patch patch) {
        IPatch iPatch = new IPatch(patch);
        this.addPatchAlreadyPresent(iPatch);
    }

    public void addPatchDownloaded(String string) throws MalformedPatchException {
        PatchImpl patchImpl = new PatchImpl(this.genPatchInfo, new PatchID(string));
        this.addPatchDownloaded(patchImpl);
    }

    public void addPatchDownloaded(Patch patch) {
        if (this.patchesDownloaded == null) {
            this.patchesDownloaded = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesDownloaded.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the downloaded list.");
    }

    public void addPatchCorruptOnInstall(Patch patch, String string) {
        if (this.patchesCorruptOnInstall == null) {
            this.patchesCorruptOnInstall = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.patchesCorruptOnInstall.addIPatch(iPatch);
        this.patchesDownloaded.removeIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the corrupt-on-install list. ErrString: " + string);
    }

    public void addPatchWithBadProperties(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchWithBadProperties(iPatch);
    }

    public void addPatchWithBadProperties(IPatch iPatch) {
        if (this.patchesWithBadProperties == null) {
            this.patchesWithBadProperties = new PatchListImpl();
        }
        this.patchesWithBadProperties.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the bad properties list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void addPatchFailingInstall(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchFailingInstall(iPatch);
    }

    public void addPatchFailingInstall(IPatch iPatch) {
        if (this.patchesFailingInstall == null) {
            this.patchesFailingInstall = new PatchListImpl();
        }
        this.patchesFailingInstall.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the failed install list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void addPatchInstalled(Patch patch) {
        if (this.patchesInstalled == null) {
            this.patchesInstalled = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesInstalled.addIPatch(iPatch);
        this.log.println(this, 7, "Added installed patch " + patch.getPatchID().getPatchID() + " to the installed list.");
    }

    public void addPatchSequestered(Patch patch) {
        if (this.patchesSequestered == null) {
            this.patchesSequestered = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesSequestered.addIPatch(iPatch);
        this.log.println(this, 7, "Added sequestered patch " + patch.getPatchID().getPatchID() + " to the sequestered list.");
    }

    public void addPatchDeferred(Patch patch) {
        if (this.patchesDeferred == null) {
            this.patchesDeferred = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesDeferred.addIPatch(iPatch);
        this.log.println(this, 7, "Added deferred patch " + patch.getPatchID().getPatchID() + " to the deferred list.");
    }

    public void setPatchDB(PatchDB patchDB) {
        this.db = patchDB;
    }

    public void setIgnoreStatus(boolean bl) {
        this.ignoreStatus = bl;
    }

    public File getLatestDownloadDestination() {
        return this.latestDownloadDestination;
    }

    public HostSpecificInterpreter getInterpreter() {
        return this.interpreter;
    }

    public PatchList getPatchesRequired() {
        return this.returnPatchList(this.patchesRequired);
    }

    public PatchList getPatchesCorruptOnDownload() {
        return this.returnPatchList(this.patchesCorruptOnDownload);
    }

    public PatchList getPatchesUnavailable() {
        return this.returnPatchList(this.patchesUnavailable);
    }

    public PatchList getPatchesAlreadyPresent() {
        return this.returnPatchList(this.patchesAlreadyPresent);
    }

    public PatchList getPatchesDownloaded() {
        return this.returnPatchList(this.patchesDownloaded);
    }

    public PatchList getPatchesCorruptOnInstall() {
        return this.returnPatchList(this.patchesCorruptOnInstall);
    }

    public PatchList getPatchesWithBadProperties() {
        return this.returnPatchList(this.patchesWithBadProperties);
    }

    public PatchList getPatchesFailingInstall() {
        return this.returnPatchList(this.patchesFailingInstall);
    }

    public PatchList getPatchesInstalled() {
        return this.returnPatchList(this.patchesInstalled);
    }

    public PatchList getPatchesSequestered() {
        return this.returnPatchList(this.patchesSequestered);
    }

    public PatchList getPatchesDeferred() {
        return this.returnPatchList(this.patchesDeferred);
    }

    private PatchList returnPatchList(PatchList patchList) {
        if (patchList == null) {
            return new PatchListImpl();
        }
        return patchList;
    }

    public PatchList getPatchesNotDownloaded() {
        PatchListImpl patchListImpl = new PatchListImpl();
        if (this.patchesCorruptOnDownload != null) {
            patchListImpl.merge(this.patchesCorruptOnDownload);
        }
        if (this.patchesUnavailable != null) {
            patchListImpl.merge(this.patchesUnavailable);
        }
        return patchListImpl;
    }

    public PatchList getPatchesAcquired() {
        PatchListImpl patchListImpl = new PatchListImpl();
        if (this.patchesAlreadyPresent != null) {
            patchListImpl.merge(this.patchesAlreadyPresent);
        }
        if (this.patchesDownloaded != null) {
            patchListImpl.merge(this.patchesDownloaded);
        }
        return patchListImpl;
    }

    public PatchList getPatchesNotInstalled() {
        PatchListImpl patchListImpl = new PatchListImpl();
        if (this.patchesCorruptOnInstall != null) {
            patchListImpl.merge(this.patchesCorruptOnInstall);
        }
        if (this.patchesWithBadProperties != null) {
            patchListImpl.merge(this.patchesWithBadProperties);
        }
        if (this.patchesFailingInstall != null) {
            patchListImpl.merge(this.patchesFailingInstall);
        }
        return patchListImpl;
    }

    public PatchList getPatchesAddressedInDownload() {
        PatchListImpl patchListImpl = new PatchListImpl();
        if (this.patchesCorruptOnDownload != null) {
            patchListImpl.merge(this.patchesCorruptOnDownload);
        }
        if (this.patchesUnavailable != null) {
            patchListImpl.merge(this.patchesUnavailable);
        }
        if (this.patchesAlreadyPresent != null) {
            patchListImpl.merge(this.patchesAlreadyPresent);
        }
        if (this.patchesDownloaded != null) {
            patchListImpl.merge(this.patchesDownloaded);
        }
        return patchListImpl;
    }

    public PatchList getPatchesAddressedInInstall() {
        PatchListImpl patchListImpl = new PatchListImpl();
        if (this.patchesCorruptOnInstall != null) {
            patchListImpl.merge(this.patchesCorruptOnInstall);
        }
        if (this.patchesWithBadProperties != null) {
            patchListImpl.merge(this.patchesWithBadProperties);
        }
        if (this.patchesFailingInstall != null) {
            patchListImpl.merge(this.patchesFailingInstall);
        }
        if (this.patchesInstalled != null) {
            patchListImpl.merge(this.patchesInstalled);
        }
        if (this.patchesSequestered != null) {
            patchListImpl.merge(this.patchesSequestered);
        }
        if (this.patchesDeferred != null) {
            patchListImpl.merge(this.patchesDeferred);
        }
        return patchListImpl;
    }

    public PatchProProperties getProperties() {
        return this.properties;
    }

    public PatchDBBuilder getPatchDBBuilder() {
        return this.dbBuilder;
    }

    public PatchDB getPatchDB() {
        return this.db;
    }

    public boolean getIgnoreStatus() {
        return this.ignoreStatus;
    }

    public Collection getPatchProExceptions() {
        return this.exceptionRepository;
    }

    public boolean hasErrors() {
        return this.errorDetected;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.log = PatchProLog.getInstance();
            this.propertiesAreDefault = true;
            this.createProperties();
            this.createPatchDBBuilder();
            if (this.host != null) {
                this.createInterpreter();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

