/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.patchpro.util.LocalizedMessages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;

public class PatchProRuntimeException
extends RuntimeException
implements Serializable {
    int severity;
    transient LocalizedMessages msgcat;
    String key;
    String remedy;
    Throwable cause;
    public static final int EMERGENCY = 0;
    public static final int ALERT = 1;
    public static final int CRITICAL = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int NOTICE = 5;
    public static final int INFO = 6;
    public static final int DEBUG = 7;

    public PatchProRuntimeException(String string) {
        this("", string, "", 7);
    }

    public PatchProRuntimeException(Throwable throwable) {
        this("", null, "", 7, throwable);
    }

    public PatchProRuntimeException(String string, Throwable throwable) {
        this("", string, "", 7, throwable);
    }

    public PatchProRuntimeException(String string, String string2, String string3, int n) {
        this(string, string2, string3, n, null);
    }

    public PatchProRuntimeException(String string, String string2, String string3, int n, Throwable throwable) {
        super(string2 != null ? string2 : (throwable != null ? throwable.getMessage() : null));
        this.key = string;
        this.remedy = string3;
        this.severity = n;
        this.cause = throwable;
        this.msgcat = new LocalizedMessages(Locale.getDefault());
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public String getLocalizedMessage() {
        return this.msgcat.getMessage(this.getMessage(), this.getMessage());
    }

    public String getRemedy() {
        return this.remedy;
    }

    public String getLocalizedRemedy() {
        return this.msgcat.getMessage(this.remedy, this.remedy);
    }

    public int getSeverity() {
        return this.severity;
    }

    public Throwable getTargetException() {
        return this.cause;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PatchProRuntimeException)) {
            return false;
        }
        return this.getKey().compareTo(((PatchProRuntimeException)object).getKey()) == 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.msgcat = new LocalizedMessages(Locale.getDefault());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.cause != null) {
            printStream.println("Caused by:");
            this.cause.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.cause != null) {
            printWriter.println("Caused by:");
            this.cause.printStackTrace(printWriter);
        }
    }
}

