/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.interpreter.ParseError;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.SequencerEvent;
import com.sun.patchpro.model.SequencerListener;
import com.sun.patchpro.patch.IPair;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.IPatchList;
import com.sun.patchpro.patch.IncompatList;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.MissingPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchSequencer {
    private PatchProProperties properties;
    private boolean internalStatus;
    private IPatchList initialPatchList;
    private PatchListImpl finalList;
    private PatchListImpl workingList;
    private PatchListImpl existingPatches;
    private IncompatList incompatlist;
    private PatchProLog log;
    private Locale locale;
    private LocalizedMessages catalog;
    private Vector oblist;
    private HostSpecificInterpreter interpreter;
    private PatchDB patchdb;
    private float complete;
    private int nextPercent;
    private Vector listeners;
    private boolean shutdown;
    private boolean sequencerRunning;
    private boolean obsolescingPatchInstalled;
    static final int OBSO_PROC_ERR = 0;
    static final int OBSO_LOOP_ERR = 1;
    static final int REQ_PARSE_ERR = 2;
    static final int REQ_INVALID_ID = 3;
    static final int REQ_LOOP_ERR = 4;
    static final int NO_REQ_ERR = 5;
    static final int NO_PREF_ERR = 6;
    static final int PREF_PARSE_ERR = 7;
    static final int INCOMPAT_PARSE_ERR = 8;
    static final int INCOMPAT_INVALID_ID = 9;
    static final int INCOMPAT_PATCH = 10;
    static final int COUNT = 10;
    static final int SLEEP = 1000;
    String[][] errStrings = new String[][]{{"PsObsoProcErr", "-Could not find obsolescing patch"}, {"PsObsoLoopErr", "-The obsolesced field loops back to this patch"}, {"PsReqParseErr", "-Error when parsing the required field"}, {"PsReqInvalidId", "-Invalid PatchID in the required field"}, {"PsReqLoopErr", "-The required field loops back to this patch"}, {"PsNoReqErr", "-Requires a patch that could not be found"}, {"PsNoPrefErr", "-Prefers a patch that could not be found"}, {"PsPrefParseErr", "-Error when parsing the preferred field"}, {"PsIncompatParseErr", "-Error when parsing the incompatible field"}, {"PsIncompatInvalidId", "-Invalid PatchID in the incompatible field"}, {"PsIncompatPatch", "-{0} is incompatible with patch(s) {1}"}};

    public PatchSequencer(HostSpecificInterpreter hostSpecificInterpreter, PatchDB patchDB, Locale locale) {
        this.interpreter = hostSpecificInterpreter;
        this.patchdb = patchDB;
        this.locale = locale;
        this.properties = PatchProProperties.getInstance();
        this.internalStatus = this.properties.getProperty("patchpro.internal.statustags", "false").compareTo("true") == 0;
        this.log = PatchProLog.getInstance();
        this.catalog = locale != null ? new LocalizedMessages(locale) : new LocalizedMessages(Locale.ENGLISH);
        this.listeners = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPatchList getPatchListFromRealizations(Enumeration enumeration) {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        object = new IPatchList();
        PatchImpl patchImpl = null;
        IPatch iPatch = null;
        IPatch iPatch2 = null;
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        float f = 100.0f / (float)vector.size();
        this.complete = 0.0f;
        this.nextPercent = 0;
        this.log.println(this, 7, "PatchSequencer.getPatchListFromRealizations(): Realization list is " + enumeration);
        for (int i = 0; i < vector.size(); ++i) {
            Enumeration enumeration2;
            this.progressUpdate();
            this.complete += f;
            Object e = vector.elementAt(i);
            if (!(e instanceof Realization)) continue;
            Realization realization = (Realization)e;
            try {
                enumeration2 = this.patchdb.getPatches(realization);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                continue;
            }
            while (enumeration2.hasMoreElements()) {
                boolean bl = false;
                e = enumeration2.nextElement();
                if (!(e instanceof PatchImpl)) continue;
                patchImpl = (PatchImpl)e;
                String string = patchImpl.getPatchInfo().getConstraint();
                if (string != null && string.compareTo("") != 0 && string.indexOf("(") != -1) {
                    try {
                        if (this.interpreter.getExitCode(string) != 0) {
                            bl = true;
                        }
                    }
                    catch (ParseError parseError) {
                        this.log.println(this, 4, "PatchSequencer.getPatchListFromRealizations(): Patch " + patchImpl.getPatchID().getPatchID() + " contains a malformed constraint " + "expression.");
                        this.log.printStackTrace(this, 4, parseError);
                    }
                }
                if (bl) continue;
                this.log.println(this, 7, "PatchSequencer.getPatchListFromRealizations():  Adding Patch " + patchImpl.getPatchID().getPatchID() + " to the patchlist to be returned.");
                iPatch2 = ((IPatchList)object).getIPatchByIDString(patchImpl.getPatchID().getPatchID());
                if (iPatch2 == null) {
                    iPatch = new IPatch(patchImpl, 2002);
                    iPatch.addRealization(realization);
                    ((IPatchList)object).addIPatch(iPatch);
                    continue;
                }
                iPatch = iPatch2;
                iPatch.addRealization(realization);
            }
        }
        return object;
    }

    public PatchListImpl getPatchList(Enumeration enumeration) {
        return this.getPatchList(enumeration, new PatchListImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchListImpl getPatchList(Enumeration enumeration, PatchListImpl patchListImpl) {
        if (enumeration == null) {
            this.sendDoneEvent();
            PatchSequencer patchSequencer = this;
            synchronized (patchSequencer) {
                this.sequencerRunning = false;
            }
            return new PatchListImpl();
        }
        return this.getPatchList(this.getPatchListFromRealizations(enumeration), patchListImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchListImpl getPatchList(IPatchList iPatchList, PatchListImpl patchListImpl) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            this.sequencerRunning = true;
        }
        if (this.interpreter == null || this.patchdb == null) {
            this.sendDoneEvent();
            patchSequencer = this;
            synchronized (patchSequencer) {
                this.sequencerRunning = false;
            }
        }
        try {
            this.finalList = this.evaluatePatchList(iPatchList, patchListImpl);
        }
        catch (Error error) {
            PatchSequencer patchSequencer2 = this;
            synchronized (patchSequencer2) {
                this.sequencerRunning = false;
                if (!this.shutdown) {
                    throw error;
                }
                this.shutdown = false;
                this.log.println(this, 6, "Sequencer shut down.");
            }
        }
        return this.finalList;
    }

    private PatchListImpl evaluatePatchList(IPatchList iPatchList, PatchListImpl patchListImpl) {
        this.finalList = new PatchListImpl();
        this.existingPatches = patchListImpl;
        this.initialPatchList = iPatchList;
        this.workingList = new PatchListImpl();
        this.incompatlist = new IncompatList();
        IPatch iPatch = null;
        PatchID patchID = null;
        Object var5_5 = null;
        boolean bl = true;
        boolean bl2 = true;
        this.obsolescingPatchInstalled = false;
        while (this.initialPatchList.size() != 0) {
            iPatch = this.initialPatchList.getIPatchAt(0);
            iPatch.setRequired();
            patchID = iPatch.getPatchID();
            this.log.println(this, 7, "PatchSequencer.evaluatePatchList(): The patch being processed in the initialPatchList is " + patchID.getPatchID());
            bl = this.removeExistingPatch(patchID);
            if (bl) {
                this.log.println(this, 7, "PatchSequencer.evaluatePatchList(): Patch is installed on the system.");
                this.initialPatchList.removeIPatch(iPatch);
                continue;
            }
            bl2 = this.removeObsoletedPatch(patchID);
            if (bl2) {
                this.log.println(this, 7, "PatchSequencer.evaluatePatchList(): Patch is obsoleted by a patch on the system.");
                this.initialPatchList.removeIPatch(iPatch);
                continue;
            }
            this.processPatch(iPatch);
        }
        this.markIncompats();
        return this.finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchListImpl augmentPatchList(PatchID[] patchIDArray, PatchListImpl patchListImpl) {
        Object object = this;
        synchronized (object) {
            this.sequencerRunning = true;
        }
        if (this.interpreter == null || this.patchdb == null || patchIDArray == null) {
            this.sendDoneEvent();
            object = this;
            synchronized (object) {
                this.sequencerRunning = false;
            }
        }
        object = new PatchListImpl();
        try {
            boolean bl = false;
            boolean bl2 = false;
            PatchImpl patchImpl = null;
            PatchID patchID = null;
            for (int i = 0; i < patchIDArray.length; ++i) {
                try {
                    patchImpl = this.patchdb.getLatestPatch(patchIDArray[i]);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    patchImpl = new PatchImpl(patchIDArray[i]);
                }
                ((IPatchList)object).addIPatch(new IPatch(patchImpl));
                object = this.evaluatePatchList((IPatchList)object, patchListImpl);
                if (!this.internalStatus) continue;
                patchID = new IPatch(patchImpl).getPatchID();
                System.out.println("STATUS PATCH_SEQUENCER BEGIN " + patchID.getPatchID());
                patchID = new IPatch(patchImpl).getPatchID();
                bl = this.removeExistingPatch(patchID);
                if (bl) {
                    System.out.println("STATUS PATCH_SEQUENCER END " + patchID.getPatchID() + " " + "PATCH_SEQUENCER.1" + " \"" + this.catalog.getMessage("tagstatusmsg.PATCH_SEQUENCER_CODE_EXISTS", "Update {0} is already installed on the system.") + "\" \"" + patchID.getPatchID() + "\"");
                } else {
                    bl2 = this.removeObsoletedPatch(patchID);
                    if (bl2) {
                        System.out.println("STATUS PATCH_SEQUENCER END " + patchID.getPatchID() + " " + "PATCH_SEQUENCER.2" + " \"" + this.catalog.getMessage("tagstatusmsg.PATCH_SEQUENCER_CODE_OBSOLETED", "Update {0} is obsoleted by another update on the system.") + "\" \"" + patchID.getPatchID() + "\"");
                    }
                }
                if (bl || bl2) continue;
                System.out.println("STATUS PATCH_SEQUENCER END " + patchID.getPatchID() + " " + "PATCH_SEQUENCER.0" + " \"" + this.catalog.getMessage("tagstatusmsg.PATCH_SEQUENCER_CODE_SUCCESS", "Update {0} passed sequencer check.") + "\" \"" + patchID.getPatchID() + "\"");
            }
        }
        catch (Error error) {
            PatchSequencer patchSequencer = this;
            synchronized (patchSequencer) {
                this.sequencerRunning = false;
                if (!this.shutdown) {
                    throw error;
                }
                this.shutdown = false;
                this.log.println(this, 6, "Sequencer shut down.");
            }
        }
        this.sendDoneEvent();
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            this.sequencerRunning = false;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.sequencerRunning) {
                this.log.println(this, 6, "Shutting down sequencer.");
                this.shutdown = true;
                new InnerCancelThread().start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExistingPatches(PatchListImpl patchListImpl) {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        int n = 0;
        while ((object = patchListImpl.getPatchImplAt(n)) != null) {
            PatchImpl patchImpl;
            int n2 = 0;
            while ((patchImpl = this.finalList.getPatchImplAt(n2)) != null) {
                if (patchImpl.isEquivalentTo((Patch)object)) {
                    this.finalList.removeIPatch(new IPatch(patchImpl));
                }
                ++n2;
            }
            ++n;
        }
    }

    public void markIncompats() {
        if (this.incompatlist.size() == 0) {
            return;
        }
        for (int i = 0; i < this.finalList.size(); ++i) {
            IPatch iPatch = this.finalList.getIPatchAt(i);
            Enumeration enumeration = this.incompatlist.getIncompatPatchIDs(iPatch.getPatchID());
            StringBuffer stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                PatchID patchID = (PatchID)enumeration.nextElement();
                if (this.finalList.getIPatchByID(patchID) == null) continue;
                stringBuffer.append(patchID.getPatchID() + " ");
            }
            if (new String(stringBuffer).compareTo("") == 0) continue;
            iPatch.setError(this.catalog.getMessage(this.errStrings[10][0], new String[]{iPatch.getPatchID().getPatchID(), stringBuffer.toString()}, this.errStrings[10][1]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPatch(IPatch iPatch) {
        IPatch iPatch2;
        PatchID patchID;
        int n;
        String[] stringArray;
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        patchSequencer = null;
        boolean bl = true;
        this.obsolescingPatchInstalled = false;
        if (iPatch == null) {
            return;
        }
        bl = this.removeExistingPatch(iPatch.getPatchID());
        if (bl) {
            this.log.println(this, 7, "PatchSequencer.processPatch(): Patch " + iPatch.getPatchID().getPatchID() + " is " + "installed on the system.");
            this.initialPatchList.removeIPatch(iPatch);
            return;
        }
        this.log.println(this, 7, "PatchSequencer.processPatch(): Patch " + iPatch.getPatchID().getPatchID() + " is not " + "installed on the system.");
        int n2 = iPatch.getState();
        IPatch iPatch3 = null;
        IPatch iPatch4 = null;
        try {
            iPatch3 = this.getObsolescingIPatch(iPatch);
            this.clearCircularObsolescence();
        }
        catch (MissingPatchException missingPatchException) {
            this.log.println(this, 4, "PatchSequencer: Obsolesce processing failed for patch " + iPatch.getPatchID().getPatchID() + "Exception " + missingPatchException.getMessage());
            this.markSingleError(iPatch, this.getLocaleMessage(0, new Object[]{iPatch.getPatchID().getPatchID()}));
            this.finalizePatch(iPatch);
            return;
        }
        catch (NoSuchPatchException noSuchPatchException) {
            iPatch3 = iPatch;
        }
        if (this.obsolescingPatchInstalled) {
            return;
        }
        iPatch3.setState(n2);
        iPatch4 = this.workingList.getIPatchByID(iPatch3.getPatchID());
        if (iPatch4 != null) {
            if (!iPatch4.hasError()) {
                this.markLoopError(iPatch3);
            }
            this.finalizePatch(iPatch3);
            return;
        }
        IPatch iPatch5 = this.finalList.getIPatchByID(iPatch3.getPatchID());
        if (iPatch5 != null) {
            iPatch5.setState(n2);
            return;
        }
        this.workingList.addIPatch(iPatch3);
        try {
            stringArray = this.getPatchStringsFromExpression(iPatch3.getPatchInfo().getRequires());
            try {
                n = 0;
                patchID = null;
                while (stringArray != null) {
                    try {
                        patchID = new PatchID(stringArray[n]);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.log.println(this, 4, "PatchSequencer: A required patch was found to be incorrectly formed " + malformedPatchException.getMessage());
                        this.markSingleError(iPatch3, this.getLocaleMessage(5));
                    }
                    bl = this.removeExistingPatch(patchID);
                    if (bl) {
                        ++n;
                        this.log.println(this, 7, "PatchSequencer.processPatch(): required patch is installed on the system.");
                        continue;
                    }
                    try {
                        iPatch2 = this.getIPatchFromDB(patchID);
                        iPatch2.setState(n2);
                        this.processPatch(iPatch2);
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 4, "PatchSequencer: A required patch could not be found " + stringArray[n] + "Exception " + noSuchPatchException.getMessage());
                        this.markSingleError(iPatch3, this.getLocaleMessage(5));
                    }
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
        }
        catch (ParseError parseError) {
            this.markSingleError(iPatch3, this.getLocaleMessage(2));
            this.finalizePatch(iPatch3);
            return;
        }
        try {
            stringArray = this.getPatchStringsFromExpression(iPatch3.getPatchInfo().getPrefers());
            try {
                n = 0;
                patchID = null;
                while (stringArray != null) {
                    try {
                        patchID = new PatchID(stringArray[n]);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.log.println(this, 4, "PatchSequencer: A required patch was found to be incorrectly formed " + malformedPatchException.getMessage());
                        this.markSingleError(iPatch3, this.getLocaleMessage(6));
                    }
                    bl = this.removeExistingPatch(patchID);
                    if (bl) {
                        ++n;
                        this.log.println(this, 7, "PatchSequencer.processPatch(): preferred patch is installed on the system.");
                        continue;
                    }
                    try {
                        iPatch2 = this.getIPatchFromDB(patchID);
                        iPatch2.setState(2001);
                        this.processPatch(iPatch2);
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 4, "PatchSequencer: A preferred patch could not be found " + stringArray[n] + "Exception " + noSuchPatchException.getMessage());
                        this.markSingleError(iPatch3, this.getLocaleMessage(6));
                    }
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
        }
        catch (ParseError parseError) {
            this.markSingleError(iPatch3, this.getLocaleMessage(2));
            this.finalizePatch(iPatch3);
            return;
        }
        this.processIncompat(iPatch3);
        this.finalizePatch(iPatch3);
    }

    public Enumeration getIPatchesFromString(String string) throws ParseError, NoSuchPatchException, MalformedPatchException {
        Vector<IPatch> vector = new Vector<IPatch>();
        String[] stringArray = this.getPatchStringsFromExpression(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(this.getIPatchFromDB(new PatchID(stringArray[i])));
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPatch getObsolescingIPatch(IPatch iPatch) throws MissingPatchException, NoSuchPatchException {
        IPatch iPatch2;
        boolean bl = true;
        this.log.println(this, 7, "PatchSequencer.getObsolescingIPatch(): Entered getObsolescingIPatch().");
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (!iPatch.getPatchInfo().getProperties().isObsolete()) {
            return iPatch;
        }
        this.log.println(this, 7, "PatchSequencer.getObsolescingIPatch(): The patch " + iPatch.getPatchID().getPatchID() + " is obsolete.");
        PatchID patchID = iPatch.getPatchInfo().getObsolescedBy();
        this.log.println(this, 7, "PatchSequencer.getObsolescingIPatch(): The patch " + iPatch.getPatchID().getPatchID() + "is obsolesced by " + patchID.getPatchID());
        bl = this.removeExistingPatch(patchID);
        if (bl) {
            this.log.println(this, 7, "PatchSequencer.getObsolescingIPatch(): Obsolecing patch is installed on the system.");
            this.obsolescingPatchInstalled = true;
            this.initialPatchList.removeIPatch(iPatch);
            return iPatch;
        }
        try {
            iPatch2 = this.getIPatchFromDB(patchID);
        }
        catch (NoSuchPatchException noSuchPatchException) {
            throw new MissingPatchException("PatchSequencer.getObsolescingIPatch(): Missing obsolescing patch.");
        }
        this.finalizeObsoletePatch(iPatch);
        if (this.checkForCircularObsolescence(iPatch2)) {
            this.markObsolescenceLoopError(iPatch);
            return iPatch;
        }
        try {
            return this.getObsolescingIPatch(iPatch2);
        }
        catch (NoSuchPatchException noSuchPatchException) {
            return iPatch2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCircularObsolescence() {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        this.oblist = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForCircularObsolescence(IPatch iPatch) {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (this.oblist == null) {
            this.oblist = new Vector();
            if (this.oblist != null) {
                this.oblist.addElement(iPatch);
            }
            return false;
        }
        object = this.oblist.elements();
        String string = iPatch.getPatchID().getPatchID();
        while (object.hasMoreElements()) {
            IPatch iPatch2 = (IPatch)object.nextElement();
            if (string.compareTo(iPatch2.getPatchID().getPatchID()) != 0) continue;
            return true;
        }
        this.oblist.addElement(iPatch);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markObsolescenceLoopError(IPatch iPatch) {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        this.markSingleError(iPatch, this.getLocaleMessage(1) + " " + iPatch.getPatchID().getPatchID());
        boolean bl = false;
        String string = iPatch.getPatchID().getPatchID();
        Enumeration enumeration = this.oblist.elements();
        while (enumeration.hasMoreElements()) {
            object = (IPatch)enumeration.nextElement();
            this.markSingleError((IPatch)object, this.getLocaleMessage(1) + " " + string);
            this.log.println(this, 4, "PatchSequencer: Oboslesce loop includes patch " + ((PatchImpl)object).getPatchID().getPatchID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPatch getIPatchFromDB(PatchID patchID) throws NoSuchPatchException {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (patchID == null) {
            return null;
        }
        PatchImpl patchImpl = this.patchdb.getLatestPatch(patchID);
        if (patchImpl == null) {
            this.log.println(this, 4, "PatchSequencer: Database returned null patch and no exception");
            throw new NoSuchPatchException("got null patch from database");
        }
        return new IPatch(patchImpl);
    }

    public void processIncompat(IPatch iPatch) {
        String[] stringArray = null;
        try {
            stringArray = this.getPatchStringsFromExpression(iPatch.getPatchInfo().getIncompat());
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                PatchID patchID;
                try {
                    patchID = new PatchID(stringArray[i]);
                }
                catch (MalformedPatchException malformedPatchException) {
                    this.markSingleError(iPatch, this.getLocaleMessage(9));
                    continue;
                }
                this.incompatlist.add(new IPair(iPatch.getPatchID(), patchID));
            }
        }
        catch (ParseError parseError) {
            this.markSingleError(iPatch, this.getLocaleMessage(8));
        }
    }

    public void processPreferred(IPatch iPatch) {
        String[] stringArray = null;
        try {
            stringArray = this.getPatchStringsFromExpression(iPatch.getPatchInfo().getPrefers());
        }
        catch (ParseError parseError) {
            this.markSingleError(iPatch, this.getLocaleMessage(7));
            return;
        }
        if (stringArray == null) {
            this.finalizePatch(iPatch);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            IPatch iPatch2;
            PatchID patchID;
            try {
                patchID = new PatchID(stringArray[i]);
            }
            catch (MalformedPatchException malformedPatchException) {
                this.markSingleError(iPatch, this.getLocaleMessage(3));
                continue;
            }
            try {
                iPatch2 = this.getIPatchFromDB(patchID);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.markSingleError(iPatch, this.getLocaleMessage(5));
                continue;
            }
            iPatch2.setState(2001);
            this.processPatch(iPatch2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getPatchStringsFromExpression(String string) throws ParseError {
        String[] stringArray = this;
        synchronized (this) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (string == null || string.compareTo("") == 0) {
                return null;
            }
            stringArray = null;
            if (string.indexOf("(") != -1) {
                stringArray = this.interpreter.getPatchList(string);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken();
                }
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeObsoletePatch(IPatch iPatch) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (this.initialPatchList != null && iPatch != null) {
            this.initialPatchList.removeIPatch(iPatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizePatch(IPatch iPatch) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (this.finalList == null || this.initialPatchList == null || iPatch == null) {
            return;
        }
        this.initialPatchList.removeIPatch(iPatch);
        this.workingList.removeIPatch(iPatch);
        this.log.println(this, 7, "PatchSequencer.finalizePatch(): The patch added to the finalList to be returned is " + iPatch.getPatchID().getPatchID());
        this.finalList.addIPatch(iPatch);
    }

    public String getLocaleMessage(int n) {
        return this.getLocaleMessage(n, null);
    }

    public String getLocaleMessage(int n, Object[] objectArray) {
        if (n >= 0 && n < this.errStrings.length) {
            if (objectArray == null || objectArray.length == 0) {
                return this.catalog.getMessage(this.errStrings[n][0], this.errStrings[n][1]);
            }
            return this.catalog.getMessage(this.errStrings[n][0], objectArray, this.errStrings[n][1]);
        }
        this.log.println(this, 4, "PatchSequencer: Invalid error identifier used in call to getLocaleMessage " + n);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markSingleError(IPatch iPatch, String string) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        iPatch.setError(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markLoopError(IPatch iPatch) {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        this.markSingleError(iPatch, this.getLocaleMessage(4) + " " + iPatch.getPatchID().getPatchID());
        boolean bl = false;
        String string = iPatch.getPatchID().getPatchID();
        for (int i = 0; i < this.workingList.size(); ++i) {
            object = this.workingList.getIPatchAt(i);
            if (!bl) {
                if (string.compareTo(((PatchImpl)object).getPatchID().getPatchID()) != 0) continue;
                bl = true;
                continue;
            }
            this.markSingleError((IPatch)object, this.getLocaleMessage(4) + " " + iPatch.getPatchID().getPatchID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeObsoletedPatch(PatchID patchID) {
        boolean bl = true;
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        String string = patchID.getPatchID();
        String string2 = patchID.getBasecode().trim();
        this.log.println(this, 7, "PatchSequencer.removeObsoletedPatch(): The current patch is " + string);
        int n = 0;
        while ((object = this.existingPatches.getPatchImplAt(n)) != null) {
            block11: {
                String string3 = ((PatchImpl)object).getPatchInfo().getObsoletes();
                this.log.println(this, 7, "PatchSequencer.removeObsoletedPatch(): The existing patch is " + ((PatchImpl)object).getPatchID().getPatchID());
                this.log.println(this, 7, "PatchSequencer.removeObsoletedPatch(): The existing patch obsoletes list is " + string3);
                this.log.println(this, 7, "PatchSequencer.removeObsoletedPatch(): The existing patch os is " + ((PatchImpl)object).getPatchInfo().getOS());
                String[] stringArray = null;
                try {
                    stringArray = this.getPatchStringsFromExpression(string3);
                }
                catch (ParseError parseError) {
                    break block11;
                }
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        PatchID patchID2;
                        try {
                            patchID2 = new PatchID(stringArray[i]);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            continue;
                        }
                        String string4 = patchID2.getBasecode().trim();
                        String string5 = patchID2.getPatchID();
                        this.log.println(this, 7, "PatchSequencer.removeObsoletedPatch(): The existing patch obsoletes is " + string5);
                        if (!string4.equals(string2) || string5.compareTo(string) < 0) continue;
                        this.log.println(this, 7, "PatchSequencer.removeObsoletedPatch(): isObsoleted");
                        return bl;
                    }
                }
            }
            ++n;
        }
        bl = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeExistingPatch(PatchID patchID) {
        boolean bl = true;
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        String string = patchID.getPatchID();
        String string2 = patchID.getBasecode().trim();
        int n = 0;
        while ((object = this.existingPatches.getPatchImplAt(n)) != null) {
            String string3 = ((PatchImpl)object).getPatchID().getPatchID();
            String string4 = ((PatchImpl)object).getPatchID().getBasecode().trim();
            if (string4.equals(string2) && string3.compareTo(string) >= 0) {
                this.log.println(this, 7, "Installed patch " + string3 + " is >= to current patch " + string);
                return bl;
            }
            ++n;
        }
        bl = false;
        return bl;
    }

    public void setInterpreter(HostSpecificInterpreter hostSpecificInterpreter) {
        this.interpreter = hostSpecificInterpreter;
    }

    public void setPatchDB(PatchDB patchDB) {
        this.patchdb = patchDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequencerListener(SequencerListener sequencerListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(sequencerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSequencerListener(SequencerListener sequencerListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(sequencerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void progressUpdate() {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (this.complete > (float)this.nextPercent) {
            this.nextPercent += 5;
            object = this.listeners;
            synchronized (object) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    SequencerListener sequencerListener = (SequencerListener)this.listeners.elementAt(i);
                    sequencerListener.sequencerProgress(new SequencerEvent(this, this.catalog.getMessage("progress.message.analyzing", "Analyzing system")));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDoneEvent() {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        object = this.listeners;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                SequencerListener sequencerListener = (SequencerListener)this.listeners.elementAt(i);
                sequencerListener.sequencerDone(new SequencerEvent(this));
            }
        }
    }

    public Percentage getStatus() {
        try {
            return new Percentage((int)this.complete);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "Sequencer progress out of range.  " + this.complete);
            if (this.complete > 100.0f) {
                return new Percentage(100);
            }
            return new Percentage(0);
        }
    }

    private class InnerCancelThread
    extends Thread {
        private InnerCancelThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            for (int i = 0; i < 10; ++i) {
                PatchSequencer patchSequencer = PatchSequencer.this;
                synchronized (patchSequencer) {
                    if (!PatchSequencer.this.sequencerRunning) {
                        break;
                    }
                }
                try {
                    InnerCancelThread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    PatchSequencer.this.log.println(this, 4, "Sequencer cancel thread interrupted.");
                }
            }
            PatchSequencer patchSequencer = PatchSequencer.this;
            synchronized (patchSequencer) {
                if (PatchSequencer.this.sequencerRunning) {
                    PatchSequencer.this.log.println(this, 2, "Sequencer doesn't want to exit.");
                } else {
                    PatchSequencer.this.log.println(this, 6, "Sequencer has been shut down.");
                }
            }
        }
    }
}

