/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.InteractiveSessionConsole;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.InteractiveSessionPrtl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class CommandSession
extends InteractiveSessionPrtl {
    private static final int INPUTBUFFERSIZE = 64000;
    private Runtime runtime = null;
    private Process process = null;
    InteractiveSessionConsole interactiveSessionConsole = null;
    PatchProLog log = PatchProLog.getInstance();
    int returnValue = -9999;

    public void start(String string) throws InteractiveSessionException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            this.log.println(this, 7, "Command to execute: \"" + stringArray.toString() + "\"");
            this.runtime = Runtime.getRuntime();
            this.process = this.runtime.exec(stringArray);
            this.setStdInputReader(new BufferedReader(new InputStreamReader(this.process.getInputStream()), 64000));
            this.setStdErrorReader(new BufferedReader(new InputStreamReader(this.process.getErrorStream()), 64000));
            this.setOutPutStreamWriter(new OutputStreamWriter(this.process.getOutputStream()));
            this.setArrayOutputStream(new ByteArrayOutputStream());
            this.setSessionArrayOutputStream(new ByteArrayOutputStream());
            this.interactiveSessionConsole = new InteractiveSessionConsole(this);
            this.interactiveSessionConsole.start();
            this.waitfor(5000);
        }
        catch (IOException iOException) {
            this.cleanup();
            this.log.printStackTrace(this, 2, iOException);
            throw new InteractiveSessionException(iOException.getMessage());
        }
        catch (Exception exception) {
            this.cleanup();
            this.log.printStackTrace(this, 2, exception);
            throw new InteractiveSessionException(exception.getMessage());
        }
    }

    public void cleanup() {
        this.setTerminateStatus();
        if (this.interactiveSessionConsole != null) {
            try {
                this.interactiveSessionConsole.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.process != null) {
            this.stop();
        }
        this.closeStdInputReader();
        this.closeStdErrorReader();
        this.closeOutPutStreamWriter();
        if (this.runtime != null) {
            this.runtime.gc();
        }
        System.gc();
    }

    public void stop() {
        if (this.process != null) {
            try {
                Thread.sleep(5000L);
                this.process.destroy();
                this.setReturnValue(this.process.exitValue());
                this.process = null;
            }
            catch (Exception exception) {
                this.process = null;
                System.gc();
                this.setReturnValue(-9999);
            }
        }
    }

    private void setReturnValue(int n) {
        this.returnValue = n;
    }

    public int getReturnValue() {
        return this.returnValue;
    }
}

