/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.FailedStateEvent;
import com.sun.patchpro.util.FailedStateException;
import com.sun.patchpro.util.FailedStateListener;
import com.sun.patchpro.util.InvalidStartingStateException;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.MalformedStateException;
import com.sun.patchpro.util.NextStateEvent;
import com.sun.patchpro.util.NextStateListener;
import com.sun.patchpro.util.NoSuchStateException;
import com.sun.patchpro.util.State;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Stack;

public abstract class StateMachine
implements NextStateListener,
FailedStateListener {
    public PatchProLog log;
    private LocalizedMessages msgcat;
    private PatchProProperties properties;
    private boolean stateTableIsValid = false;
    private int intermediateEndState = -1;
    private int currentStateNo = -1;
    private Enumeration nextStateEnumeration = null;
    protected int[] nextStateArray;
    protected State[] stateTable = null;
    private Stack nextStateEvents = new Stack();
    private Stack failedStateEvents = new Stack();
    private boolean running = false;

    public StateMachine() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
    }

    protected State[] buildStateTable() {
        State[] stateArray = new State[]{};
        return stateArray;
    }

    public void initialize() {
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        for (int i = 0; i < this.stateTable.length; ++i) {
            this.stateTable[i].initialize();
        }
    }

    private synchronized void setRunning() {
        if (this.running) {
            this.log.println(this, 7, "setRunning(): Failed. Already running.");
            new Exception().printStackTrace();
            throw new InvalidStartingStateException("StateMachine.start(): No start is possible. Machine is running.");
        }
        this.running = true;
        this.log.println(this, 7, "setRunning()");
    }

    private synchronized void setDone() {
        this.running = false;
        this.log.println(this, 7, "setDone()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws PatchProException {
        this.setRunning();
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        this.initialize();
        try {
            this.start(true, 0);
        }
        finally {
            this.setDone();
        }
    }

    public void start(int n, int n2) throws PatchProException {
        this.start(false, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(boolean bl, int n, int n2) throws PatchProException {
        if (!bl) {
            this.setRunning();
        }
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        if (n2 >= this.stateTable.length) {
            throw new MalformedStateException("StateMachine.start(): Specified end state is not in the state table.");
        }
        this.intermediateEndState = n2;
        try {
            this.start(true, n);
        }
        finally {
            this.intermediateEndState = -1;
            this.setDone();
        }
    }

    public void start(int n) throws PatchProException {
        this.start(false, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void start(boolean bl, int n) throws PatchProException {
        try {
            boolean bl2;
            if (!bl) {
                this.setRunning();
            }
            this.log.println(this, 7, "start(...) w/ start state = " + n + " and end state = " + this.intermediateEndState + ".");
            State state = null;
            boolean bl3 = false;
            if (!this.stateTableIsValid) {
                this.stateTable = this.buildStateTable();
                this.stateTableIsValid = true;
            }
            try {
                bl2 = this.stateTable[n].isEntryPoint();
            }
            catch (Exception exception) {
                throw new MalformedStateException("StateMachine.start(): Specified start state is not in the state table.");
            }
            if (!bl2) {
                throw new InvalidStartingStateException("StateMachine.start(): Invalid starting state.");
            }
            this.nextStateArray = new int[]{n};
            try {
                while (true) {
                    Serializable serializable;
                    State state2;
                    if (bl3) {
                        this.log.println(this, 7, "StateMachine is officially done.");
                        return;
                    }
                    Thread thread = null;
                    for (int i = 0; i < this.nextStateArray.length; ++i) {
                        this.currentStateNo = this.nextStateArray[i];
                        State state3 = this.stateTable[this.currentStateNo];
                        this.log.println(this, 7, "Starting " + this.currentStateNo + " with state state " + state3.getStateState());
                        if (state3.reserveState()) {
                            state3.addNextStateListener(this);
                            state3.addFailedStateListener(this);
                            state3.setStateNumber(this.currentStateNo);
                            thread = new Thread(state3);
                            thread.start();
                            this.log.println(this, 7, "StateMachine: Started state " + this.currentStateNo);
                            continue;
                        }
                        if (!state3.isSynchronized()) {
                            this.log.println(this, 4, "StateMachine.run: State " + state3.getStateNumber() + " was invoked a second time but it" + " is not synchronized.");
                            throw new FailedStateException("Reentering unsynchronized state " + state3.getStateNumber());
                        }
                        this.log.println(this, 7, "StateMachine.run: State " + state3.getStateNumber() + " is synchronized.");
                    }
                    this.nextStateArray = new int[0];
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (state != null) {
                        state.setNextStateProcessed(true);
                        state = null;
                    }
                    if (!this.failedStateEvents.empty()) {
                        FailedStateEvent failedStateEvent = (FailedStateEvent)this.failedStateEvents.pop();
                        state2 = (State)failedStateEvent.getSource();
                        serializable = state2.getThrowable();
                        if (serializable instanceof RuntimeException) {
                            throw (RuntimeException)serializable;
                        }
                        if (serializable instanceof Error) {
                            throw (Error)serializable;
                        }
                        if (serializable instanceof PatchProException) {
                            throw (PatchProException)serializable;
                        }
                        String string = ((Throwable)serializable).toString();
                        throw new FailedStateException(this.msgcat.getMessage("statebadthrowable", new String[]{string}, "State failed with unexpected Throwable " + string + ".  Refer to the log file for " + "more details."), (Throwable)serializable);
                    }
                    int[] nArray = this.nextStateArray;
                    // MONITORENTER : this.nextStateArray
                    this.nextStateArray = new int[0];
                    if (!this.nextStateEvents.empty()) {
                        serializable = (NextStateEvent)this.nextStateEvents.pop();
                        state2 = (State)((EventObject)serializable).getSource();
                        if (!bl3) {
                            if (state2.isTerminal() || state2.getStateNumber() == this.intermediateEndState && state2.getStateState() == 2) {
                                bl3 = true;
                                this.log.println(this, 7, "reached the end state.");
                            }
                            try {
                                this.log.println(this, 7, "reading state " + state2.getStateNumber());
                                if (!state2.isTerminal()) {
                                    this.log.println(this, 7, "State " + state2.getStateNumber() + " is not terminal.");
                                    this.nextStateArray = state2.getNextState();
                                    state = state2;
                                    this.log.println(this, 7, "nextStates = ");
                                    for (int i = 0; i < this.nextStateArray.length; ++i) {
                                        this.log.println(this, 7, "  " + this.nextStateArray[i]);
                                    }
                                } else {
                                    this.log.println(this, 7, "State " + state2.getStateNumber() + " is terminal.");
                                    this.nextStateArray = new int[0];
                                }
                            }
                            catch (NoSuchStateException noSuchStateException) {
                                this.log.printStackTrace(this, 4, noSuchStateException);
                                this.log.println(this, 4, "StateMachine.run: State " + state2.getStateNumber() + " indicated a next state but" + " could not produce one.");
                                this.nextStateArray = new int[0];
                            }
                        } else {
                            this.log.println(this, 4, "StateMachine.run: State " + state2.getStateNumber() + " indicated a next state but the" + " terminal state has completed.");
                            this.nextStateArray = new int[0];
                        }
                    }
                    // MONITOREXIT : nArray
                }
            }
            catch (Error error) {
                String string = new String("StateMachine.start(): " + error.getMessage());
                this.log.printStackTrace(this, 4, error);
                throw new FailedStateException(string);
            }
        }
        finally {
            if (!bl) {
                this.setDone();
            }
        }
    }

    public Object getActionResult(int n) {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].getActionResult();
    }

    public boolean isNextStateProcessed(int n) throws NoSuchStateException {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].isNextStateProcessed();
    }

    public synchronized boolean allDone(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            try {
                if (this.isNextStateProcessed(nArray[i])) continue;
                return false;
            }
            catch (NoSuchStateException noSuchStateException) {
                this.log.println(this, 4, "StateMachine.allDone: State " + nArray[i] + " doesn't exist.");
            }
        }
        return true;
    }

    public int getStateResult(int n) throws NoSuchStateException {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].getStateState();
    }

    public synchronized void processNextState(NextStateEvent nextStateEvent) {
        this.nextStateEvents.push(nextStateEvent);
        ((State)nextStateEvent.getSource()).removeFailedStateListener(this);
        ((State)nextStateEvent.getSource()).removeNextStateListener(this);
    }

    public synchronized void processFailedState(FailedStateEvent failedStateEvent) {
        this.failedStateEvents.push(failedStateEvent);
        ((State)failedStateEvent.getSource()).removeFailedStateListener(this);
        ((State)failedStateEvent.getSource()).removeNextStateListener(this);
    }
}

