/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.ZipFileHandlerFailedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class SunOSZipFileHandler {
    PatchProLog log = PatchProLog.getInstance();

    public void extract(String string, String string2, String string3) throws ZipFileHandlerFailedException {
        File file = new File(string + "/" + string3);
        if (!file.exists()) {
            throw new ZipFileHandlerFailedException("The specified zip file does not exist.");
        }
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdir();
        }
        this.log.println(this, 7, "Unzipping: " + string + "/" + string3);
        byte[] byArray = new byte[8192];
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string + "/" + string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.printStackTrace(this, 3, fileNotFoundException);
            throw new ZipFileHandlerFailedException("The specified zip file does not exist.");
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 3, iOException);
            throw new ZipFileHandlerFailedException("The zip process terminated with an error");
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        InputStream inputStream = null;
        while (enumeration.hasMoreElements()) {
            File file3;
            File file4;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            String string4 = string2 + "/" + zipEntry.getName();
            this.log.println(this, 7, "Creating " + string4 + "...");
            try {
                file4 = new File(string4);
                file3 = file4.getParentFile();
                if (file3 != null && !file3.exists()) {
                    file3.mkdirs();
                }
                if (!file4.exists()) {
                    file4.createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                inputStream = zipFile.getInputStream(zipEntry);
                int n = 0;
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 3, iOException);
                throw new ZipFileHandlerFailedException("The zip process terminated with an error");
            }
            file3 = null;
            file4 = null;
        }
    }
}

