/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DOMOutputImpl;
import com.sun.org.apache.xerces.internal.dom.DocumentTypeImpl;
import com.sun.org.apache.xerces.internal.dom.ObjectFactory;
import com.sun.org.apache.xerces.internal.impl.RevalidationHandler;
import com.sun.org.apache.xerces.internal.parsers.DOMParserImpl;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xml.internal.serialize.DOMSerializerImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class CoreDOMImplementationImpl
implements DOMImplementation,
DOMImplementationLS {
    private static final int SIZE = 2;
    private RevalidationHandler[] validators = new RevalidationHandler[2];
    private int freeValidatorIndex = -1;
    private int currentSize = 2;
    private int docAndDoctypeCounter = 0;
    static CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();

    protected synchronized int assignDocTypeNumber() {
        return ++this.docAndDoctypeCounter;
    }

    protected synchronized int assignDocumentNumber() {
        return ++this.docAndDoctypeCounter;
    }

    final void checkQName(String qname) {
        int i;
        int index = qname.indexOf(58);
        int lastIndex = qname.lastIndexOf(58);
        int length = qname.length();
        if (index == 0 || index == length - 1 || lastIndex != index) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, msg);
        }
        int start = 0;
        if (index > 0) {
            if (!XMLChar.isNCNameStart(qname.charAt(start))) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
            i = 1;
            while (i < index) {
                if (!XMLChar.isNCName(qname.charAt(i))) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                    throw new DOMException(5, msg);
                }
                ++i;
            }
            start = index + 1;
        }
        if (!XMLChar.isNCNameStart(qname.charAt(start))) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        i = start + 1;
        while (i < length) {
            if (!XMLChar.isNCName(qname.charAt(i))) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
            ++i;
        }
    }

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public LSInput createLSInput() {
        return new DOMInputImpl();
    }

    public LSOutput createLSOutput() {
        return new DOMOutputImpl();
    }

    public LSSerializer createLSSerializer() {
        return new DOMSerializerImpl();
    }

    synchronized RevalidationHandler getValidator(String schemaType) {
        if (this.freeValidatorIndex < 0) {
            return (RevalidationHandler)ObjectFactory.newInstance("com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaValidator", ObjectFactory.findClassLoader(), true);
        }
        RevalidationHandler val = this.validators[this.freeValidatorIndex];
        this.validators[this.freeValidatorIndex--] = null;
        return val;
    }

    synchronized void releaseValidator(String schemaType, RevalidationHandler validator) {
        ++this.freeValidatorIndex;
        if (this.validators.length == this.freeValidatorIndex) {
            this.currentSize += 2;
            RevalidationHandler[] newarray = new RevalidationHandler[this.currentSize];
            System.arraycopy(this.validators, 0, newarray, 0, this.validators.length);
            this.validators = newarray;
        }
        this.validators[this.freeValidatorIndex] = validator;
    }

    public boolean hasFeature(String feature, String version) {
        boolean anyVersion;
        boolean bl = anyVersion = version == null || version.length() == 0;
        if (feature.startsWith("+")) {
            feature = feature.substring(1);
        }
        if ((feature.equalsIgnoreCase("XPath") || feature.equalsIgnoreCase("+XPath")) && (anyVersion || version.equals("3.0"))) {
            try {
                Class xpathClass = ObjectFactory.findProviderClass("com.sun.org.apache.xpath.internal.domapi.XPathEvaluatorImpl", ObjectFactory.findClassLoader(), true);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return feature.equalsIgnoreCase("Core") && (anyVersion || version.equals("1.0") || version.equals("2.0") || version.equals("3.0")) || feature.equalsIgnoreCase("XML") && (anyVersion || version.equals("1.0") || version.equals("2.0") || version.equals("3.0")) || feature.equalsIgnoreCase("LS") && (anyVersion || version.equals("3.0"));
    }

    public LSParser createLSParser(short mode, String schemaType) throws DOMException {
        if (mode != 1 || schemaType != null && !"http://www.w3.org/2001/XMLSchema".equals(schemaType) && !"http://www.w3.org/TR/REC-xml".equals(schemaType)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, msg);
        }
        if (schemaType != null && schemaType.equals("http://www.w3.org/TR/REC-xml")) {
            return new DOMParserImpl("com.sun.org.apache.xerces.internal.parsers.DTDConfiguration", schemaType);
        }
        return new DOMParserImpl("com.sun.org.apache.xerces.internal.parsers.XML11Configuration", schemaType);
    }

    public Object getFeature(String feature, String version) {
        if (singleton.hasFeature(feature, version)) {
            return singleton;
        }
        return null;
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (doctype != null && doctype.getOwnerDocument() != null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        CoreDocumentImpl doc = new CoreDocumentImpl(doctype);
        Element e = doc.createElementNS(namespaceURI, qualifiedName);
        doc.appendChild(e);
        return doc;
    }

    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) {
        this.checkQName(qualifiedName);
        return new DocumentTypeImpl(null, qualifiedName, publicID, systemID);
    }
}

