/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.dom.DOMErrorImpl;
import com.sun.org.apache.xerces.internal.dom.DOMLocatorImpl;
import com.sun.org.apache.xerces.internal.dom3.DOMError;
import com.sun.org.apache.xerces.internal.dom3.DOMErrorHandler;
import com.sun.org.apache.xerces.internal.dom3.DOMLocator;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParseException;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class DOMErrorHandlerWrapper
implements XMLErrorHandler,
DOMErrorHandler {
    protected DOMErrorHandler fDomErrorHandler;
    boolean eStatus = true;
    protected PrintWriter fOut;
    public Node fCurrentNode;
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();

    public DOMErrorHandlerWrapper() {
        this.fOut = new PrintWriter(System.err);
    }

    private void printError(DOMError error) {
        short severity = error.getSeverity();
        this.fOut.print("[");
        if (severity == 1) {
            this.fOut.print("Warning");
        } else if (severity == 2) {
            this.fOut.print("Error");
        } else {
            this.fOut.print("FatalError");
            this.eStatus = false;
        }
        this.fOut.print("] ");
        DOMLocator locator = error.getLocation();
        if (locator != null) {
            String systemId;
            this.fOut.print(locator.getLineNumber());
            this.fOut.print(":");
            this.fOut.print(locator.getColumnNumber());
            this.fOut.print(":");
            this.fOut.print(locator.getByteOffset());
            this.fOut.print(",");
            this.fOut.print(locator.getUtf16Offset());
            Node node = locator.getRelatedNode();
            if (node != null) {
                this.fOut.print("[");
                this.fOut.print(node.getNodeName());
                this.fOut.print("]");
            }
            if ((systemId = locator.getUri()) != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                this.fOut.print(": ");
                this.fOut.print(systemId);
            }
        }
        this.fOut.print(":");
        this.fOut.print(error.getMessage());
        this.fOut.println();
        this.fOut.flush();
    }

    public boolean handleError(DOMError error) {
        this.printError(error);
        return this.eStatus;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDomErrorHandler;
    }

    public DOMErrorHandlerWrapper(DOMErrorHandler domErrorHandler) {
        this.fDomErrorHandler = domErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        this.fDomErrorHandler = errorHandler;
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        this.fDOMError.fSeverity = (short)2;
        this.fDOMError.fException = exception;
        this.fDOMError.fType = key;
        this.fDOMError.fMessage = exception.getMessage();
        this.fDOMError.fRelatedData = this.fDOMError.fMessage;
        DOMLocatorImpl locator = this.fDOMError.fLocator;
        if (locator != null) {
            locator.fColumnNumber = exception.getColumnNumber();
            locator.fLineNumber = exception.getLineNumber();
            locator.fUri = exception.getExpandedSystemId();
            locator.fRelatedNode = this.fCurrentNode;
        }
        this.fDomErrorHandler.handleError(this.fDOMError);
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        this.fDOMError.fSeverity = (short)3;
        this.fDOMError.fException = exception;
        this.fDOMError.fType = key;
        this.fDOMError.fMessage = exception.getMessage();
        this.fDOMError.fRelatedData = this.fDOMError.fMessage;
        DOMLocatorImpl locator = this.fDOMError.fLocator;
        if (locator != null) {
            locator.fColumnNumber = exception.getColumnNumber();
            locator.fLineNumber = exception.getLineNumber();
            locator.fUri = exception.getExpandedSystemId();
            locator.fRelatedNode = this.fCurrentNode;
        }
        this.fDomErrorHandler.handleError(this.fDOMError);
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        this.fDOMError.fSeverity = 1;
        this.fDOMError.fException = exception;
        this.fDOMError.fType = key;
        this.fDOMError.fMessage = exception.getMessage();
        this.fDOMError.fRelatedData = this.fDOMError.fMessage;
        DOMLocatorImpl locator = this.fDOMError.fLocator;
        if (locator != null) {
            locator.fColumnNumber = exception.getColumnNumber();
            locator.fLineNumber = exception.getLineNumber();
            locator.fUri = exception.getExpandedSystemId();
            locator.fRelatedNode = this.fCurrentNode;
        }
        this.fDomErrorHandler.handleError(this.fDOMError);
    }
}

