/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class INTEGER
extends BigInteger
implements ASN1Value {
    private byte[] encodedContents = null;
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 2L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    private byte[] getEncodedContents() {
        if (this.encodedContents == null) {
            this.encodedContents = this.toByteArray();
        }
        return this.encodedContents;
    }

    private ASN1Header getHeader(Tag tag) {
        return new ASN1Header(tag, FORM, this.getContentLength());
    }

    public INTEGER(String string) throws NumberFormatException {
        super(string);
    }

    public INTEGER(String string, int n) throws NumberFormatException {
        super(string, n);
    }

    public INTEGER(byte[] byArray) throws NumberFormatException {
        super(byArray);
    }

    public INTEGER(int n, byte[] byArray) throws NumberFormatException {
        super(n, byArray);
    }

    public INTEGER(int n, Random random) throws NumberFormatException {
        super(n, random);
    }

    public INTEGER(int n, int n2, Random random) {
        super(n, n2, random);
    }

    public INTEGER(long l) {
        super(BigInteger.valueOf(l).toByteArray());
    }

    public INTEGER(BigInteger bigInteger) {
        super(bigInteger.toByteArray());
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.getHeader(tag).encode(outputStream);
        outputStream.write(this.getEncodedContents());
    }

    public long getContentLength() {
        return this.getEncodedContents().length;
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ASN1Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] stringArray) {
        try {
            int[] nArray = new int[11];
            int[][] nArrayArray = new int[11][];
            int n = 0;
            nArray[n] = 0;
            nArrayArray[n++] = new int[]{2, 1, 0};
            nArray[n] = 1;
            nArrayArray[n++] = new int[]{2, 1, 1};
            nArray[n] = -1;
            nArrayArray[n++] = new int[]{2, 1, 255};
            nArray[n] = 127;
            nArrayArray[n++] = new int[]{2, 1, 127};
            nArray[n] = 128;
            nArrayArray[n++] = new int[]{2, 2, 0, 128};
            nArray[n] = 255;
            nArrayArray[n++] = new int[]{2, 2, 0, 255};
            nArray[n] = 256;
            nArrayArray[n++] = new int[]{2, 2, 1, 0};
            nArray[n] = -128;
            nArrayArray[n++] = new int[]{2, 1, 128};
            nArray[n] = -129;
            nArrayArray[n++] = new int[]{2, 2, 255, 127};
            nArray[n] = 43568;
            nArrayArray[n++] = new int[]{2, 3, 0, 170, 48};
            nArray[n] = -43568;
            nArrayArray[n++] = new int[]{2, 3, 255, 85, 208};
            for (n = 0; n < nArray.length; ++n) {
                ByteArrayInputStream byteArrayInputStream;
                Template template;
                INTEGER iNTEGER;
                INTEGER iNTEGER2 = new INTEGER(nArray[n]);
                byte[] byArray = iNTEGER2.encode();
                if (!INTEGER.arraysEqual(byArray, nArrayArray[n])) {
                    System.err.println("Encoding FAILED: " + nArray[n]);
                    System.exit(-1);
                }
                if ((iNTEGER = (INTEGER)(template = new Template()).decode(byteArrayInputStream = new ByteArrayInputStream(byArray))).intValue() == nArray[n]) continue;
                System.err.println("Decoding FAILED: " + nArray[n]);
                System.exit(-1);
            }
            System.out.println("PASS");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean arraysEqual(byte[] byArray, int[] nArray) {
        if (byArray == null || nArray == null) {
            return false;
        }
        if (byArray.length != nArray.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == (byte)nArray[i]) continue;
            return false;
        }
        return true;
    }

    public static class Template
    implements ASN1Template {
        Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(this.getTag(), inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag, FORM);
                if (aSN1Header.getContentLength() < 1L) {
                    throw new InvalidBERException("Invalid 0 length for INTEGER");
                }
                byte[] byArray = new byte[(int)aSN1Header.getContentLength()];
                ASN1Util.readFully(byArray, inputStream);
                return new INTEGER(byArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "INTEGER");
            }
        }
    }
}

