/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.crypto.Algorithm;

public class KeyWrapAlgorithm
extends Algorithm {
    private boolean padded;
    private int blockSize;
    private static Hashtable nameMap = new Hashtable();
    private static Class[] IVParameterSpecClasses = null;
    public static final KeyWrapAlgorithm DES_ECB;
    public static final KeyWrapAlgorithm DES_CBC;
    public static final KeyWrapAlgorithm DES_CBC_PAD;
    public static final KeyWrapAlgorithm DES3_ECB;
    public static final KeyWrapAlgorithm DES3_CBC;
    public static final KeyWrapAlgorithm DES3_CBC_PAD;
    public static final KeyWrapAlgorithm RSA;
    public static final KeyWrapAlgorithm PLAINTEXT;
    public static final KeyWrapAlgorithm AES_ECB;
    public static final KeyWrapAlgorithm AES_CBC;
    public static final KeyWrapAlgorithm AES_CBC_PAD;
    public static final KeyWrapAlgorithm RC2_CBC_PAD;
    static /* synthetic */ Class class$org$mozilla$jss$crypto$IVParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;

    protected KeyWrapAlgorithm(int n, String string, Class clazz, boolean bl, int n2) {
        super(n, string, null, clazz);
        this.padded = bl;
        this.blockSize = n2;
        if (string != null) {
            nameMap.put(string.toLowerCase(), this);
        }
    }

    protected KeyWrapAlgorithm(int n, String string, Class[] classArray, boolean bl, int n2) {
        super(n, string, null, classArray);
        this.padded = bl;
        this.blockSize = n2;
        if (string != null) {
            nameMap.put(string.toLowerCase(), this);
        }
    }

    public static KeyWrapAlgorithm fromString(String string) throws NoSuchAlgorithmException {
        Object v = nameMap.get(string.toLowerCase());
        if (v == null) {
            throw new NoSuchAlgorithmException();
        }
        return (KeyWrapAlgorithm)v;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        IVParameterSpecClasses = new Class[2];
        KeyWrapAlgorithm.IVParameterSpecClasses[0] = class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = KeyWrapAlgorithm.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec;
        KeyWrapAlgorithm.IVParameterSpecClasses[1] = class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = KeyWrapAlgorithm.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec;
        DES_ECB = new KeyWrapAlgorithm(9, "DES/ECB", (Class)null, false, 8);
        DES_CBC = new KeyWrapAlgorithm(10, "DES/CBC", IVParameterSpecClasses, false, 8);
        DES_CBC_PAD = new KeyWrapAlgorithm(11, "DES/CBC/Pad", IVParameterSpecClasses, true, 8);
        DES3_ECB = new KeyWrapAlgorithm(12, "DES3/ECB", (Class)null, false, 8);
        DES3_CBC = new KeyWrapAlgorithm(13, "DES3/CBC", IVParameterSpecClasses, false, 8);
        DES3_CBC_PAD = new KeyWrapAlgorithm(14, "DES3/CBC/Pad", IVParameterSpecClasses, true, 8);
        RSA = new KeyWrapAlgorithm(4, "RSA", (Class)null, false, 0);
        PLAINTEXT = new KeyWrapAlgorithm(0, "Plaintext", (Class)null, false, 0);
        AES_ECB = new KeyWrapAlgorithm(33, "AES/ECB/NoPadding", (Class)null, false, 16);
        AES_CBC = new KeyWrapAlgorithm(34, "AES/CBC/NoPadding", IVParameterSpecClasses, false, 16);
        AES_CBC_PAD = new KeyWrapAlgorithm(35, "AES/CBC/PKCS5Padding", IVParameterSpecClasses, true, 16);
        RC2_CBC_PAD = new KeyWrapAlgorithm(36, "RC2/CBC/PKCS5Padding", class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = KeyWrapAlgorithm.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec, true, 8);
    }
}

