/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class SecretBag
implements ASN1Value {
    private OBJECT_IDENTIFIER secretType;
    private ANY secret;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OBJECT_IDENTIFIER getSecretType() {
        return this.secretType;
    }

    public ANY getSecret() {
        return this.secret;
    }

    private SecretBag() {
    }

    public SecretBag(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value) {
        if (oBJECT_IDENTIFIER == null || aSN1Value == null) {
            throw new IllegalArgumentException("SecretBag parameter is null");
        }
        this.secretType = oBJECT_IDENTIFIER;
        if (aSN1Value instanceof ANY) {
            this.secret = (ANY)aSN1Value;
        } else {
            byte[] byArray = ASN1Util.encode(aSN1Value);
            try {
                this.secret = (ANY)ASN1Util.decode(ANY.getTemplate(), byArray);
            }
            catch (InvalidBERException invalidBERException) {
                Assert.notReached("Failed to convert ASN1Value to ANY");
            }
        }
        this.sequence = new SEQUENCE();
        this.sequence.addElement(oBJECT_IDENTIFIER);
        this.sequence.addElement(new EXPLICIT(new Tag(0L), this.secret));
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(new EXPLICIT.Template(new Tag(0L), ANY.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new SecretBag((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), ((EXPLICIT)sEQUENCE.elementAt(1)).getContent());
        }
    }
}

