/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class OtherMsg
implements ASN1Value {
    private INTEGER bodyPartID;
    private OBJECT_IDENTIFIER otherMsgType;
    private ANY otherMsgValue;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public INTEGER getBodyPartID() {
        return this.bodyPartID;
    }

    public OBJECT_IDENTIFIER getOtherMsgType() {
        return this.otherMsgType;
    }

    public ANY getOtherMsgValue() {
        return this.otherMsgValue;
    }

    private OtherMsg() {
    }

    public OtherMsg(INTEGER iNTEGER, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ANY aNY) {
        if (iNTEGER == null || oBJECT_IDENTIFIER == null || aNY == null) {
            throw new IllegalArgumentException("parameter to OtherMsg constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.bodyPartID = iNTEGER;
        this.sequence.addElement(iNTEGER);
        this.otherMsgType = oBJECT_IDENTIFIER;
        this.sequence.addElement(oBJECT_IDENTIFIER);
        this.otherMsgValue = aNY;
        this.sequence.addElement(aNY);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(ANY.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new OtherMsg((INTEGER)sEQUENCE.elementAt(0), (OBJECT_IDENTIFIER)sEQUENCE.elementAt(1), (ANY)sEQUENCE.elementAt(2));
        }
    }
}

