/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmc.TaggedCertificationRequest;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.util.Assert;

public class TaggedRequest
implements ASN1Value {
    public static Type PKCS10 = Type.PKCS10;
    public static Type CRMF = Type.CRMF;
    private Type type;
    private TaggedCertificationRequest tcr;
    private CertReqMsg crm;
    private static final Template templateInstance = new Template();

    public TaggedRequest() {
    }

    public TaggedRequest(Type type, TaggedCertificationRequest taggedCertificationRequest, CertReqMsg certReqMsg) {
        this.type = type;
        this.tcr = taggedCertificationRequest;
        this.crm = certReqMsg;
    }

    public Type getType() {
        return this.type;
    }

    public TaggedCertificationRequest getTcr() {
        return this.tcr;
    }

    public CertReqMsg getCrm() {
        return this.crm;
    }

    public Tag getTag() {
        if (this.type == PKCS10) {
            return Tag.get(0L);
        }
        Assert._assert(this.type == CRMF);
        return Tag.get(1L);
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.type == PKCS10) {
            this.tcr.encode(Tag.get(0L), outputStream);
        } else {
            Assert._assert(this.type == CRMF);
            this.crm.encode(Tag.get(1L), outputStream);
        }
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.encode(outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get(0L), TaggedCertificationRequest.getTemplate());
            this.choicet.addElement(Tag.get(1L), CertReqMsg.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            CHOICE cHOICE = (CHOICE)this.choicet.decode(inputStream);
            if (cHOICE.getTag().equals(Tag.get(0L))) {
                return new TaggedRequest(PKCS10, (TaggedCertificationRequest)cHOICE.getValue(), null);
            }
            Assert._assert(cHOICE.getTag().equals(Tag.get(1L)));
            return new TaggedRequest(CRMF, null, (CertReqMsg)cHOICE.getValue());
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(inputStream);
        }
    }

    public static class Type {
        static Type PKCS10 = new Type();
        static Type CRMF = new Type();

        private Type() {
        }
    }
}

