/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmmf.PKIStatusInfo;
import org.mozilla.jss.pkix.crmf.CertId;

public class RevRepContent
implements ASN1Value {
    private SEQUENCE status;
    private SEQUENCE revCerts;
    private SEQUENCE crls;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;

    public SEQUENCE getStatus() {
        return this.status;
    }

    public SEQUENCE getRevCerts() {
        return this.revCerts;
    }

    public SEQUENCE getCrls() {
        return this.crls;
    }

    private RevRepContent() {
    }

    public RevRepContent(SEQUENCE sEQUENCE, SEQUENCE sEQUENCE2, SEQUENCE sEQUENCE3) {
        this.sequence = new SEQUENCE();
        this.status = sEQUENCE;
        this.sequence.addElement(sEQUENCE);
        this.revCerts = sEQUENCE2;
        this.sequence.addElement(Tag.get(0L), sEQUENCE2);
        this.crls = sEQUENCE3;
        this.sequence.addElement(Tag.get(1L), sEQUENCE3);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new SEQUENCE.OF_Template(PKIStatusInfo.getTemplate()));
            this.seqt.addOptionalElement(new SEQUENCE.OF_Template(CertId.getTemplate()));
            this.seqt.addOptionalElement(new SEQUENCE.OF_Template(ANY.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new RevRepContent((SEQUENCE)sEQUENCE.elementAt(0), (SEQUENCE)sEQUENCE.elementAt(1), (SEQUENCE)sEQUENCE.elementAt(2));
        }
    }
}

