/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class PKIPublicationInfo
implements ASN1Value {
    public static final int DONT_PUBLISH = 0;
    public static final int PLEASE_PUBLISH = 1;
    public static final int DONT_CARE = 0;
    public static final int X500 = 1;
    public static final int WEB = 2;
    public static final int LDAP = 3;
    private int action;
    private SEQUENCE pubInfos;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public int getAction() {
        return this.action;
    }

    public int numPubInfos() {
        if (this.pubInfos == null) {
            return 0;
        }
        return this.pubInfos.size();
    }

    public int getPubMethod(int n) {
        return ((INTEGER)((SEQUENCE)this.pubInfos.elementAt(n)).elementAt(0)).intValue();
    }

    public ANY getPubLocation(int n) {
        return (ANY)((SEQUENCE)this.pubInfos.elementAt(n)).elementAt(1);
    }

    private PKIPublicationInfo() {
    }

    public PKIPublicationInfo(int n, SEQUENCE sEQUENCE) {
        this.action = n;
        this.pubInfos = sEQUENCE;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(new INTEGER(this.action));
        sEQUENCE.addElement(this.pubInfos);
        sEQUENCE.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            SEQUENCE.Template template = new SEQUENCE.Template();
            template.addElement(INTEGER.getTemplate());
            template.addOptionalElement(ANY.getTemplate());
            this.seqt.addOptionalElement(new SEQUENCE.OF_Template(template));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new PKIPublicationInfo(((INTEGER)sEQUENCE.elementAt(0)).intValue(), (SEQUENCE)sEQUENCE.elementAt(1));
        }
    }
}

