/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;

public abstract class JSSMessageDigestSpi
extends MessageDigestSpi {
    private JSSMessageDigest digest;

    private JSSMessageDigestSpi() {
    }

    protected JSSMessageDigestSpi(DigestAlgorithm digestAlgorithm) {
        CryptoToken cryptoToken = TokenSupplierManager.getTokenSupplier().getThreadToken();
        try {
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken2 = cryptoManager.getInternalKeyStorageToken();
            if (((Object)cryptoToken).equals(cryptoToken2)) {
                cryptoToken = cryptoManager.getInternalCryptoToken();
            }
            try {
                this.digest = cryptoToken.getDigestContext(digestAlgorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new UnsupportedOperationException("Token '" + cryptoToken.getName() + "' does not support " + "algorithm " + digestAlgorithm.toString());
            }
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException(digestException.getMessage());
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            throw new TokenRuntimeException(notInitializedException.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public byte[] engineDigest() {
        try {
            return this.digest.digest();
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException(digestException.getMessage());
        }
    }

    public int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        return this.digest.digest(byArray, n, n2);
    }

    public int engineGetDigestLength() {
        return this.digest.getOutputSize();
    }

    public void engineReset() {
        try {
            this.digest.reset();
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException(digestException.getMessage());
        }
    }

    public void engineUpdate(byte by) {
        try {
            this.digest.update(by);
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException(digestException.getMessage());
        }
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        try {
            this.digest.update(byArray, n, n2);
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException(digestException.getMessage());
        }
    }

    public static class MD2
    extends JSSMessageDigestSpi {
        public MD2() {
            super(DigestAlgorithm.MD2);
        }
    }

    public static class MD5
    extends JSSMessageDigestSpi {
        public MD5() {
            super(DigestAlgorithm.MD5);
        }
    }

    public static class SHA512
    extends JSSMessageDigestSpi {
        public SHA512() {
            super(DigestAlgorithm.SHA512);
        }
    }

    public static class SHA384
    extends JSSMessageDigestSpi {
        public SHA384() {
            super(DigestAlgorithm.SHA384);
        }
    }

    public static class SHA256
    extends JSSMessageDigestSpi {
        public SHA256() {
            super(DigestAlgorithm.SHA256);
        }
    }

    public static class SHA1
    extends JSSMessageDigestSpi {
        public SHA1() {
            super(DigestAlgorithm.SHA1);
        }
    }
}

