/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.IncorrectPasswordException;

public class JCASymKeyGen {
    static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    byte[] plainText = "Firefox   rules!Firefox   rules!Firefox   rules!Firefox   rules!Firefox   rules!".getBytes();
    byte[] plainTextPad = "Thunderbird rules!Thunderbird rules!Thunderbird rules!Thunderbird rules!Thunderbird rules!".getBytes();
    byte[] plainTextB = "NSPR   NSS  JSS!NSPR   NSS  JSS!NSPR   NSS  JSS!".getBytes();
    byte[] plainTextPadB = "Use Firefox and Thunderbird!".getBytes();
    static boolean bFipsMode = false;

    public JCASymKeyGen(String string, String string2) {
        try {
            CryptoManager.initialize(string);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
            if (cryptoManager.FIPSEnabled()) {
                try {
                    bFipsMode = true;
                    FilePasswordCallback filePasswordCallback = new FilePasswordCallback(string2);
                    cryptoToken.login(filePasswordCallback);
                    System.out.println("Logged in");
                }
                catch (IncorrectPasswordException incorrectPasswordException) {
                    incorrectPasswordException.printStackTrace();
                    System.exit(1);
                }
                catch (TokenException tokenException) {
                    tokenException.printStackTrace();
                    System.exit(1);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.exit(1);
                }
            }
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            alreadyInitializedException.printStackTrace();
            System.exit(1);
        }
        catch (CertDatabaseException certDatabaseException) {
            certDatabaseException.printStackTrace();
            System.exit(1);
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            notInitializedException.printStackTrace();
            System.exit(1);
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
            System.exit(1);
        }
        catch (KeyDatabaseException keyDatabaseException) {
            keyDatabaseException.printStackTrace();
            System.exit(1);
        }
    }

    public SecretKey genSecretKey(String string, String string2) {
        SecretKey secretKey = null;
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(string, string2);
            if (string.equals("AES") || string.equals("RC2")) {
                keyGenerator.init(128);
            }
            System.out.println("Key " + string + " generation done by " + keyGenerator.getProvider().toString());
            secretKey = keyGenerator.generateKey();
            if (!this.checkAlgorithm(secretKey, string)) {
                throw new Exception("Error: " + secretKey.getAlgorithm() + "  algorithm");
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return secretKey;
    }

    public SecretKey genPBESecretKey(String string, String string2) {
        SecretKeyFacade secretKeyFacade = null;
        SecretKeyFactory secretKeyFactory = null;
        try {
            char[] cArray = "thunderbird".toCharArray();
            byte[] byArray = new byte[8];
            SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
            secureRandom.nextBytes(byArray);
            int n = 2;
            secretKeyFactory = SecretKeyFactory.getInstance(string, string2);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n);
            secretKeyFacade = (SecretKeyFacade)secretKeyFactory.generateSecret(pBEKeySpec);
            System.out.println("Key " + string + " generation done by " + secretKeyFactory.getProvider().toString());
            if (!bFipsMode) {
                System.out.println("The length of the generated key in bits: " + secretKeyFacade.getEncoded().length * 8 + " " + secretKeyFacade.getAlgorithm());
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return secretKeyFacade;
    }

    public void testCipher(SecretKey secretKey, String string, String string2, String string3, String string4) throws Exception {
        try {
            Object object;
            byte[] byArray;
            byte[] byArray2 = this.plainText;
            if (string2.endsWith("PKCS5Padding")) {
                byArray2 = this.plainTextPad;
            }
            Cipher cipher2 = Cipher.getInstance(string2, string3);
            AlgorithmParameters algorithmParameters = null;
            byte[] byArray3 = null;
            RC2ParameterSpec rC2ParameterSpec = null;
            if (string.compareToIgnoreCase("RC2") == 0) {
                byArray = new byte[8];
                SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
                secureRandom.nextBytes(byArray);
                rC2ParameterSpec = new RC2ParameterSpec(128, byArray);
                cipher2.init(1, (Key)secretKey, rC2ParameterSpec);
            } else {
                cipher2.init(1, secretKey);
                algorithmParameters = cipher2.getParameters();
                if (algorithmParameters != null) {
                    byArray3 = algorithmParameters.getEncoded();
                }
            }
            byArray = new byte[cipher2.getOutputSize(byArray2.length)];
            int n = cipher2.update(byArray2, 0, byArray2.length, byArray, 0);
            n += cipher2.doFinal(byArray, n);
            cipher2 = Cipher.getInstance(string2, string4);
            if (byArray3 == null) {
                if (rC2ParameterSpec != null) {
                    cipher2.init(2, (Key)secretKey, rC2ParameterSpec);
                } else {
                    cipher2.init(2, secretKey);
                }
            } else {
                object = AlgorithmParameters.getInstance(string);
                ((AlgorithmParameters)object).init(byArray3);
                cipher2.init(2, (Key)secretKey, (AlgorithmParameters)object);
            }
            object = new byte[n];
            int n2 = cipher2.update(byArray, 0, n, (byte[])object, 0);
            n2 += cipher2.doFinal((byte[])object, n2);
            boolean bl = true;
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] == object[i]) continue;
                bl = false;
                break;
            }
            if (!bl) {
                throw new Exception("ERROR: " + string3 + " and " + string4 + " failed for " + string2);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }

    public void testMultiPartCipher(SecretKey secretKey, String string, String string2, String string3, String string4) throws Exception {
        try {
            Object object;
            byte[] byArray;
            byte[] byArray2 = this.plainText;
            byte[] byArray3 = this.plainTextB;
            if (string2.endsWith("PKCS5Padding")) {
                byArray2 = this.plainTextPad;
                byArray3 = this.plainTextPadB;
            }
            Cipher cipher2 = Cipher.getInstance(string2, string3);
            AlgorithmParameters algorithmParameters = null;
            byte[] byArray4 = null;
            RC2ParameterSpec rC2ParameterSpec = null;
            if (string.compareToIgnoreCase("RC2") == 0) {
                byArray = new byte[8];
                SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
                secureRandom.nextBytes(byArray);
                rC2ParameterSpec = new RC2ParameterSpec(128, byArray);
                cipher2.init(1, (Key)secretKey, rC2ParameterSpec);
            } else {
                cipher2.init(1, secretKey);
                algorithmParameters = cipher2.getParameters();
                if (algorithmParameters != null) {
                    byArray4 = algorithmParameters.getEncoded();
                }
            }
            byArray = new byte[cipher2.getOutputSize(byArray2.length + byArray3.length)];
            int n = cipher2.update(byArray2, 0, byArray2.length, byArray, 0);
            n += cipher2.update(byArray3, 0, byArray3.length, byArray, n);
            n += cipher2.doFinal(byArray, n);
            cipher2 = Cipher.getInstance(string2, string4);
            if (byArray4 == null) {
                if (rC2ParameterSpec != null) {
                    cipher2.init(2, (Key)secretKey, rC2ParameterSpec);
                } else {
                    cipher2.init(2, secretKey);
                }
            } else {
                object = AlgorithmParameters.getInstance(string);
                ((AlgorithmParameters)object).init(byArray4);
                cipher2.init(2, (Key)secretKey, (AlgorithmParameters)object);
            }
            object = new byte[n];
            int n2 = cipher2.update(byArray, 0, n, (byte[])object, 0);
            n2 += cipher2.doFinal((byte[])object, n2);
            boolean bl = true;
            for (int i = 0; i < byArray2.length; ++i) {
                if (i < byArray2.length) {
                    if (byArray2[i] == object[i]) continue;
                    bl = false;
                    break;
                }
                if (byArray3[i - this.plainText.length] != object[i]) continue;
                bl = false;
                break;
            }
            if (!bl) {
                throw new Exception("ERROR: " + string3 + " and " + string4 + " failed for " + string2);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = ".";
        String string2 = null;
        String[][] stringArrayArray = new String[][]{{"DES", "DES/ECB/NoPadding", "DES/CBC/PKCS5Padding", "DES/CBC/NoPadding"}, {"DESede", "DESede/ECB/NoPadding", "DESede/CBC/PKCS5Padding", "DESede/CBC/NoPadding"}, {"AES", "AES/ECB/NoPadding", "AES/CBC/NoPadding", "AES/CBC/PKCS5Padding"}, {"RC2", "RC2/CBC/NoPadding", "RC2/CBC/PKCS5Padding"}, {"PBEWithMD5AndDES", "DES/ECB/NoPadding"}, {"PBEWithSHA1AndDES"}, {"PBEWithSHA1AndDESede", "DESede/ECB/NoPadding"}};
        if (stringArray.length <= 2) {
            string = stringArray[0];
            if (stringArray.length == 2) {
                string2 = stringArray[1];
            }
        } else {
            System.out.println("USAGE: java org.mozilla.jss.tests.JCASymKeyGen <certDbPath> [passwordFile]");
            System.out.println("password file only required if in FIPSMODE.");
            System.out.println("FIPSMODE requires Java 1.6 or higher!");
            System.exit(1);
        }
        String string3 = new String("IBMJCE");
        Provider provider = null;
        provider = Security.getProvider(string3);
        if (provider == null && (provider = Security.getProvider(string3 = new String("SunJCE"))) == null) {
            System.out.println("unable to find IBMJCE or SunJCE providers");
            System.exit(1);
        }
        JCASymKeyGen jCASymKeyGen = new JCASymKeyGen(string, string2);
        System.out.println(string3 + ": " + provider.getInfo());
        provider = Security.getProvider(MOZ_PROVIDER_NAME);
        System.out.println("Mozilla-JSS: " + provider.getInfo());
        SecretKey secretKey = null;
        try {
            for (int i = 0; i < stringArrayArray.length; ++i) {
                try {
                    secretKey = stringArrayArray[i][0].startsWith("PBE") ? jCASymKeyGen.genPBESecretKey(stringArrayArray[i][0], MOZ_PROVIDER_NAME) : jCASymKeyGen.genSecretKey(stringArrayArray[i][0], MOZ_PROVIDER_NAME);
                }
                catch (Exception exception) {
                    System.out.println("unable to generate key: " + stringArrayArray[i][0] + " " + exception.getMessage());
                }
                for (int j = 1; j < stringArrayArray[i].length; ++j) {
                    jCASymKeyGen.testCipher(secretKey, stringArrayArray[i][0], stringArrayArray[i][j], MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
                    jCASymKeyGen.testMultiPartCipher(secretKey, stringArrayArray[i][0], stringArrayArray[i][j], MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
                    try {
                        Cipher cipher2 = Cipher.getInstance(stringArrayArray[i][j], string3);
                    }
                    catch (Exception exception) {
                        System.out.println("Mozilla-JSS only supports " + stringArrayArray[i][j]);
                        continue;
                    }
                    if (bFipsMode) continue;
                    jCASymKeyGen.testCipher(secretKey, stringArrayArray[i][0], stringArrayArray[i][j], MOZ_PROVIDER_NAME, string3);
                    jCASymKeyGen.testMultiPartCipher(secretKey, stringArrayArray[i][0], stringArrayArray[i][j], MOZ_PROVIDER_NAME, string3);
                    jCASymKeyGen.testCipher(secretKey, stringArrayArray[i][0], stringArrayArray[i][j], string3, MOZ_PROVIDER_NAME);
                    jCASymKeyGen.testMultiPartCipher(secretKey, stringArrayArray[i][0], stringArrayArray[i][j], string3, MOZ_PROVIDER_NAME);
                    System.out.println("Mozilla-JSS and  " + string3 + " tested " + stringArrayArray[i][j]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private boolean checkAlgorithm(SecretKey secretKey, String string) {
        boolean bl = false;
        if (secretKey.getAlgorithm().equals(string)) {
            bl = true;
        }
        return bl;
    }

    private boolean checkKeyLength(SecretKey secretKey, int n) {
        boolean bl = false;
        byte[] byArray = secretKey.getEncoded();
        if (byArray.length == n) {
            bl = true;
        }
        return bl;
    }

    private String asHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Long.toString(byArray[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }
}

