/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.ConsolePasswordCallback;

public class KeyStoreTest {
    public static void printUsage() {
        System.out.println("Usage: KeyStoreTest <dbdir> <operation> [<args>...]");
        System.out.println("Operations:\ngetAliases\ndeleteEntry <alias> . . .\ngetCertByName <alias> . . .\ngetCertByDER <DER cert filename>\ngetKey <alias>\naddKey <alias>\nisTrustedCert <alias>\n");
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 2) {
                KeyStoreTest.printUsage();
                System.exit(1);
            }
            String string = stringArray[1];
            String[] stringArray2 = new String[stringArray.length - 2];
            for (int i = 2; i < stringArray.length; ++i) {
                stringArray2[i - 2] = stringArray[i];
            }
            CryptoManager.initialize(stringArray[0]);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
            try {
                cryptoToken.login(new ConsolePasswordCallback());
            }
            catch (PK11Token.NotInitializedException notInitializedException) {
                // empty catch block
            }
            cryptoManager.setThreadToken(cryptoToken);
            KeyStore keyStore = KeyStore.getInstance("Mozilla-JSS");
            keyStore.load(null, null);
            if (string.equalsIgnoreCase("getAliases")) {
                KeyStoreTest.dumpAliases(keyStore);
            } else if (string.equalsIgnoreCase("deleteEntry")) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    keyStore.deleteEntry(stringArray2[i]);
                }
            } else if (string.equalsIgnoreCase("getCertByName")) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    KeyStoreTest.dumpCert(keyStore, stringArray2[i]);
                }
            } else if (string.equalsIgnoreCase("getCertByDER")) {
                if (stringArray2.length < 1) {
                    KeyStoreTest.printUsage();
                    System.exit(1);
                }
                KeyStoreTest.getCertByDER(keyStore, stringArray2[0]);
            } else if (string.equalsIgnoreCase("getKey")) {
                if (stringArray2.length != 1) {
                    KeyStoreTest.printUsage();
                    System.exit(1);
                }
                KeyStoreTest.getKey(keyStore, stringArray2[0]);
            } else if (string.equalsIgnoreCase("isTrustedCert")) {
                if (stringArray2.length != 1) {
                    KeyStoreTest.printUsage();
                    System.exit(1);
                }
                KeyStoreTest.isTrustedCert(keyStore, stringArray2[0]);
            } else if (string.equalsIgnoreCase("addKey")) {
                if (stringArray2.length != 1) {
                    KeyStoreTest.printUsage();
                    System.exit(1);
                }
                KeyStoreTest.addKey(keyStore, stringArray2[0]);
            } else {
                KeyStoreTest.printUsage();
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public static void dumpCert(KeyStore keyStore, String string) throws Throwable {
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate == null) {
            System.out.println("Certificate with alias \"" + string + "\" not found");
        } else {
            System.out.println(certificate.toString());
        }
    }

    public static void dumpAliases(KeyStore keyStore) throws Throwable {
        Enumeration<String> enumeration = keyStore.aliases();
        System.out.println("Aliases:");
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            System.out.println("\"" + string + "\"");
        }
        System.out.println();
    }

    public static void getCertByDER(KeyStore keyStore, String string) throws Throwable {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        String string2 = keyStore.getCertificateAlias(certificate);
        if (string2 == null) {
            System.out.println("No matching certificate was found.");
        } else {
            System.out.println("Found matching certificate \"" + string2 + "\"");
        }
    }

    public static void getKey(KeyStore keyStore, String string) throws Throwable {
        Key key = keyStore.getKey(string, null);
        if (key == null) {
            System.out.println("Could not find key for alias \"" + string + "\"");
            System.exit(1);
        } else {
            String string2 = key.getClass().getName();
            System.out.println("Found " + string2 + " for alias \"" + string + "\"");
        }
    }

    public static void isTrustedCert(KeyStore keyStore, String string) throws Throwable {
        if (keyStore.isCertificateEntry(string)) {
            System.out.println("\"" + string + "\" is a trusted certificate" + " entry");
        } else {
            System.out.println("\"" + string + "\" is NOT a trusted certificate" + " entry");
        }
    }

    public static void addKey(KeyStore keyStore, String string) throws Throwable {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "Mozilla-JSS");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        Certificate[] certificateArray = new Certificate[1];
        keyStore.setKeyEntry(string, keyPair.getPrivate(), null, certificateArray);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
        KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(KeyGenAlgorithm.DES3);
        SecretKeyFacade secretKeyFacade = new SecretKeyFacade(keyGenerator.generate());
        keyStore.setKeyEntry(string + "sym", secretKeyFacade, null, null);
    }
}

