/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.CharConversionException;
import java.io.Serializable;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;
import org.mozilla.jss.util.UTF8Converter;

public class Password
implements PasswordCallback,
Cloneable,
Serializable {
    private char[] password;
    private boolean cleared;

    private Password() {
        this.cleared = true;
    }

    public Password(char[] cArray) {
        int n = cArray.length;
        this.cleared = false;
        this.password = new char[n];
        for (int i = 0; i < n; ++i) {
            this.password[i] = cArray[i];
            cArray[i] = '\u0000';
        }
    }

    public synchronized Password getPasswordFirstAttempt(PasswordCallbackInfo passwordCallbackInfo) throws PasswordCallback.GiveUpException {
        if (this.cleared) {
            throw new PasswordCallback.GiveUpException();
        }
        return (Password)this.clone();
    }

    public synchronized boolean equals(Object object) {
        if (object == null || !(object instanceof Password)) {
            return false;
        }
        Password password = (Password)object;
        if (password.password == null || this.password == null) {
            return false;
        }
        if (password.password.length != this.password.length) {
            return false;
        }
        for (int i = 0; i < this.password.length; ++i) {
            if (password.password[i] == this.password[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized Password getPasswordAgain(PasswordCallbackInfo passwordCallbackInfo) throws PasswordCallback.GiveUpException {
        throw new PasswordCallback.GiveUpException();
    }

    public synchronized char[] getChars() {
        return this.password;
    }

    public synchronized char[] getCharCopy() {
        return (char[])this.password.clone();
    }

    synchronized byte[] getByteCopy() {
        return Password.charToByte((char[])this.password.clone());
    }

    public synchronized void clear() {
        int n = this.password.length;
        for (int i = 0; i < n; ++i) {
            this.password[i] = '\u0000';
        }
        this.cleared = true;
    }

    public synchronized Object clone() {
        Password password = new Password();
        password.password = (char[])this.password.clone();
        password.cleared = this.cleared;
        return password;
    }

    protected void finalize() throws Throwable {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] charToByte(char[] cArray) {
        byte[] byArray;
        Assert._assert(cArray != null);
        try {
            byArray = UTF8Converter.UnicodeToUTF8NullTerm(cArray);
        }
        catch (CharConversionException charConversionException) {
            Assert.notReached("Password could not be converted from Unicode");
            byArray = new byte[]{0};
        }
        finally {
            Password.wipeChars(cArray);
        }
        return byArray;
    }

    public static void wipeBytes(byte[] byArray) {
        Assert._assert(byArray != null);
        UTF8Converter.wipeBytes(byArray);
    }

    public static void wipeChars(char[] cArray) {
        Assert._assert(cArray != null);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
    }

    public static synchronized native Password readPasswordFromConsole() throws PasswordCallback.GiveUpException;
}

