/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.authentication;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.CSMCaller;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.cns.authentication.PAMPrompt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;

public class CSMAuthenticator {
    private static CSMAuthenticator authenticator;
    private Process csmProcess;
    private BufferedReader in;
    private PrintWriter out;
    private String result;
    private boolean debug = false;
    private boolean authenticated = false;
    private String username = "root";
    private CSMCaller callee = null;
    private String startsWith;

    private CSMAuthenticator() {
    }

    public static CSMAuthenticator getInstance() {
        if (authenticator == null) {
            authenticator = new CSMAuthenticator();
        }
        return authenticator;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setCallback(CSMCaller callee, String startsWith) {
        this.callee = callee;
        this.startsWith = startsWith;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isUidZero() {
        String[] cmd = new String[]{"/usr/bin/id"};
        boolean result = false;
        try {
            Process uidProcess = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(uidProcess.getInputStream()));
            String line = in.readLine();
            if (line.substring(line.indexOf(61) + 1, line.indexOf(61) + 2).equals("0")) {
                result = true;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public boolean isUidZero(String username) {
        String[] cmd = new String[]{"/usr/bin/id", username};
        boolean result = false;
        try {
            Process uidProcess = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(uidProcess.getInputStream()));
            String line = in.readLine();
            if (line != "" && line != null && line.startsWith("ui") && line.substring(line.indexOf(61) + 1, line.indexOf(61) + 2).equals("0")) {
                result = true;
            }
        }
        catch (NullPointerException npe) {
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public void resetPAMPrompt() {
        this.authenticated = false;
        this.csmProcess = null;
    }

    public PAMPrompt getNextPAMPrompt(Vector responses) {
        PAMPrompt prompt;
        block29: {
            String line;
            block27: {
                block28: {
                    prompt = new PAMPrompt();
                    line = "";
                    if (this.csmProcess == null) {
                        String[] cmd = new String[]{"/usr/lib/embedded_su", this.username, "-c", "/usr/lib/patch/csm"};
                        try {
                            this.csmProcess = Runtime.getRuntime().exec(cmd);
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            e.printStackTrace();
                        }
                        this.in = new BufferedReader(new InputStreamReader(this.csmProcess.getInputStream()));
                        this.out = new PrintWriter(this.csmProcess.getOutputStream());
                        this.out.println(".");
                        this.out.flush();
                    }
                    for (int i = 0; i < responses.size(); ++i) {
                        this.out.println((String)responses.elementAt(i));
                        this.out.flush();
                    }
                    try {
                        line = this.in.readLine();
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe.getMessage());
                        ioe.printStackTrace();
                    }
                    if (!line.startsWith("SUCCESS") && !line.startsWith("ERROR")) break block27;
                    if (!line.startsWith("SUCCESS")) break block28;
                    prompt.addMessageType("SUCCESS");
                    this.authenticated = true;
                    break block29;
                }
                if (!line.startsWith("ERROR")) break block29;
                prompt.addMessageType("ERROR");
                this.authenticated = false;
                try {
                    String message = new String();
                    while ((line = this.in.readLine()) != null) {
                        if (line.startsWith("..")) {
                            line = line.substring(1, line.length());
                        } else if (line.startsWith(".")) break;
                        if (line.equals("")) {
                            message = message + line;
                            continue;
                        }
                        message = message + line + '\n';
                    }
                    if (message.endsWith("\n")) {
                        message = message.substring(0, message.length() - 1);
                    }
                    prompt.addMessage(message);
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                    ioe.printStackTrace();
                }
                break block29;
            }
            int numPrompts = Integer.parseInt(line.substring(line.indexOf(" ") + 1, line.length()));
            for (int i = 0; i < numPrompts; ++i) {
                try {
                    line = this.in.readLine();
                    if (line.startsWith("PAM_PROMPT_ECHO_OFF")) {
                        prompt.addMessageType("PAM_PROMPT_ECHO_OFF");
                    } else if (line.startsWith("PAM_PROMPT_ECHO_ON")) {
                        prompt.addMessageType("PAM_PROMPT_ECHO_ON");
                    } else if (line.startsWith("PAM_ERROR_MSG")) {
                        prompt.addMessageType("PAM_ERROR_MSG");
                    } else if (line.startsWith("PAM_TEXT_INFO")) {
                        prompt.addMessageType("PAM_TEXT_INFO");
                    }
                    String message = new String();
                    while ((line = this.in.readLine()) != null) {
                        if (line.startsWith("..")) {
                            line = line.substring(1, line.length());
                        } else if (line.startsWith(".")) break;
                        if (line.equals("")) {
                            message = message + line;
                            continue;
                        }
                        message = message + line + '\n';
                    }
                    prompt.addMessage(message);
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                    ioe.printStackTrace();
                }
            }
        }
        return prompt;
    }

    public void writeToStdin(String stdin) {
        this.out.println("STDIN");
        if (this.debug) {
            System.out.println("CSM in: STDIN");
        }
        this.out.flush();
        this.out.println(stdin);
        if (this.debug) {
            System.out.println("CSM in: " + stdin);
        }
        this.out.flush();
        this.out.println(".");
        if (this.debug) {
            System.out.println("CSM in: .");
        }
        this.out.flush();
        this.out.println("STDIN EOF");
        if (this.debug) {
            System.out.println("CSM in: STDIN EOF");
        }
        this.out.flush();
    }

    public String runCMD(String cmd, Vector args) throws CMDExecutionException, NotAuthenticatedException {
        String stdin = null;
        return this.runCMD(cmd, args, stdin);
    }

    public String runCMD(String cmd, Vector args, String stdin) throws CMDExecutionException, NotAuthenticatedException {
        String error = new String();
        int exitCode = 0;
        if (this.csmProcess == null) {
            throw new NotAuthenticatedException();
        }
        String line = "";
        try {
            line = this.in.readLine();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        if (line.startsWith("READY")) {
            for (int i = 0; i < args.size(); ++i) {
                this.out.println("ARG");
                if (this.debug) {
                    System.out.println("CSM in: ARG");
                }
                this.out.flush();
                this.out.println((String)args.elementAt(i));
                if (this.debug) {
                    System.out.println("CSM in: " + (String)args.elementAt(i));
                }
                this.out.flush();
                this.out.println(".");
                if (this.debug) {
                    System.out.println("CSM in: .");
                }
                this.out.flush();
            }
            this.out.println("RUN");
            if (this.debug) {
                System.out.println("CSM in: RUN");
            }
            this.out.flush();
            this.out.println(cmd);
            if (this.debug) {
                System.out.println("CSM in: " + cmd);
            }
            this.out.flush();
            this.out.println(".");
            if (this.debug) {
                System.out.println("CSM in: .");
            }
            this.out.flush();
            try {
                String output = this.in.readLine();
                if (this.debug) {
                    System.out.println("CSM out: " + output);
                }
                if (output.startsWith("ERROR")) {
                    int code = Integer.parseInt(output.substring(output.indexOf(" ") + 1, output.length()));
                    String msg = new String();
                    while ((output = this.in.readLine()) != null) {
                        if (output.startsWith("..")) {
                            output = output.substring(1, output.length());
                        } else if (output.startsWith(".")) break;
                        if (output.equals("")) {
                            msg = msg + output;
                            continue;
                        }
                        msg = msg + output + '\n';
                    }
                    throw new CMDExecutionException(code, msg);
                }
                if (stdin != null) {
                    this.out.println("STDIN");
                    if (this.debug) {
                        System.out.println("CSM in: STDIN");
                    }
                    this.out.flush();
                    this.out.print(stdin);
                    if (this.debug) {
                        System.out.println("CSM in: " + stdin);
                    }
                    this.out.flush();
                    this.out.println();
                    if (this.debug) {
                        System.out.println("CSM in: ");
                    }
                    this.out.flush();
                    this.out.println(".");
                    if (this.debug) {
                        System.out.println("CSM in: .");
                    }
                    this.out.flush();
                    this.out.println("STDIN EOF");
                    if (this.debug) {
                        System.out.println("CSM in: STDIN EOF");
                    }
                    this.out.flush();
                }
                this.result = new String();
                output = this.in.readLine();
                while (!output.startsWith("EXIT")) {
                    if (output.equals("STDOUT")) {
                        while ((output = this.in.readLine()) != null) {
                            if (output.startsWith("..")) {
                                output = output.substring(1, output.length());
                            } else if (output.startsWith(".")) break;
                            if (this.callee != null) {
                                if (output.startsWith(this.startsWith)) {
                                    this.callee.receiveOutput(output);
                                    continue;
                                }
                                this.result = this.result + output + '\n';
                                continue;
                            }
                            this.result = this.result + output + '\n';
                        }
                        if (this.result.endsWith("\n")) {
                            this.result = this.result.substring(0, this.result.length() - 1);
                        }
                    } else if (output.equals("STDERR")) {
                        while ((output = this.in.readLine()) != null) {
                            if (output.startsWith("..")) {
                                output = output.substring(1, output.length());
                            } else if (output.startsWith(".")) break;
                            error = error + output + '\n';
                        }
                        if (error.endsWith("\n")) {
                            error = error.substring(0, error.length() - 1);
                        }
                    } else if (output.equals("STDOUT EOF") || output.equals("STDERR EOF")) {
                        // empty if block
                    }
                    output = this.in.readLine();
                }
                if (this.result.endsWith("\n")) {
                    this.result = this.result.substring(0, this.result.length() - 1);
                }
                if (error.endsWith("\n")) {
                    error = error.substring(0, error.length() - 1);
                }
                if (this.debug) {
                    System.out.println("CSM out: " + output);
                }
                output = output.substring(output.indexOf(" ") + 1, output.length());
                output = output.trim();
                exitCode = Integer.parseInt(output);
                this.out.println("END");
                if (this.debug) {
                    System.out.println("CSM in: END");
                }
                this.out.flush();
                if (this.debug) {
                    System.out.println("STDOUT: " + this.result);
                    System.out.println("EXTVAL: " + exitCode);
                    System.out.println("STDERR: " + error);
                }
                if (exitCode != 0) {
                    throw new CMDExecutionException(exitCode, error);
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                ioe.printStackTrace();
            }
        }
        return this.result;
    }
}

