/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.engine;

import com.sun.swup.client.engine.solaris.SolarisUpdateCollection;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.interfaces.UpdateCollection;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractUpdateCollection
implements UpdateCollection {
    private String name = null;
    private String description = null;
    private List updates = new ArrayList();
    private boolean useStoredData = true;
    private static String OSNAME = System.getProperty("os.name");
    private Object useStoredDataLock = new Object();

    public static UpdateCollection getInstance(String colName) {
        UpdateCollection collection = null;
        if (OSNAME.equals("SunOS")) {
            collection = SolarisUpdateCollection.getInstance(colName);
        }
        return collection;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addUpdate(Update update) {
        this.updates.add(update);
    }

    public void removeUpdate(Update update) {
        this.updates.remove(update);
    }

    protected void initUpdateList() {
        this.updates = new ArrayList();
    }

    public Update[] getUpdates() {
        int size = this.updates.size();
        if (size == 0) {
            return null;
        }
        Update[] updateArray = new Update[size];
        for (int i = 0; i < this.updates.size(); ++i) {
            updateArray[i] = (Update)this.updates.get(i);
        }
        return updateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseStoredData(boolean stored) {
        Object object = this.useStoredDataLock;
        synchronized (object) {
            this.useStoredData = stored;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseStoredData() {
        Object object = this.useStoredDataLock;
        synchronized (object) {
            return this.useStoredData;
        }
    }

    public boolean isStored() {
        return false;
    }

    public abstract void populate() throws Throwable;

    public String toString() {
        return this.description;
    }
}

