/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.engine.solaris;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.engine.solaris.SolarisUpdateCollection;
import com.sun.swup.client.interfaces.Installer;
import com.sun.swup.client.interfaces.InstallerMessenger;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.util.List;

public class SolarisInstaller
implements Installer {
    private InstallerMessenger installerMessenger;
    private Update[] updates;
    private List installed;
    private Update[] required;
    private boolean restartRequired = false;
    private PatchProWrapper ppro = PatchProWrapper.getInstance();

    public InstallerMessenger getMessenger() {
        if (this.installerMessenger == null) {
            this.installerMessenger = new InstallerMessenger();
        }
        return this.installerMessenger;
    }

    public void beginInstall(Update[] updates) throws CMDExecutionException, NotAuthenticatedException {
        this.updates = updates;
        this.isRestartRequired();
        String[] names = new String[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            names[i] = updates[i].getName();
        }
        if (names.length > 0) {
            block4: {
                this.getMessenger().setUpdateName(names[0]);
                this.getMessenger().setUpdateNumber(1);
                this.getMessenger().setUpdateTotal(names.length);
                try {
                    this.getMessenger().setKilobytesRemaining(updates[0].getSize());
                }
                catch (NullPointerException npe) {
                    if (!UMData.getDebug()) break block4;
                    System.out.println("Unknown size for: " + names[0]);
                }
            }
            this.getMessenger().setSecondsRemaining(10);
        }
        this.ppro.update(this.updates);
        SolarisUpdateCollection.invalidateCachedData();
        this.getMessenger().installFinished();
    }

    public void cancelInstall() {
        this.ppro.getCancelAction().cancel();
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    private int calculateKilobytesRemaining(int iCounter) {
        int iKilobytes = 0;
        for (int i = iCounter; i < this.updates.length; ++i) {
            Update update = this.updates[i];
            if (this.installed.contains(update)) continue;
            try {
                iKilobytes += update.getSize().intValue();
                continue;
            }
            catch (NullPointerException npe) {
                if (!UMData.getDebug()) continue;
                System.out.println("Unknown size for: " + this.updates[i].getName());
            }
        }
        return iKilobytes;
    }

    public boolean isRestartRequired() {
        if (this.updates != null & this.updates.length > 0) {
            for (int i = 0; i < this.updates.length; ++i) {
                Update update = this.updates[i];
                if (!update.isRestartRequired().booleanValue()) continue;
                this.restartRequired = true;
            }
        }
        return this.restartRequired;
    }
}

