/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.engine.solaris;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.engine.solaris.SolarisUpdateCollection;
import com.sun.swup.client.interfaces.Uninstaller;
import com.sun.swup.client.interfaces.UninstallerMessenger;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.util.Hashtable;
import java.util.List;

public class SolarisUninstaller
implements Uninstaller {
    private UninstallerMessenger uninstallerMessenger;
    private Update[] updates;
    private List installed;
    private Update[] required;
    private boolean restartRequired;
    private static PatchProWrapper ppro = PatchProWrapper.getInstance();

    public UninstallerMessenger getMessenger() {
        if (this.uninstallerMessenger == null) {
            this.uninstallerMessenger = new UninstallerMessenger();
        }
        return this.uninstallerMessenger;
    }

    public void beginUninstall(Update[] updates) throws CMDExecutionException, NotAuthenticatedException {
        this.updates = updates;
        this.determineRestartRequired();
        String[] names = new String[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            names[i] = updates[i].getName();
        }
        if (names.length > 0) {
            this.getMessenger().setUpdateName(names[0]);
            this.getMessenger().setUpdateNumber(1);
            this.getMessenger().setUpdateTotal(names.length);
            if (updates[0].getSize() != null) {
                this.getMessenger().setKilobytesRemaining(updates[0].getSize());
            }
            this.getMessenger().setSecondsRemaining(10);
        }
        ppro.remove(this.updates);
        SolarisUpdateCollection.invalidateCachedData();
        this.getMessenger().uninstallFinished();
    }

    public Update[] getExpandedUninstallList(Update[] updates, Update[] installedUpdates) throws CMDExecutionException {
        Hashtable<String, Update> updateTable = new Hashtable<String, Update>();
        for (int i = 0; i < updates.length; ++i) {
            updateTable.put(updates[i].getUpdateID(), updates[i]);
        }
        Hashtable<String, Update> installedTable = new Hashtable<String, Update>();
        for (int i = 0; i < installedUpdates.length; ++i) {
            installedTable.put(installedUpdates[i].getUpdateID(), installedUpdates[i]);
        }
        Update[] orderedUpdates = null;
        try {
            String expandedStr = ppro.getExpandedRemoveOrder(updates).trim();
            String[] list = expandedStr.split("\n");
            orderedUpdates = new Update[list.length];
            for (int i = 0; i < list.length; ++i) {
                Update curUpdate = (Update)installedTable.get(list[i]);
                if (updateTable.containsKey(list[i])) {
                    Update[] uArray = new Update[]{curUpdate};
                    String dString = ppro.getExpandedRemoveOrder(uArray);
                    if (dString == null) {
                        orderedUpdates[i] = curUpdate;
                        continue;
                    }
                    dString = dString.trim();
                    String[] curIDs = dString.split("\n");
                    for (int ii = 0; ii < curIDs.length - 1; ++ii) {
                        if (curIDs[ii] == null || curIDs[ii].trim().length() <= 0) continue;
                        Update curDUpdate = (Update)installedTable.get(curIDs[ii]);
                        if (curUpdate.getRemoveDependencyList() != null && curUpdate.getRemoveDependencyList().contains(curDUpdate)) continue;
                        curUpdate.addRemoveDependency(curDUpdate);
                    }
                }
                orderedUpdates[i] = curUpdate;
            }
        }
        catch (NotAuthenticatedException nae) {
            // empty catch block
        }
        return orderedUpdates;
    }

    public void cancelUninstall() {
        ppro.getCancelAction().cancel();
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    private void determineRestartRequired() {
        this.setRestartRequired(false);
        for (int i = 0; i < this.updates.length; ++i) {
            Update update = this.updates[i];
            if (!update.isRestartRequired().booleanValue()) continue;
            this.setRestartRequired(true);
            break;
        }
    }

    private int calculateKilobytesRemaining(int iCounter) {
        int iKilobytes = 0;
        for (int i = iCounter; i < this.updates.length; ++i) {
            Update update = this.updates[i];
            if (this.installed.contains(update)) continue;
            iKilobytes += update.getSize().intValue();
        }
        return iKilobytes;
    }

    private String[] orderUpdates(Update[] updates) {
        return null;
    }
}

