/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.DateTableCellRenderer;
import com.sun.swup.client.ui.HistoryTableModel;
import com.sun.swup.client.ui.StatusTableCellRenderer;
import com.sun.swup.client.ui.UpdateCategorySorterCompare;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.UpdateStatusSorterCompare;
import com.sun.swup.client.ui.foundation.swing.GenericTable;
import com.sun.swup.client.ui.foundation.swing.GenericTableColumnModel;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeader;
import com.sun.swup.client.ui.foundation.swing.SorterCompare;
import com.sun.swup.client.ui.foundation.swing.StateManager;
import java.lang.ref.WeakReference;

class HistoryTable
extends GenericTable {
    private WeakReference updateFrame;

    HistoryTable(UpdateFrame updateFrame) {
        this.setUpdateFrame(updateFrame);
        this.setName("history-table");
        this.setSelectionMode(0);
        GenericTableColumnModel columnModel = new GenericTableColumnModel(this.getName());
        columnModel.addColumn(UpdateFrame.I18N.getString("history-table-name"), 2, 100);
        columnModel.addColumn(UpdateFrame.I18N.getString("history-table-synopsis"), 2);
        columnModel.addColumn(UpdateFrame.I18N.getString("history-table-category"), 2, 100);
        columnModel.addColumn(UpdateFrame.I18N.getString("history-table-status"), 2, 100);
        columnModel.addColumn(UpdateFrame.I18N.getString("history-table-date"), 4, 100);
        columnModel.getColumn(3).setCellRenderer(new StatusTableCellRenderer());
        columnModel.getColumn(4).setCellRenderer(new DateTableCellRenderer());
        Application.getInstance().getStateManager().restoreTableColumnWidths(columnModel);
        columnModel.addColumnModelListener(Application.getInstance().getStateManager());
        this.setColumnModel(columnModel);
        HistoryTableModel model = new HistoryTableModel();
        model.setColumnCount(columnModel.getColumnCount());
        this.setModel(model);
        model.getSorter().putSorterCompare(2, (SorterCompare)new UpdateCategorySorterCompare());
        model.getSorter().putSorterCompare(3, (SorterCompare)new UpdateStatusSorterCompare());
        SortedTableHeader sortedTableHeader = new SortedTableHeader(columnModel);
        this.setTableHeader(sortedTableHeader);
        StateManager stateManager = Application.getInstance().getStateManager();
        stateManager.restoreSortedTableColumn(sortedTableHeader, 4, -1);
        model.sortColumn(sortedTableHeader.getSortColumn(), sortedTableHeader.getSortDirection());
    }

    private void setUpdateFrame(UpdateFrame updateFrame) {
        this.updateFrame = new WeakReference<UpdateFrame>(updateFrame);
    }

    private UpdateFrame getUpdateFrame() {
        return (UpdateFrame)this.updateFrame.get();
    }
}

