/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.engine.solaris.SolarisUpdateCollection;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.InstallDialog;
import com.sun.swup.client.ui.InstallSummaryPanel;
import com.sun.swup.client.ui.UpdateUtility;
import com.sun.swup.client.ui.foundation.swing.GenericAction;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.GenericDialog;
import com.sun.swup.client.ui.foundation.swing.StateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

class InstallSummaryDialog
extends GenericDialog {
    static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$ui$InstallSummaryDialog == null ? (class$com$sun$swup$client$ui$InstallSummaryDialog = InstallSummaryDialog.class$("com.sun.swup.client.ui.InstallSummaryDialog")) : class$com$sun$swup$client$ui$InstallSummaryDialog, "resources/strings/install");
    private InstallSummaryPanel installSummaryPanel;
    private boolean restartSystemNow;
    private boolean restartUpdatesInstalled;
    static /* synthetic */ Class class$com$sun$swup$client$ui$InstallSummaryDialog;

    InstallSummaryDialog(Frame owner) {
        super(owner);
        this.setName("installSummary");
        this.setTitle(I18N.getString("installation-complete"));
        this.getAccessibleContext().setAccessibleName(InstallDialog.I18N.getString("installation-complete"));
        this.getAccessibleContext().setAccessibleDescription(InstallDialog.I18N.getString("installation-complete-description"));
        this.setResizable(true);
        this.setModal(false);
        this.setActionSet(new GenericActionSet());
        this.getActionSet().putAction("ok", new OKAction());
        this.getActionSet().putAction("restart-system", new RestartSystemAction());
        StateManager stateManager = Application.getInstance().getStateManager();
        stateManager.restoreWindowSize(this, new Dimension(610, 350));
        this.createComponents();
        this.createLayout();
        this.addComponentListener(Application.getInstance().getStateManager());
        this.prepareInstallSummary();
    }

    InstallSummaryPanel getInstallSummaryPanel() {
        return this.installSummaryPanel;
    }

    private void createComponents() {
        this.installSummaryPanel = new InstallSummaryPanel(this);
    }

    private void createLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.installSummaryPanel, "Center");
    }

    private void prepareInstallSummary() {
        this.getInstallSummaryPanel().getEditorPane().populate();
    }

    private void setRestartSystemNow(boolean restartSystemNow) {
        this.restartSystemNow = restartSystemNow;
    }

    private boolean getRestartSystemNow() {
        return this.restartSystemNow;
    }

    public void setRestartUpdatesInstalled(boolean restartUpdatesInstalled) {
        this.restartUpdatesInstalled = restartUpdatesInstalled;
    }

    public boolean restartUpdatesInstalled() {
        return this.restartUpdatesInstalled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RestartSystemAction
    extends GenericAction {
        RestartSystemAction() {
            super(I18N.getString("restart-system-now"), true);
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            JCheckBox restartCheckBox = (JCheckBox)e.getSource();
            boolean isSelected = restartCheckBox.isSelected();
            if (isSelected) {
                InstallSummaryDialog.this.setRestartSystemNow(true);
            } else {
                InstallSummaryDialog.this.setRestartSystemNow(false);
            }
        }
    }

    class OKAction
    extends GenericAction {
        OKAction() {
            super(I18N.getString("ok"), true);
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            int n = 1;
            if (InstallSummaryDialog.this.getRestartSystemNow()) {
                n = Application.getInstance().getUpdateFrame().showConfirmDialog(InstallSummaryDialog.this, I18N.getString("restart-system-now-question"), I18N.getString("restart-system-now-title"));
                if (n == 0) {
                    try {
                        SolarisUpdateCollection.invalidateCachedData();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    UpdateUtility.restartSystemNow();
                } else {
                    return;
                }
            }
            InstallSummaryDialog.this.setVisible(false);
            InstallSummaryDialog.this.dispose();
            if (n == 1 && InstallSummaryDialog.this.restartUpdatesInstalled) {
                JOptionPane.showMessageDialog(Application.getInstance().getUpdateFrame(), I18N.getString("restart-system-now-info-message"));
            }
        }
    }
}

