/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.InstalledTable;
import com.sun.swup.client.ui.InstalledTableModel;
import com.sun.swup.client.ui.ManagedWidthButton;
import com.sun.swup.client.ui.SymbolPanel;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.GenericAction;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import com.sun.swup.client.ui.foundation.swing.OrnamentTableHeader;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeader;
import com.sun.swup.client.ui.foundation.swing.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

class InstalledPanel
extends TabPanel {
    private WeakReference updateFrame;
    private SymbolPanel symbolPanel;
    private InstalledTable installedTable;
    private JScrollPane scrollPane;
    private JLabel messageLabel;
    private JButton uninstallButton;
    private JPanel checkPanel;
    private JButton manageButton;
    private boolean bUpdatesLoaded = false;

    InstalledPanel(UpdateFrame updateFrame) {
        super(new Insets(8, 0, 0, 0));
        this.setUpdateFrame(updateFrame);
        this.getUpdateFrame().getActionSet().putAction("uninstall", new UninstallAction());
        this.createComponents();
        this.createLayout();
        AbstractTableModel model = (AbstractTableModel)this.installedTable.getModel();
        model.addTableModelListener(new InstalledTableModelListener());
        model.fireTableDataChanged();
        this.addAncestorListener(new InstalledPanelAncestorListener());
    }

    public void setRefreshInstalledUpdates(boolean refresh) {
        boolean bl = this.bUpdatesLoaded = !refresh;
        if (refresh) {
            ((InstalledTableModel)this.installedTable.getModel()).uncheckAll();
        }
    }

    public void forceRefresh() {
        this.bUpdatesLoaded = false;
        ((InstalledTableModel)this.installedTable.getModel()).uncheckAll();
        InstalledPanelAncestorListener ipal = new InstalledPanelAncestorListener();
        AncestorEvent ae = new AncestorEvent(this, 1, null, null);
        ipal.ancestorAdded(ae);
    }

    private void createComponents() {
        this.messageLabel = new JLabel(UpdateFrame.I18N.getString("installed-message"));
        this.symbolPanel = new SymbolPanel();
        this.symbolPanel.addLabel("installed-dependencies", "dependencies.png");
        this.checkPanel = null;
        this.installedTable = new InstalledTable(this.getUpdateFrame(), this.checkPanel);
        this.scrollPane = this.installedTable.getScrollPane();
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", new OrnamentTableHeader());
        GenericActionSet actionSet = this.getUpdateFrame().getActionSet();
        this.uninstallButton = new ManagedWidthButton(actionSet.getAction("uninstall"));
        ((ManagedWidthButton)this.uninstallButton).setBestWidth(this.uninstallButton.getPreferredSize().width);
        this.uninstallButton.setOpaque(false);
        this.uninstallButton.setMnemonic(UpdateFrame.I18N.getString("installed-uninstall.mnemonic").charAt(0));
        this.manageButton = Utility.createLinkStyleButton(actionSet.getAction("manage-at-portal"));
    }

    private void createLayout() {
        InsetPanel headerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        headerPanel.setLayout(new BoxLayout(headerPanel, 1));
        this.messageLabel.setHorizontalAlignment(2);
        this.messageLabel.setAlignmentX(0.0f);
        headerPanel.add(this.messageLabel);
        headerPanel.add(Box.createRigidArea(new Dimension(1, 3)));
        this.uninstallButton.setAlignmentX(0.0f);
        headerPanel.add(this.uninstallButton);
        InsetPanel footerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        footerPanel.setLayout(new BoxLayout(footerPanel, 0));
        footerPanel.add(Box.createHorizontalGlue());
        footerPanel.add(this.manageButton);
        this.setLayout(new BorderLayout());
        this.add((Component)headerPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)footerPanel, "South");
    }

    InstalledTable getTable() {
        return this.installedTable;
    }

    private void setUpdateFrame(UpdateFrame updateFrame) {
        this.updateFrame = new WeakReference<UpdateFrame>(updateFrame);
    }

    private UpdateFrame getUpdateFrame() {
        return (UpdateFrame)this.updateFrame.get();
    }

    class InstalledPanelAncestorListener
    implements AncestorListener {
        InstalledPanelAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent e) {
            if (!InstalledPanel.this.bUpdatesLoaded) {
                try {
                    Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
                    Update[] aInstallUpdates = DataController.getInstance().getInstalledUpdates();
                    InstalledTableModel model = (InstalledTableModel)InstalledPanel.this.getTable().getModel();
                    model.setUpdates(aInstallUpdates);
                    SortedTableHeader header = (SortedTableHeader)InstalledPanel.this.getTable().getTableHeader();
                    model.sortColumn(header.getSortColumn(), header.getSortDirection());
                    model.fireTableDataChanged();
                    InstalledPanel.this.bUpdatesLoaded = true;
                    Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
                }
                catch (NotAuthenticatedException ex) {
                    AuthenticationManager.getInstance().setAction(null);
                    boolean bSuccess = AuthenticationManager.getInstance().authenticate();
                    if (bSuccess) {
                        try {
                            Update[] aInstallUpdates = DataController.getInstance().getInstalledUpdates();
                            InstalledTableModel model = (InstalledTableModel)InstalledPanel.this.getTable().getModel();
                            model.setUpdates(aInstallUpdates);
                            model.fireTableDataChanged();
                            InstalledPanel.this.bUpdatesLoaded = true;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    } else {
                        InstalledPanel.this.bUpdatesLoaded = false;
                    }
                }
                catch (Throwable throwable) {
                    InstalledPanel.this.bUpdatesLoaded = false;
                    throwable.printStackTrace();
                }
            }
        }

        public void ancestorRemoved(AncestorEvent e) {
        }

        public void ancestorMoved(AncestorEvent e) {
        }
    }

    class InstalledTableModelListener
    implements TableModelListener {
        InstalledTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            GenericActionSet actionSet = InstalledPanel.this.getUpdateFrame().getActionSet();
            InstalledTableModel model = (InstalledTableModel)InstalledPanel.this.installedTable.getModel();
            int iCheckedCount = model.getCheckedCount();
            ((UninstallAction)actionSet.getAction("uninstall")).setCount(iCheckedCount);
            if (iCheckedCount > 0) {
                actionSet.getAction("uninstall").setEnabled(true);
            } else {
                actionSet.getAction("uninstall").setEnabled(false);
            }
        }
    }

    class UninstallAction
    extends GenericAction {
        UninstallAction() {
            super("");
            this.setCount(99);
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            InstalledTableModel model = (InstalledTableModel)InstalledPanel.this.getTable().getModel();
            Update[] aUpdate = model.getCheckedUpdates();
            InstalledPanel.this.getUpdateFrame().getDelegate().setUninstallUpdates(aUpdate);
            InstalledPanel.this.getUpdateFrame().getDelegate().uninstall();
        }

        void setCount(int iCount) {
            String sString;
            if (iCount == 1) {
                sString = UpdateFrame.I18N.getString("installed-uninstall-singular");
            } else if (iCount > 1) {
                Object[] aObject = new Object[]{new Integer(iCount)};
                sString = UpdateFrame.I18N.format("installed-uninstall-plural", aObject);
            } else {
                sString = UpdateFrame.I18N.getString("installed-uninstall");
            }
            this.putValue("Name", sString);
        }
    }
}

